/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.xml;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColorTable {
    static final Map<String, Color> colorTable;
    static ColorTable singleton;

    protected ColorTable() {
    }

    public static ColorTable instance() {
        return singleton;
    }

    public Color lookupColor(String name) {
        Color obj = colorTable.get(name.toLowerCase());
        if (obj == null) {
            return null;
        }
        return obj;
    }

    public static Color parseColor(String val) {
        Color retVal = null;
        if ("".equals(val)) {
            return null;
        }
        if (val.charAt(0) == '#') {
            String hexStrn = val.substring(1);
            if (hexStrn.length() == 3) {
                hexStrn = "" + hexStrn.charAt(0) + hexStrn.charAt(0) + hexStrn.charAt(1) + hexStrn.charAt(1) + hexStrn.charAt(2) + hexStrn.charAt(2);
            }
            int hexVal = ColorTable.parseHex(hexStrn);
            retVal = new Color(hexVal);
        } else {
            String number2 = "\\s*(((\\d+)(\\.\\d*)?)|(\\.\\d+))(%)?\\s*";
            Matcher rgbMatch = Pattern.compile("rgb\\(\\s*(((\\d+)(\\.\\d*)?)|(\\.\\d+))(%)?\\s*,\\s*(((\\d+)(\\.\\d*)?)|(\\.\\d+))(%)?\\s*,\\s*(((\\d+)(\\.\\d*)?)|(\\.\\d+))(%)?\\s*\\)", 2).matcher("");
            rgbMatch.reset(val);
            if (rgbMatch.matches()) {
                float rr = Float.parseFloat(rgbMatch.group(1));
                float gg = Float.parseFloat(rgbMatch.group(7));
                float bb = Float.parseFloat(rgbMatch.group(13));
                retVal = new Color(rr /= "%".equals(rgbMatch.group(6)) ? 100.0f : 255.0f, gg /= "%".equals(rgbMatch.group(12)) ? 100.0f : 255.0f, bb /= "%".equals(rgbMatch.group(18)) ? 100.0f : 255.0f);
            } else {
                Color lookupCol = ColorTable.instance().lookupColor(val);
                if (lookupCol != null) {
                    retVal = lookupCol;
                }
            }
        }
        return retVal;
    }

    public static int parseHex(String val) {
        int retVal = 0;
        for (int i = 0; i < val.length(); ++i) {
            retVal <<= 4;
            char ch = val.charAt(i);
            if (ch >= '0' && ch <= '9') {
                retVal |= ch - 48;
                continue;
            }
            if (ch >= 'a' && ch <= 'z') {
                retVal |= ch - 97 + 10;
                continue;
            }
            if (ch >= 'A' && ch <= 'Z') {
                retVal |= ch - 65 + 10;
                continue;
            }
            throw new RuntimeException();
        }
        return retVal;
    }

    static {
        HashMap<String, Color> table2 = new HashMap<String, Color>();
        table2.put("currentcolor", new Color(0));
        table2.put("aliceblue", new Color(0xF0F8FF));
        table2.put("antiquewhite", new Color(16444375));
        table2.put("aqua", new Color(65535));
        table2.put("aquamarine", new Color(8388564));
        table2.put("azure", new Color(0xF0FFFF));
        table2.put("beige", new Color(16119260));
        table2.put("bisque", new Color(16770244));
        table2.put("black", new Color(0));
        table2.put("blanchedalmond", new Color(16772045));
        table2.put("blue", new Color(255));
        table2.put("blueviolet", new Color(9055202));
        table2.put("brown", new Color(0xA52A2A));
        table2.put("burlywood", new Color(14596231));
        table2.put("cadetblue", new Color(6266528));
        table2.put("chartreuse", new Color(0x7FFF00));
        table2.put("chocolate", new Color(13789470));
        table2.put("coral", new Color(16744272));
        table2.put("cornflowerblue", new Color(6591981));
        table2.put("cornsilk", new Color(16775388));
        table2.put("crimson", new Color(14423100));
        table2.put("cyan", new Color(65535));
        table2.put("darkblue", new Color(139));
        table2.put("darkcyan", new Color(35723));
        table2.put("darkgoldenrod", new Color(12092939));
        table2.put("darkgray", new Color(0xA9A9A9));
        table2.put("darkgreen", new Color(25600));
        table2.put("darkkhaki", new Color(12433259));
        table2.put("darkmagenta", new Color(0x8B008B));
        table2.put("darkolivegreen", new Color(5597999));
        table2.put("darkorange", new Color(16747520));
        table2.put("darkorchid", new Color(10040012));
        table2.put("darkred", new Color(0x8B0000));
        table2.put("darksalmon", new Color(15308410));
        table2.put("darkseagreen", new Color(9419919));
        table2.put("darkslateblue", new Color(4734347));
        table2.put("darkslategray", new Color(0x2F4F4F));
        table2.put("darkturquoise", new Color(52945));
        table2.put("darkviolet", new Color(9699539));
        table2.put("deeppink", new Color(16716947));
        table2.put("deepskyblue", new Color(49151));
        table2.put("dimgray", new Color(0x696969));
        table2.put("dodgerblue", new Color(2003199));
        table2.put("feldspar", new Color(13734517));
        table2.put("firebrick", new Color(0xB22222));
        table2.put("floralwhite", new Color(0xFFFAF0));
        table2.put("forestgreen", new Color(0x228B22));
        table2.put("fuchsia", new Color(0xFF00FF));
        table2.put("gainsboro", new Color(0xDCDCDC));
        table2.put("ghostwhite", new Color(0xF8F8FF));
        table2.put("gold", new Color(16766720));
        table2.put("goldenrod", new Color(14329120));
        table2.put("gray", new Color(0x808080));
        table2.put("green", new Color(32768));
        table2.put("greenyellow", new Color(11403055));
        table2.put("honeydew", new Color(0xF0FFF0));
        table2.put("hotpink", new Color(16738740));
        table2.put("indianred", new Color(0xCD5C5C));
        table2.put("indigo", new Color(4915330));
        table2.put("ivory", new Color(0xFFFFF0));
        table2.put("khaki", new Color(15787660));
        table2.put("lavender", new Color(15132410));
        table2.put("lavenderblush", new Color(0xFFF0F5));
        table2.put("lawngreen", new Color(8190976));
        table2.put("lemonchiffon", new Color(16775885));
        table2.put("lightblue", new Color(11393254));
        table2.put("lightcoral", new Color(0xF08080));
        table2.put("lightcyan", new Color(0xE0FFFF));
        table2.put("lightgoldenrodyellow", new Color(16448210));
        table2.put("lightgrey", new Color(0xD3D3D3));
        table2.put("lightgreen", new Color(0x90EE90));
        table2.put("lightpink", new Color(16758465));
        table2.put("lightsalmon", new Color(16752762));
        table2.put("lightseagreen", new Color(2142890));
        table2.put("lightskyblue", new Color(8900346));
        table2.put("lightslateblue", new Color(8679679));
        table2.put("lightslategray", new Color(0x778899));
        table2.put("lightsteelblue", new Color(11584734));
        table2.put("lightyellow", new Color(0xFFFFE0));
        table2.put("lime", new Color(65280));
        table2.put("limegreen", new Color(3329330));
        table2.put("linen", new Color(16445670));
        table2.put("magenta", new Color(0xFF00FF));
        table2.put("maroon", new Color(0x800000));
        table2.put("mediumaquamarine", new Color(6737322));
        table2.put("mediumblue", new Color(205));
        table2.put("mediumorchid", new Color(12211667));
        table2.put("mediumpurple", new Color(9662680));
        table2.put("mediumseagreen", new Color(3978097));
        table2.put("mediumslateblue", new Color(8087790));
        table2.put("mediumspringgreen", new Color(64154));
        table2.put("mediumturquoise", new Color(4772300));
        table2.put("mediumvioletred", new Color(13047173));
        table2.put("midnightblue", new Color(1644912));
        table2.put("mintcream", new Color(0xF5FFFA));
        table2.put("mistyrose", new Color(16770273));
        table2.put("moccasin", new Color(16770229));
        table2.put("navajowhite", new Color(16768685));
        table2.put("navy", new Color(128));
        table2.put("oldlace", new Color(16643558));
        table2.put("olive", new Color(0x808000));
        table2.put("olivedrab", new Color(7048739));
        table2.put("orange", new Color(16753920));
        table2.put("orangered", new Color(16729344));
        table2.put("orchid", new Color(14315734));
        table2.put("palegoldenrod", new Color(0xEEE8AA));
        table2.put("palegreen", new Color(10025880));
        table2.put("paleturquoise", new Color(0xAFEEEE));
        table2.put("palevioletred", new Color(14184595));
        table2.put("papayawhip", new Color(16773077));
        table2.put("peachpuff", new Color(16767673));
        table2.put("peru", new Color(13468991));
        table2.put("pink", new Color(16761035));
        table2.put("plum", new Color(0xDDA0DD));
        table2.put("powderblue", new Color(11591910));
        table2.put("purple", new Color(0x800080));
        table2.put("red", new Color(0xFF0000));
        table2.put("rosybrown", new Color(12357519));
        table2.put("royalblue", new Color(4286945));
        table2.put("saddlebrown", new Color(9127187));
        table2.put("salmon", new Color(16416882));
        table2.put("sandybrown", new Color(16032864));
        table2.put("seagreen", new Color(3050327));
        table2.put("seashell", new Color(0xFFF5EE));
        table2.put("sienna", new Color(10506797));
        table2.put("silver", new Color(0xC0C0C0));
        table2.put("skyblue", new Color(8900331));
        table2.put("slateblue", new Color(6970061));
        table2.put("slategray", new Color(7372944));
        table2.put("snow", new Color(0xFFFAFA));
        table2.put("springgreen", new Color(65407));
        table2.put("steelblue", new Color(4620980));
        table2.put("tan", new Color(13808780));
        table2.put("teal", new Color(32896));
        table2.put("thistle", new Color(14204888));
        table2.put("tomato", new Color(16737095));
        table2.put("turquoise", new Color(4251856));
        table2.put("violet", new Color(0xEE82EE));
        table2.put("violetred", new Color(13639824));
        table2.put("wheat", new Color(16113331));
        table2.put("white", new Color(0xFFFFFF));
        table2.put("whitesmoke", new Color(0xF5F5F5));
        table2.put("yellow", new Color(0xFFFF00));
        table2.put("yellowgreen", new Color(10145074));
        colorTable = Collections.unmodifiableMap(table2);
        singleton = new ColorTable();
    }
}

