/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser.clipper;

import com.itextpdf.text.pdf.parser.clipper.LongRect;
import com.itextpdf.text.pdf.parser.clipper.Path;
import com.itextpdf.text.pdf.parser.clipper.Point;
import com.itextpdf.text.pdf.parser.clipper.PolyNode;
import com.itextpdf.text.pdf.parser.clipper.PolyTree;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paths
extends ArrayList<Path> {
    private static final long serialVersionUID = 1910552127810480852L;

    public static Paths closedPathsFromPolyTree(PolyTree polytree) {
        Paths result2 = new Paths();
        result2.addPolyNode(polytree, PolyNode.NodeType.CLOSED);
        return result2;
    }

    public static Paths makePolyTreeToPaths(PolyTree polytree) {
        Paths result2 = new Paths();
        result2.addPolyNode(polytree, PolyNode.NodeType.ANY);
        return result2;
    }

    public static Paths openPathsFromPolyTree(PolyTree polytree) {
        Paths result2 = new Paths();
        for (PolyNode c : polytree.getChilds()) {
            if (!c.isOpen()) continue;
            result2.add(c.getPolygon());
        }
        return result2;
    }

    public Paths() {
    }

    public Paths(int initialCapacity) {
        super(initialCapacity);
    }

    public void addPolyNode(PolyNode polynode, PolyNode.NodeType nt) {
        boolean match2 = true;
        switch (nt) {
            case OPEN: {
                return;
            }
            case CLOSED: {
                match2 = !polynode.isOpen();
                break;
            }
        }
        if (polynode.getPolygon().size() > 0 && match2) {
            this.add(polynode.getPolygon());
        }
        for (PolyNode pn : polynode.getChilds()) {
            this.addPolyNode(pn, nt);
        }
    }

    public Paths cleanPolygons() {
        return this.cleanPolygons(1.415);
    }

    public Paths cleanPolygons(double distance) {
        Paths result2 = new Paths(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result2.add(((Path)this.get(i)).cleanPolygon(distance));
        }
        return result2;
    }

    public LongRect getBounds() {
        int i;
        int cnt = this.size();
        LongRect result2 = new LongRect();
        for (i = 0; i < cnt && ((Path)this.get(i)).isEmpty(); ++i) {
        }
        if (i == cnt) {
            return result2;
        }
        result2.right = result2.left = ((Point.LongPoint)((Path)this.get(i)).get(0)).getX();
        result2.bottom = result2.top = ((Point.LongPoint)((Path)this.get(i)).get(0)).getY();
        while (i < cnt) {
            for (int j = 0; j < ((Path)this.get(i)).size(); ++j) {
                if (((Point.LongPoint)((Path)this.get(i)).get(j)).getX() < result2.left) {
                    result2.left = ((Point.LongPoint)((Path)this.get(i)).get(j)).getX();
                } else if (((Point.LongPoint)((Path)this.get(i)).get(j)).getX() > result2.right) {
                    result2.right = ((Point.LongPoint)((Path)this.get(i)).get(j)).getX();
                }
                if (((Point.LongPoint)((Path)this.get(i)).get(j)).getY() < result2.top) {
                    result2.top = ((Point.LongPoint)((Path)this.get(i)).get(j)).getY();
                    continue;
                }
                if (((Point.LongPoint)((Path)this.get(i)).get(j)).getY() <= result2.bottom) continue;
                result2.bottom = ((Point.LongPoint)((Path)this.get(i)).get(j)).getY();
            }
            ++i;
        }
        return result2;
    }

    public void reversePaths() {
        for (Path poly : this) {
            poly.reverse();
        }
    }
}

