/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Utilities;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.Glyph;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfEncodings;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.TrueTypeFont;
import com.itextpdf.text.pdf.fonts.otf.GlyphSubstitutionTableReader;
import com.itextpdf.text.pdf.fonts.otf.Language;
import com.itextpdf.text.pdf.languages.ArabicLigaturizer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TrueTypeFontUnicode
extends TrueTypeFont
implements Comparator<int[]> {
    private static final List<Language> SUPPORTED_LANGUAGES_FOR_OTF = Arrays.asList(Language.BENGALI);
    private Map<String, Glyph> glyphSubstitutionMap;
    private Language supportedLanguage;
    private static final byte[] rotbits = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};

    TrueTypeFontUnicode(String ttFile, String enc, boolean emb, byte[] ttfAfm, boolean forceRead) throws DocumentException, IOException {
        String nameBase = TrueTypeFontUnicode.getBaseName(ttFile);
        String ttcName = TrueTypeFontUnicode.getTTCName(nameBase);
        if (nameBase.length() < ttFile.length()) {
            this.style = ttFile.substring(nameBase.length());
        }
        this.encoding = enc;
        this.embedded = emb;
        this.fileName = ttcName;
        this.ttcIndex = "";
        if (ttcName.length() < nameBase.length()) {
            this.ttcIndex = nameBase.substring(ttcName.length() + 1);
        }
        this.fontType = 3;
        if ((this.fileName.toLowerCase().endsWith(".ttf") || this.fileName.toLowerCase().endsWith(".otf") || this.fileName.toLowerCase().endsWith(".ttc")) && (enc.equals("Identity-H") || enc.equals("Identity-V")) && emb) {
            this.process(ttfAfm, forceRead);
            if (this.os_2.fsType == 2) {
                throw new DocumentException(MessageLocalization.getComposedMessage("1.cannot.be.embedded.due.to.licensing.restrictions", this.fileName + this.style));
            }
            if (this.cmap31 == null && !this.fontSpecific || this.cmap10 == null && this.fontSpecific) {
                this.directTextToByte = true;
            }
            if (this.fontSpecific) {
                this.fontSpecific = false;
                String tempEncoding = this.encoding;
                this.encoding = "";
                this.createEncoding();
                this.encoding = tempEncoding;
                this.fontSpecific = true;
            }
        } else {
            throw new DocumentException(MessageLocalization.getComposedMessage("1.2.is.not.a.ttf.font.file", this.fileName, this.style));
        }
        this.vertical = enc.endsWith("V");
    }

    @Override
    void process(byte[] ttfAfm, boolean preload) throws DocumentException, IOException {
        super.process(ttfAfm, preload);
    }

    @Override
    public int getWidth(int char1) {
        if (this.vertical) {
            return 1000;
        }
        if (this.fontSpecific) {
            if ((char1 & 0xFF00) == 0 || (char1 & 0xFF00) == 61440) {
                return this.getRawWidth(char1 & 0xFF, null);
            }
            return 0;
        }
        return this.getRawWidth(char1, this.encoding);
    }

    @Override
    public int getWidth(String text) {
        if (this.vertical) {
            return text.length() * 1000;
        }
        int total = 0;
        if (this.fontSpecific) {
            for (char c : text.toCharArray()) {
                if ((c & 0xFF00) != 0 && (c & 0xFF00) != 61440) continue;
                total += this.getRawWidth(c & 0xFF, null);
            }
        } else {
            int len = text.length();
            for (int k = 0; k < len; ++k) {
                if (Utilities.isSurrogatePair(text, k)) {
                    total += this.getRawWidth(Utilities.convertToUtf32(text, k), this.encoding);
                    ++k;
                    continue;
                }
                total += this.getRawWidth(text.charAt(k), this.encoding);
            }
        }
        return total;
    }

    public PdfStream getToUnicode(Object[] metrics) {
        if (metrics.length == 0) {
            return null;
        }
        StringBuffer buf2 = new StringBuffer("/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n<< /Registry (TTX+0)\n/Ordering (T42UV)\n/Supplement 0\n>> def\n/CMapName /TTX+0 def\n/CMapType 2 def\n1 begincodespacerange\n<0000><FFFF>\nendcodespacerange\n");
        int size = 0;
        for (int k = 0; k < metrics.length; ++k) {
            if (size == 0) {
                if (k != 0) {
                    buf2.append("endbfrange\n");
                }
                size = Math.min(100, metrics.length - k);
                buf2.append(size).append(" beginbfrange\n");
            }
            --size;
            int[] metric = (int[])metrics[k];
            String fromTo = TrueTypeFontUnicode.toHex(metric[0]);
            buf2.append(fromTo).append(fromTo).append(TrueTypeFontUnicode.toHex(metric[2])).append('\n');
        }
        buf2.append("endbfrange\nendcmap\nCMapName currentdict /CMap defineresource pop\nend end\n");
        String s = buf2.toString();
        PdfStream stream = new PdfStream(PdfEncodings.convertToBytes(s, null));
        stream.flateCompress(this.compressionLevel);
        return stream;
    }

    private static String toHex4(int n) {
        String s = "0000" + Integer.toHexString(n);
        return s.substring(s.length() - 4);
    }

    static String toHex(int n) {
        if (n < 65536) {
            return "<" + TrueTypeFontUnicode.toHex4(n) + ">";
        }
        int high = (n -= 65536) / 1024 + 55296;
        int low = n % 1024 + 56320;
        return "[<" + TrueTypeFontUnicode.toHex4(high) + TrueTypeFontUnicode.toHex4(low) + ">]";
    }

    public PdfDictionary getCIDFontType2(PdfIndirectReference fontDescriptor, String subsetPrefix, Object[] metrics) {
        PdfDictionary dic = new PdfDictionary(PdfName.FONT);
        if (this.cff) {
            dic.put(PdfName.SUBTYPE, PdfName.CIDFONTTYPE0);
            dic.put(PdfName.BASEFONT, new PdfName(subsetPrefix + this.fontName + "-" + this.encoding));
        } else {
            dic.put(PdfName.SUBTYPE, PdfName.CIDFONTTYPE2);
            dic.put(PdfName.BASEFONT, new PdfName(subsetPrefix + this.fontName));
        }
        dic.put(PdfName.FONTDESCRIPTOR, fontDescriptor);
        if (!this.cff) {
            dic.put(PdfName.CIDTOGIDMAP, PdfName.IDENTITY);
        }
        PdfDictionary cdic = new PdfDictionary();
        cdic.put(PdfName.REGISTRY, new PdfString("Adobe"));
        cdic.put(PdfName.ORDERING, new PdfString("Identity"));
        cdic.put(PdfName.SUPPLEMENT, new PdfNumber(0));
        dic.put(PdfName.CIDSYSTEMINFO, cdic);
        if (!this.vertical) {
            dic.put(PdfName.DW, new PdfNumber(1000));
            StringBuffer buf2 = new StringBuffer("[");
            int lastNumber = -10;
            boolean firstTime = true;
            for (int k = 0; k < metrics.length; ++k) {
                int[] metric = (int[])metrics[k];
                if (metric[1] == 1000) continue;
                int m = metric[0];
                if (m == lastNumber + 1) {
                    buf2.append(' ').append(metric[1]);
                } else {
                    if (!firstTime) {
                        buf2.append(']');
                    }
                    firstTime = false;
                    buf2.append(m).append('[').append(metric[1]);
                }
                lastNumber = m;
            }
            if (buf2.length() > 1) {
                buf2.append("]]");
                dic.put(PdfName.W, new PdfLiteral(buf2.toString()));
            }
        }
        return dic;
    }

    public PdfDictionary getFontBaseType(PdfIndirectReference descendant, String subsetPrefix, PdfIndirectReference toUnicode) {
        PdfDictionary dic = new PdfDictionary(PdfName.FONT);
        dic.put(PdfName.SUBTYPE, PdfName.TYPE0);
        if (this.cff) {
            dic.put(PdfName.BASEFONT, new PdfName(subsetPrefix + this.fontName + "-" + this.encoding));
        } else {
            dic.put(PdfName.BASEFONT, new PdfName(subsetPrefix + this.fontName));
        }
        dic.put(PdfName.ENCODING, new PdfName(this.encoding));
        dic.put(PdfName.DESCENDANTFONTS, new PdfArray(descendant));
        if (toUnicode != null) {
            dic.put(PdfName.TOUNICODE, toUnicode);
        }
        return dic;
    }

    public int GetCharFromGlyphId(int gid) {
        if (this.glyphIdToChar == null) {
            int[] g2 = new int[this.maxGlyphId];
            HashMap map = null;
            if (this.cmapExt != null) {
                map = this.cmapExt;
            } else if (this.cmap31 != null) {
                map = this.cmap31;
            }
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    g2[((int[])entry.getValue())[0]] = (Integer)entry.getKey();
                }
            }
            this.glyphIdToChar = g2;
        }
        return this.glyphIdToChar[gid];
    }

    @Override
    public int compare(int[] o1, int[] o2) {
        int m1 = o1[0];
        int m2 = o2[0];
        if (m1 < m2) {
            return -1;
        }
        if (m1 == m2) {
            return 0;
        }
        return 1;
    }

    @Override
    void writeFont(PdfWriter writer, PdfIndirectReference ref, Object[] params) throws DocumentException, IOException {
        writer.getTtfUnicodeWriter().writeFont(this, ref, params, rotbits);
    }

    @Override
    public PdfStream getFullFontStream() throws IOException, DocumentException {
        if (this.cff) {
            return new BaseFont.StreamFont(this.readCffFont(), "CIDFontType0C", this.compressionLevel);
        }
        return super.getFullFontStream();
    }

    @Override
    public byte[] convertToBytes(String text) {
        return null;
    }

    @Override
    byte[] convertToBytes(int char1) {
        return null;
    }

    @Override
    public int[] getMetricsTT(int c) {
        Character ch;
        if (this.cmapExt != null) {
            return (int[])this.cmapExt.get(c);
        }
        HashMap map = null;
        map = this.fontSpecific ? this.cmap10 : this.cmap31;
        if (map == null) {
            return null;
        }
        if (this.fontSpecific) {
            if ((c & 0xFFFFFF00) == 0 || (c & 0xFFFFFF00) == 61440) {
                return (int[])map.get(c & 0xFF);
            }
            return null;
        }
        int[] result2 = (int[])map.get(c);
        if (result2 == null && (ch = ArabicLigaturizer.getReverseMapping((char)c)) != null) {
            result2 = (int[])map.get(ch.charValue());
        }
        return result2;
    }

    @Override
    public boolean charExists(int c) {
        return this.getMetricsTT(c) != null;
    }

    @Override
    public boolean setCharAdvance(int c, int advance) {
        int[] m = this.getMetricsTT(c);
        if (m == null) {
            return false;
        }
        m[1] = advance;
        return true;
    }

    @Override
    public int[] getCharBBox(int c) {
        if (this.bboxes == null) {
            return null;
        }
        int[] m = this.getMetricsTT(c);
        if (m == null) {
            return null;
        }
        return this.bboxes[m[0]];
    }

    protected Map<String, Glyph> getGlyphSubstitutionMap() {
        return this.glyphSubstitutionMap;
    }

    Language getSupportedLanguage() {
        return this.supportedLanguage;
    }

    private void readGsubTable() throws IOException {
        if (this.tables.get("GSUB") != null) {
            HashMap<Integer, Character> glyphToCharacterMap = new HashMap<Integer, Character>(this.cmap31.size());
            for (Integer charCode : this.cmap31.keySet()) {
                char c = (char)charCode.intValue();
                int glyphCode = ((int[])this.cmap31.get(charCode))[0];
                glyphToCharacterMap.put(glyphCode, Character.valueOf(c));
            }
            GlyphSubstitutionTableReader gsubReader = new GlyphSubstitutionTableReader(this.rf, ((int[])this.tables.get("GSUB"))[0], glyphToCharacterMap, this.glyphWidthsByIndex);
            try {
                gsubReader.read();
                this.supportedLanguage = gsubReader.getSupportedLanguage();
                if (SUPPORTED_LANGUAGES_FOR_OTF.contains((Object)this.supportedLanguage)) {
                    this.glyphSubstitutionMap = gsubReader.getGlyphSubstitutionMap();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

