/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.api.annotations.NotNull;
import com.alee.utils.TextUtils;
import com.alee.utils.swing.Scale;
import com.alee.utils.xml.XmlException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.util.List;

public class ScaleConverter
extends AbstractSingleValueConverter {
    @Override
    public boolean canConvert(@NotNull Class type) {
        return Scale.class.isAssignableFrom(type);
    }

    @Override
    public String toString(@NotNull Object obj) {
        return ScaleConverter.pointToString((Scale)obj);
    }

    @Override
    public Object fromString(@NotNull String str) {
        return ScaleConverter.pointFromString(str);
    }

    @NotNull
    public static String pointToString(@NotNull Scale point) {
        return point.getX() + "," + point.getY();
    }

    @NotNull
    public static Scale pointFromString(@NotNull String point) {
        try {
            List<String> points = TextUtils.stringToList(point, ",");
            double x = Double.parseDouble(points.get(0));
            double y = Double.parseDouble(points.get(1));
            return new Scale(x, y);
        }
        catch (Exception e) {
            throw new XmlException("Unable to parse Scale: " + point, e);
        }
    }
}

