/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.api.annotations.NotNull;
import com.alee.utils.swing.InsetsUIResource;
import com.alee.utils.xml.ConverterContext;
import com.alee.utils.xml.XmlException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Insets;
import java.util.StringTokenizer;

public class InsetsConverter
extends AbstractSingleValueConverter {
    public static final String separator = ",";

    @Override
    public boolean canConvert(@NotNull Class type) {
        return Insets.class.isAssignableFrom(type);
    }

    @Override
    public String toString(@NotNull Object insets) {
        return InsetsConverter.insetsToString((Insets)insets);
    }

    @Override
    public Object fromString(@NotNull String string) {
        Insets insets = InsetsConverter.insetsFromString(string);
        return ConverterContext.get().isUIResource() ? new InsetsUIResource(insets) : insets;
    }

    @NotNull
    public static String insetsToString(@NotNull Insets insets) {
        String string = insets.top == insets.left && insets.left == insets.bottom && insets.bottom == insets.right ? Integer.toString(insets.top) : insets.top + separator + insets.left + separator + insets.bottom + separator + insets.right;
        return string;
    }

    @NotNull
    public static Insets insetsFromString(@NotNull String string) {
        try {
            Insets insets;
            StringTokenizer tokenizer = new StringTokenizer(string, separator, false);
            if (tokenizer.hasMoreTokens()) {
                int top = Integer.parseInt(tokenizer.nextToken().trim());
                if (tokenizer.hasMoreTokens()) {
                    int left = Integer.parseInt(tokenizer.nextToken().trim());
                    if (tokenizer.hasMoreTokens()) {
                        int bottom = Integer.parseInt(tokenizer.nextToken().trim());
                        int right = Integer.parseInt(tokenizer.nextToken().trim());
                        insets = new Insets(top, left, bottom, right);
                    } else {
                        insets = new Insets(top, left, top, left);
                    }
                } else {
                    insets = new Insets(top, top, top, top);
                }
            } else {
                insets = new Insets(0, 0, 0, 0);
            }
            return insets;
        }
        catch (Exception e) {
            throw new XmlException("Unable to parse Insets: " + string, e);
        }
    }
}

