/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.system;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SystemUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

public final class JavaVersion {
    private static final Pattern versionPattern = Pattern.compile("(\\d+\\.\\d+)(\\.(\\d+))?(_([^-]+))?(.*)");
    private static final Pattern simpleVersionPattern = Pattern.compile("(\\d+\\.\\d+)(\\.(\\d+))?(.*)");
    private final double major;
    private final int minor;
    private final int update;
    @Nullable
    private final String patch;

    public JavaVersion(double major, int update) {
        this(major, 0, update);
    }

    public JavaVersion(double major, int minor, int update) {
        this(major, minor, update, null);
    }

    public JavaVersion(double major, int minor, int update, @Nullable String patch) {
        this.major = major;
        this.minor = minor;
        this.update = update;
        this.patch = patch;
    }

    public JavaVersion() {
        boolean read;
        String patch;
        int update;
        int minor;
        double major;
        block17: {
            major = 0.0;
            minor = 0;
            update = 0;
            patch = null;
            read = false;
            try {
                Object version = ReflectUtils.callStaticMethod(Runtime.class, "version", new Object[0]);
                try {
                    Object majorNumber = ReflectUtils.callMethod(version, "major", new Object[0]);
                    major = majorNumber instanceof Integer ? (double)((Integer)majorNumber).intValue() : 0.0;
                    Object minorNumber = ReflectUtils.callMethod(version, "minor", new Object[0]);
                    minor = minorNumber instanceof Integer ? (Integer)minorNumber : 0;
                    Object updateNumber = ReflectUtils.callMethod(version, "security", new Object[0]);
                    update = updateNumber instanceof Integer ? (Integer)updateNumber : 0;
                    Object optional = ReflectUtils.callMethod(version, "optional", new Object[0]);
                    patch = optional != null ? (String)ReflectUtils.callMethod(optional, "orElse", new Object[]{null}) : null;
                    read = true;
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(JavaVersion.class).error("Unable to read Runtime version", e);
                }
            }
            catch (Exception version) {
                // empty catch block
            }
            if (!read) {
                String versionString = SystemUtils.getJavaVersionString();
                try {
                    String s;
                    Matcher matcher = versionPattern.matcher(versionString);
                    if (!matcher.matches()) break block17;
                    int groups = matcher.groupCount();
                    major = Double.parseDouble(matcher.group(1));
                    if (groups >= 3 && matcher.group(3) != null) {
                        minor = Integer.parseInt(matcher.group(3));
                    }
                    if (groups >= 5 && matcher.group(5) != null) {
                        try {
                            update = Integer.parseInt(matcher.group(5));
                        }
                        catch (NumberFormatException e) {
                            patch = matcher.group(5);
                        }
                    }
                    if (groups >= 6 && matcher.group(6) != null && (s = matcher.group(6)) != null && s.trim().length() > 0) {
                        patch = s;
                    }
                    read = true;
                }
                catch (NumberFormatException e) {
                    try {
                        Matcher matcher = simpleVersionPattern.matcher(versionString);
                        if (matcher.matches()) {
                            int groups = matcher.groupCount();
                            major = Double.parseDouble(matcher.group(1));
                            if (groups >= 3 && matcher.group(3) != null) {
                                minor = Integer.parseInt(matcher.group(3));
                            }
                        }
                        read = true;
                    }
                    catch (NumberFormatException e1) {
                        major = 1.4;
                        minor = 0;
                        update = 0;
                        read = true;
                    }
                }
            }
        }
        if (!read) {
            throw new RuntimeException("Unable to determine Java runtime version");
        }
        this.major = major;
        this.minor = minor;
        this.update = update;
        this.patch = patch;
    }

    public double major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int update() {
        return this.update;
    }

    @Nullable
    public String patch() {
        return this.patch;
    }

    public int compareTo(JavaVersion version) {
        return this.compareTo(version.major(), version.minor(), version.update());
    }

    public int compareTo(double major, int minor, int update) {
        int minorResult;
        double majorResult = this.major - major;
        int result2 = majorResult != 0.0 ? (majorResult < 0.0 ? -1 : 1) : ((minorResult = this.minor - minor) != 0 ? minorResult : this.update - update);
        return result2;
    }

    @NotNull
    public String versionString() {
        StringBuilder version = new StringBuilder();
        if (this.major() < 9.0) {
            version.append(this.major());
            version.append(".");
            version.append(this.minor());
            version.append(" u").append(this.update());
        } else {
            version.append(Math.round(this.major()));
            version.append(".");
            version.append(this.minor());
            version.append(".");
            version.append(this.update());
        }
        return version.toString();
    }

    public int hashCode() {
        return Objects.hash(this.major(), this.minor(), this.update(), this.patch());
    }

    @NotNull
    public String toString() {
        StringBuilder version = new StringBuilder("Java ");
        version.append(this.versionString());
        if (this.patch() != null) {
            version.append(" (");
            version.append(this.patch());
            version.append(")");
        }
        return version.toString();
    }
}

