/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing.menu;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.resource.ClassResource;
import com.alee.api.resource.FileResource;
import com.alee.api.resource.Resource;
import com.alee.api.resource.UrlResource;
import com.alee.laf.menu.WebCheckBoxMenuItem;
import com.alee.laf.menu.WebMenu;
import com.alee.laf.menu.WebMenuItem;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.menu.WebRadioButtonMenuItem;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.language.LM;
import com.alee.managers.style.StyleId;
import com.alee.utils.ImageUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.swing.UnselectableButtonGroup;
import com.alee.utils.swing.menu.MenuGenerator;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public abstract class AbstractMenuGenerator<C extends JComponent> {
    protected static final StyleId defaultStyleId = StyleId.auto;
    protected static final Object defaultIcon = null;
    protected static final HotkeyData defaultHotkey = null;
    protected static final boolean defaultEnabled = true;
    protected static final ActionListener defaultAction = null;
    @Nullable
    protected Class nearClass;
    @Nullable
    protected String path;
    @Nullable
    protected String extension;
    @Nullable
    protected String languagePrefix;
    @Nullable
    protected UnselectableButtonGroup group;
    @NotNull
    protected final C menu;

    public AbstractMenuGenerator(@NotNull C menu) {
        this.menu = menu;
    }

    @Nullable
    public Class getNearClass() {
        return this.nearClass;
    }

    public void setNearClass(@Nullable Class nearClass) {
        this.nearClass = nearClass;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public void setPath(@Nullable String path) {
        this.path = path;
    }

    @Nullable
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(@Nullable String extension2) {
        this.extension = extension2 == null ? null : (extension2.startsWith(".") ? extension2 : "." + extension2);
    }

    public void setIconSettings(@Nullable String path, @Nullable String extension2) {
        this.setIconSettings(null, path, extension2);
    }

    public void setIconSettings(@Nullable Class nearClass, @Nullable String path, @Nullable String extension2) {
        this.setNearClass(nearClass);
        this.setPath(path);
        this.setExtension(extension2);
    }

    @Nullable
    public String getLanguagePrefix() {
        return this.languagePrefix;
    }

    public void setLanguagePrefix(@Nullable String prefix) {
        this.languagePrefix = TextUtils.notEmpty(prefix) ? prefix : null;
    }

    @Nullable
    public String getLanguageKey(@Nullable String text) {
        String key;
        String prefix;
        String languageKey = text != null ? ((prefix = this.getLanguagePrefix()) != null ? (LM.containsText(key = prefix + "." + text) ? key : text) : text) : null;
        return languageKey;
    }

    @NotNull
    public WebMenuItem addItem(@Nullable String text, @Nullable ActionListener actionListener) {
        return this.addItem(defaultStyleId, defaultIcon, text, defaultHotkey, true, actionListener);
    }

    @NotNull
    public WebMenuItem addItem(@Nullable String text, @Nullable HotkeyData hotkey, @Nullable ActionListener actionListener) {
        return this.addItem(defaultStyleId, defaultIcon, text, hotkey, true, actionListener);
    }

    @NotNull
    public WebMenuItem addItem(@Nullable String text, boolean enabled, @Nullable ActionListener actionListener) {
        return this.addItem(defaultStyleId, defaultIcon, text, defaultHotkey, enabled, actionListener);
    }

    @NotNull
    public WebMenuItem addItem(@Nullable String text, @Nullable HotkeyData hotkey, boolean enabled, @Nullable ActionListener actionListener) {
        return this.addItem(defaultStyleId, defaultIcon, text, hotkey, enabled, actionListener);
    }

    @NotNull
    public WebMenuItem addItem(@Nullable Object icon, @Nullable String text, @Nullable ActionListener actionListener) {
        return this.addItem(defaultStyleId, icon, text, defaultHotkey, true, actionListener);
    }

    @NotNull
    public WebMenuItem addItem(@Nullable Object icon, @Nullable String text, @Nullable HotkeyData hotkey, @Nullable ActionListener actionListener) {
        return this.addItem(defaultStyleId, icon, text, hotkey, true, actionListener);
    }

    @NotNull
    public WebMenuItem addItem(@Nullable Object icon, @Nullable String text, boolean enabled, @Nullable ActionListener actionListener) {
        return this.addItem(defaultStyleId, icon, text, defaultHotkey, enabled, actionListener);
    }

    @NotNull
    public WebMenuItem addItem(@Nullable Object icon, @Nullable String text, @Nullable HotkeyData hotkey, boolean enabled, @Nullable ActionListener actionListener) {
        return this.addItem(defaultStyleId, icon, text, hotkey, enabled, actionListener);
    }

    @NotNull
    public WebMenuItem addItem(@NotNull StyleId id, @Nullable String text, @Nullable ActionListener actionListener) {
        return this.addItem(id, defaultIcon, text, defaultHotkey, true, actionListener);
    }

    @NotNull
    public WebMenuItem addItem(@NotNull StyleId id, @Nullable String text, @Nullable HotkeyData hotkey, @Nullable ActionListener actionListener) {
        return this.addItem(id, defaultIcon, text, hotkey, true, actionListener);
    }

    @NotNull
    public WebMenuItem addItem(@NotNull StyleId id, @Nullable String text, boolean enabled, @Nullable ActionListener actionListener) {
        return this.addItem(id, defaultIcon, text, defaultHotkey, enabled, actionListener);
    }

    @NotNull
    public WebMenuItem addItem(@NotNull StyleId id, @Nullable String text, @Nullable HotkeyData hotkey, boolean enabled, @Nullable ActionListener actionListener) {
        return this.addItem(id, defaultIcon, text, hotkey, enabled, actionListener);
    }

    @NotNull
    public WebMenuItem addItem(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, @Nullable ActionListener actionListener) {
        return this.addItem(id, icon, text, defaultHotkey, true, actionListener);
    }

    @NotNull
    public WebMenuItem addItem(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, @Nullable HotkeyData hotkey, @Nullable ActionListener actionListener) {
        return this.addItem(id, icon, text, hotkey, true, actionListener);
    }

    @NotNull
    public WebMenuItem addItem(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, boolean enabled, @Nullable ActionListener actionListener) {
        return this.addItem(id, icon, text, defaultHotkey, enabled, actionListener);
    }

    @NotNull
    public WebMenuItem addItem(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, @Nullable HotkeyData hotkey, boolean enabled, @Nullable ActionListener actionListener) {
        WebMenuItem item = this.createItem(id, icon, text, hotkey, enabled, actionListener);
        ((Container)this.getMenu()).add(item);
        return item;
    }

    @NotNull
    protected WebMenuItem createItem(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, @Nullable HotkeyData hotkey, boolean enabled, @Nullable ActionListener actionListener) {
        WebMenuItem item = new WebMenuItem(id, this.getLanguageKey(text));
        item.setIcon(this.getIcon(icon));
        item.setAccelerator(hotkey);
        item.setEnabled(enabled);
        if (actionListener != null) {
            item.addActionListener(actionListener);
        }
        return item;
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@Nullable String text, boolean selected, @Nullable ActionListener actionListener) {
        return this.addCheckItem(defaultStyleId, defaultIcon, text, defaultHotkey, true, selected, actionListener);
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@Nullable String text, @Nullable HotkeyData hotkey, boolean selected, @Nullable ActionListener actionListener) {
        return this.addCheckItem(defaultStyleId, defaultIcon, text, hotkey, true, selected, actionListener);
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@Nullable String text, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        return this.addCheckItem(defaultStyleId, defaultIcon, text, defaultHotkey, enabled, selected, actionListener);
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@Nullable String text, @Nullable HotkeyData hotkey, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        return this.addCheckItem(defaultStyleId, defaultIcon, text, hotkey, enabled, selected, actionListener);
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@Nullable Object icon, @Nullable String text, boolean selected, @Nullable ActionListener actionListener) {
        return this.addCheckItem(defaultStyleId, icon, text, defaultHotkey, true, selected, actionListener);
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@Nullable Object icon, @Nullable String text, @Nullable HotkeyData hotkey, boolean selected, @Nullable ActionListener actionListener) {
        return this.addCheckItem(defaultStyleId, icon, text, hotkey, true, selected, actionListener);
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@Nullable Object icon, @Nullable String text, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        return this.addCheckItem(defaultStyleId, icon, text, defaultHotkey, enabled, selected, actionListener);
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@Nullable Object icon, @Nullable String text, @Nullable HotkeyData hotkey, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        return this.addCheckItem(defaultStyleId, icon, text, hotkey, enabled, selected, actionListener);
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@NotNull StyleId id, @Nullable String text, boolean selected, @Nullable ActionListener actionListener) {
        return this.addCheckItem(id, defaultIcon, text, defaultHotkey, true, selected, actionListener);
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@NotNull StyleId id, @Nullable String text, @Nullable HotkeyData hotkey, boolean selected, @Nullable ActionListener actionListener) {
        return this.addCheckItem(id, defaultIcon, text, hotkey, true, selected, actionListener);
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@NotNull StyleId id, @Nullable String text, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        return this.addCheckItem(id, defaultIcon, text, defaultHotkey, enabled, selected, actionListener);
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@NotNull StyleId id, @Nullable String text, @Nullable HotkeyData hotkey, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        return this.addCheckItem(id, defaultIcon, text, hotkey, enabled, selected, actionListener);
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, boolean selected, @Nullable ActionListener actionListener) {
        return this.addCheckItem(id, icon, text, defaultHotkey, true, selected, actionListener);
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, @Nullable HotkeyData hotkey, boolean selected, @Nullable ActionListener actionListener) {
        return this.addCheckItem(id, icon, text, hotkey, true, selected, actionListener);
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        return this.addCheckItem(id, icon, text, defaultHotkey, enabled, selected, actionListener);
    }

    @NotNull
    public WebCheckBoxMenuItem addCheckItem(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, @Nullable HotkeyData hotkey, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        WebCheckBoxMenuItem item = this.createCheckItem(id, icon, text, hotkey, enabled, selected, actionListener);
        ((Container)this.getMenu()).add(item);
        return item;
    }

    @NotNull
    protected WebCheckBoxMenuItem createCheckItem(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, @Nullable HotkeyData hotkey, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        WebCheckBoxMenuItem item = new WebCheckBoxMenuItem(id, this.getLanguageKey(text));
        Icon resolvedIcon = this.getIcon(icon);
        if (resolvedIcon != null) {
            item.setIcon(resolvedIcon);
        }
        item.setAccelerator(hotkey);
        item.setEnabled(enabled);
        item.setSelected(selected);
        if (actionListener != null) {
            item.addActionListener(actionListener);
        }
        if (this.isGroupOpen()) {
            this.group(item);
        }
        return item;
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@Nullable String text, boolean selected, @Nullable ActionListener actionListener) {
        return this.addRadioItem(defaultStyleId, defaultIcon, text, defaultHotkey, true, selected, actionListener);
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@Nullable String text, @Nullable HotkeyData hotkey, boolean selected, @Nullable ActionListener actionListener) {
        return this.addRadioItem(defaultStyleId, defaultIcon, text, hotkey, true, selected, actionListener);
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@Nullable String text, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        return this.addRadioItem(defaultStyleId, defaultIcon, text, defaultHotkey, enabled, selected, actionListener);
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@Nullable String text, @Nullable HotkeyData hotkey, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        return this.addRadioItem(defaultStyleId, defaultIcon, text, hotkey, enabled, selected, actionListener);
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@Nullable Object icon, @Nullable String text, boolean selected, @Nullable ActionListener actionListener) {
        return this.addRadioItem(defaultStyleId, icon, text, defaultHotkey, true, selected, actionListener);
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@Nullable Object icon, @Nullable String text, @Nullable HotkeyData hotkey, boolean selected, @Nullable ActionListener actionListener) {
        return this.addRadioItem(defaultStyleId, icon, text, hotkey, true, selected, actionListener);
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@Nullable Object icon, @Nullable String text, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        return this.addRadioItem(defaultStyleId, icon, text, defaultHotkey, enabled, selected, actionListener);
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@Nullable Object icon, @Nullable String text, @Nullable HotkeyData hotkey, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        return this.addRadioItem(defaultStyleId, icon, text, hotkey, enabled, selected, actionListener);
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@NotNull StyleId id, @Nullable String text, boolean selected, @Nullable ActionListener actionListener) {
        return this.addRadioItem(id, defaultIcon, text, defaultHotkey, true, selected, actionListener);
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@NotNull StyleId id, @Nullable String text, @Nullable HotkeyData hotkey, boolean selected, @Nullable ActionListener actionListener) {
        return this.addRadioItem(id, defaultIcon, text, hotkey, true, selected, actionListener);
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@NotNull StyleId id, @Nullable String text, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        return this.addRadioItem(id, defaultIcon, text, defaultHotkey, enabled, selected, actionListener);
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@NotNull StyleId id, @Nullable String text, @Nullable HotkeyData hotkey, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        return this.addRadioItem(id, defaultIcon, text, hotkey, enabled, selected, actionListener);
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, boolean selected, @Nullable ActionListener actionListener) {
        return this.addRadioItem(id, icon, text, defaultHotkey, true, selected, actionListener);
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, @Nullable HotkeyData hotkey, boolean selected, @Nullable ActionListener actionListener) {
        return this.addRadioItem(id, icon, text, hotkey, true, selected, actionListener);
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        return this.addRadioItem(id, icon, text, defaultHotkey, enabled, selected, actionListener);
    }

    @NotNull
    public WebRadioButtonMenuItem addRadioItem(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, @Nullable HotkeyData hotkey, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        WebRadioButtonMenuItem item = this.createRadioItem(id, icon, text, hotkey, enabled, selected, actionListener);
        ((Container)this.getMenu()).add(item);
        return item;
    }

    @NotNull
    protected WebRadioButtonMenuItem createRadioItem(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, @Nullable HotkeyData hotkey, boolean enabled, boolean selected, @Nullable ActionListener actionListener) {
        WebRadioButtonMenuItem item = new WebRadioButtonMenuItem(id, this.getLanguageKey(text));
        Icon resolvedIcon = this.getIcon(icon);
        if (resolvedIcon != null) {
            item.setIcon(resolvedIcon);
        }
        item.setAccelerator(hotkey);
        item.setEnabled(enabled);
        item.setSelected(selected);
        if (actionListener != null) {
            item.addActionListener(actionListener);
        }
        if (this.isGroupOpen()) {
            this.group(item);
        }
        return item;
    }

    @NotNull
    public MenuGenerator addSubMenu(@Nullable String text) {
        return this.addSubMenu(defaultStyleId, defaultIcon, text, true, defaultAction);
    }

    @NotNull
    public MenuGenerator addSubMenu(@Nullable String text, boolean enabled) {
        return this.addSubMenu(defaultStyleId, defaultIcon, text, enabled, defaultAction);
    }

    @NotNull
    public MenuGenerator addSubMenu(@Nullable String text, @Nullable ActionListener actionListener) {
        return this.addSubMenu(defaultStyleId, defaultIcon, text, true, actionListener);
    }

    @NotNull
    public MenuGenerator addSubMenu(@Nullable String text, boolean enabled, @Nullable ActionListener actionListener) {
        return this.addSubMenu(defaultStyleId, defaultIcon, text, enabled, actionListener);
    }

    @NotNull
    public MenuGenerator addSubMenu(@Nullable Object icon, @Nullable String text) {
        return this.addSubMenu(defaultStyleId, icon, text, true, defaultAction);
    }

    @NotNull
    public MenuGenerator addSubMenu(@Nullable Object icon, @Nullable String text, boolean enabled) {
        return this.addSubMenu(defaultStyleId, icon, text, enabled, defaultAction);
    }

    @NotNull
    public MenuGenerator addSubMenu(@Nullable Object icon, @Nullable String text, @Nullable ActionListener actionListener) {
        return this.addSubMenu(defaultStyleId, icon, text, true, actionListener);
    }

    @NotNull
    public MenuGenerator addSubMenu(@Nullable Object icon, @Nullable String text, boolean enabled, @Nullable ActionListener actionListener) {
        return this.addSubMenu(defaultStyleId, icon, text, enabled, actionListener);
    }

    @NotNull
    public MenuGenerator addSubMenu(@NotNull StyleId id, @Nullable String text) {
        return this.addSubMenu(id, defaultIcon, text, true, defaultAction);
    }

    @NotNull
    public MenuGenerator addSubMenu(@NotNull StyleId id, @Nullable String text, boolean enabled) {
        return this.addSubMenu(id, defaultIcon, text, enabled, defaultAction);
    }

    @NotNull
    public MenuGenerator addSubMenu(@NotNull StyleId id, @Nullable String text, @Nullable ActionListener actionListener) {
        return this.addSubMenu(id, defaultIcon, text, true, actionListener);
    }

    @NotNull
    public MenuGenerator addSubMenu(@NotNull StyleId id, @Nullable String text, boolean enabled, @Nullable ActionListener actionListener) {
        return this.addSubMenu(id, defaultIcon, text, enabled, actionListener);
    }

    @NotNull
    public MenuGenerator addSubMenu(@NotNull StyleId id, @Nullable Object icon, @Nullable String text) {
        return this.addSubMenu(id, icon, text, true, defaultAction);
    }

    @NotNull
    public MenuGenerator addSubMenu(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, boolean enabled) {
        return this.addSubMenu(id, icon, text, enabled, defaultAction);
    }

    @NotNull
    public MenuGenerator addSubMenu(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, @Nullable ActionListener actionListener) {
        return this.addSubMenu(id, icon, text, true, actionListener);
    }

    @NotNull
    public MenuGenerator addSubMenu(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, boolean enabled, @Nullable ActionListener actionListener) {
        WebMenu menu = this.createSubMenu(id, icon, text, enabled, actionListener);
        ((Container)this.getMenu()).add(menu);
        MenuGenerator menuGenerator = new MenuGenerator(menu);
        menuGenerator.setIconSettings(this.getNearClass(), this.getPath(), this.getExtension());
        menuGenerator.setLanguagePrefix(this.getLanguagePrefix());
        return menuGenerator;
    }

    @NotNull
    protected WebMenu createSubMenu(@NotNull StyleId id, @Nullable Object icon, @Nullable String text, boolean enabled, @Nullable ActionListener actionListener) {
        WebMenu menu = new WebMenu(id, this.getLanguageKey(text));
        menu.setIcon(this.getIcon(icon));
        menu.setEnabled(enabled);
        if (actionListener != null) {
            menu.addActionListener(actionListener);
        }
        return menu;
    }

    public void addSeparator() {
        C menuComponent = this.getMenu();
        if (menuComponent instanceof WebMenu) {
            ((WebMenu)menuComponent).addSeparator();
        } else if (menuComponent instanceof WebPopupMenu) {
            ((WebPopupMenu)menuComponent).addSeparator();
        }
    }

    @NotNull
    public UnselectableButtonGroup openGroup() {
        return this.openGroup(false);
    }

    @NotNull
    public UnselectableButtonGroup openGroup(boolean unselectable) {
        this.group = new UnselectableButtonGroup(unselectable);
        return this.group;
    }

    public boolean isGroupOpen() {
        return this.group != null;
    }

    @NotNull
    public UnselectableButtonGroup group(@NotNull AbstractButton button) {
        if (this.group == null) {
            throw new UtilityException("Button group must be opened first");
        }
        this.group.add(button);
        return this.group;
    }

    @NotNull
    public UnselectableButtonGroup closeGroup() {
        if (this.group == null) {
            throw new UtilityException("Button group must be opened first");
        }
        UnselectableButtonGroup group = this.group;
        this.group = null;
        return group;
    }

    @NotNull
    public C getMenu() {
        return this.menu;
    }

    public boolean isEmpty() {
        return ((Container)this.getMenu()).getComponentCount() == 0;
    }

    @Nullable
    protected Icon getIcon(@Nullable Object icon) {
        Icon result2;
        if (icon != null) {
            if (icon instanceof Icon) {
                result2 = (Icon)icon;
            } else if (icon instanceof Image) {
                result2 = new ImageIcon((Image)icon);
            } else {
                Resource resource;
                if (icon instanceof Resource) {
                    resource = (Resource)icon;
                } else if (icon instanceof String) {
                    try {
                        if (this.getNearClass() != null) {
                            resource = new ClassResource(this.getNearClass(), this.getPath() + icon + this.getExtension());
                        }
                        resource = new FileResource(new File(this.getPath(), icon + this.getExtension()));
                    }
                    catch (Exception e) {
                        throw new UtilityException("Unable to find menu icon for path: " + this.getPath() + icon + this.getExtension(), e);
                    }
                } else if (icon instanceof File) {
                    resource = new FileResource((File)icon);
                } else if (icon instanceof URL) {
                    resource = new UrlResource((URL)icon);
                } else {
                    throw new UtilityException("Unknown icon object type provided: " + icon);
                }
                result2 = ImageUtils.loadImageIcon(resource);
            }
        } else {
            result2 = null;
        }
        return result2;
    }
}

