/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing.extensions;

import java.awt.Component;
import java.awt.Font;

public final class FontMethodsImpl {
    public static boolean isPlainFont(Component component2) {
        return component2 == null || component2.getFont() == null || component2.getFont().isPlain();
    }

    public static <C extends Component> C setPlainFont(Component component2) {
        return FontMethodsImpl.setPlainFont(component2, true);
    }

    public static <C extends Component> C setPlainFont(Component component2, boolean apply2) {
        if (apply2 && component2 != null && component2.getFont() != null) {
            component2.setFont(component2.getFont().deriveFont(0));
        }
        return (C)component2;
    }

    public static boolean isBoldFont(Component component2) {
        return component2 != null && component2.getFont() != null && component2.getFont().isBold();
    }

    public static <C extends Component> C setBoldFont(Component component2) {
        return FontMethodsImpl.setBoldFont(component2, true);
    }

    public static <C extends Component> C setBoldFont(Component component2, boolean apply2) {
        if (apply2 && component2 != null && component2.getFont() != null) {
            component2.setFont(component2.getFont().deriveFont(1));
        }
        return (C)component2;
    }

    public static boolean isItalicFont(Component component2) {
        return component2 != null && component2.getFont() != null && component2.getFont().isItalic();
    }

    public static <C extends Component> C setItalicFont(Component component2) {
        return FontMethodsImpl.setItalicFont(component2, true);
    }

    public static <C extends Component> C setItalicFont(Component component2, boolean apply2) {
        if (apply2 && component2 != null && component2.getFont() != null) {
            component2.setFont(component2.getFont().deriveFont(2));
        }
        return (C)component2;
    }

    public static <C extends Component> C setFontStyle(Component component2, boolean bold, boolean italic) {
        int style = bold && italic ? 3 : (bold ? 1 : (italic ? 2 : 0));
        return FontMethodsImpl.setFontStyle(component2, style);
    }

    public static <C extends Component> C setFontStyle(Component component2, int style) {
        if (component2 != null && component2.getFont() != null) {
            component2.setFont(component2.getFont().deriveFont(style));
        }
        return (C)component2;
    }

    public static int getFontSize(Component component2) {
        if (component2 != null && component2.getFont() != null) {
            return component2.getFont().getSize();
        }
        return -1;
    }

    public static <C extends Component> C setFontSize(Component component2, int fontSize) {
        if (component2 != null && component2.getFont() != null) {
            component2.setFont(component2.getFont().deriveFont((float)fontSize));
        }
        return (C)component2;
    }

    public static <C extends Component> C changeFontSize(Component component2, int change) {
        if (component2 != null && component2.getFont() != null) {
            Font font = component2.getFont();
            component2.setFont(font.deriveFont((float)font.getSize() + (float)change));
        }
        return (C)component2;
    }

    public static <C extends Component> C setFontSizeAndStyle(Component component2, int fontSize, boolean bold, boolean italic) {
        int style = bold && italic ? 3 : (bold ? 1 : (italic ? 2 : 0));
        return FontMethodsImpl.setFontSizeAndStyle(component2, fontSize, style);
    }

    public static <C extends Component> C setFontSizeAndStyle(Component component2, int fontSize, int style) {
        if (component2 != null && component2.getFont() != null) {
            component2.setFont(component2.getFont().deriveFont(style, fontSize));
        }
        return (C)component2;
    }

    public static String getFontName(Component component2) {
        if (component2 != null && component2.getFont() != null) {
            return component2.getFont().getFontName();
        }
        return null;
    }

    public static <C extends Component> C setFontName(Component component2, String fontName) {
        if (component2 != null && component2.getFont() != null) {
            Font oldFont = component2.getFont();
            component2.setFont(new Font(fontName, oldFont.getStyle(), oldFont.getSize()));
        }
        return (C)component2;
    }
}

