/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.BiConsumer;
import com.alee.api.jdk.BiPredicate;
import com.alee.utils.CollectionUtils;
import com.alee.utils.swing.WeakComponentData;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.JComponent;

public class WeakComponentDataOrderedSet<C extends JComponent, E>
extends WeakComponentData<C, LinkedHashSet<E>> {
    public WeakComponentDataOrderedSet(@NotNull String key, int initialCapacity) {
        super(key, initialCapacity);
    }

    public synchronized int size(@NotNull C component2) {
        LinkedHashSet set = (LinkedHashSet)this.get(component2);
        return set != null ? set.size() : 0;
    }

    public synchronized boolean containsData(@NotNull C component2) {
        return CollectionUtils.notEmpty((Collection)this.get(component2));
    }

    public synchronized boolean containsData(@NotNull C component2, @NotNull E data) {
        LinkedHashSet set = (LinkedHashSet)this.get(component2);
        return set != null && set.contains(data);
    }

    public synchronized void add(@NotNull C component2, @NotNull E data) {
        LinkedHashSet<E> set = (LinkedHashSet<E>)this.get(component2);
        if (set == null) {
            set = new LinkedHashSet<E>(1);
            this.set(component2, set);
        }
        set.add(data);
    }

    public synchronized void remove(@NotNull C component2, @NotNull E data) {
        LinkedHashSet set = (LinkedHashSet)this.get(component2);
        if (set != null && set.remove(data) && set.size() == 0) {
            this.clear(component2);
        }
    }

    public synchronized void remove(@NotNull C component2, @NotNull E data, @NotNull BiConsumer<C, E> removedDataConsumer) {
        LinkedHashSet set = (LinkedHashSet)this.get(component2);
        if (set != null && set.remove(data)) {
            removedDataConsumer.accept(component2, data);
            if (set.size() == 0) {
                this.clear(component2);
            }
        }
    }

    public synchronized void forEachData(@NotNull BiConsumer<C, E> consumer) {
        for (JComponent component2 : this.components()) {
            this.forEachData(component2, consumer);
        }
    }

    public synchronized void forEachData(@NotNull C component2, @NotNull BiConsumer<C, E> consumer) {
        LinkedHashSet set = (LinkedHashSet)this.get(component2);
        if (set != null) {
            for (Object data : set) {
                consumer.accept(component2, data);
            }
        }
    }

    public synchronized boolean anyDataMatch(@NotNull BiPredicate<C, E> predicate) {
        boolean anyDataMatch = false;
        for (JComponent component2 : this.components()) {
            if (!this.anyDataMatch(component2, predicate)) continue;
            anyDataMatch = true;
            break;
        }
        return anyDataMatch;
    }

    public synchronized boolean anyDataMatch(@NotNull C component2, @NotNull BiPredicate<C, E> predicate) {
        boolean anyDataMatch = false;
        LinkedHashSet set = (LinkedHashSet)this.get(component2);
        if (set != null) {
            for (Object data : set) {
                if (!predicate.test(component2, data)) continue;
                anyDataMatch = true;
                break;
            }
        }
        return anyDataMatch;
    }

    public synchronized boolean allDataMatch(@NotNull BiPredicate<C, E> predicate) {
        boolean allDataMatch = true;
        for (JComponent component2 : this.components()) {
            if (this.allDataMatch(component2, predicate)) continue;
            allDataMatch = false;
            break;
        }
        return allDataMatch;
    }

    public synchronized boolean allDataMatch(@NotNull C component2, @NotNull BiPredicate<C, E> predicate) {
        boolean allDataMatch = true;
        LinkedHashSet set = (LinkedHashSet)this.get(component2);
        if (set != null) {
            for (Object data : set) {
                if (predicate.test(component2, data)) continue;
                allDataMatch = false;
                break;
            }
        }
        return allDataMatch;
    }

    public synchronized boolean noneDataMatch(@NotNull BiPredicate<C, E> predicate) {
        boolean noneDataMatch = true;
        for (JComponent component2 : this.components()) {
            if (this.noneDataMatch(component2, predicate)) continue;
            noneDataMatch = false;
            break;
        }
        return noneDataMatch;
    }

    public synchronized boolean noneDataMatch(@NotNull C component2, @NotNull BiPredicate<C, E> predicate) {
        boolean noneDataMatch = true;
        LinkedHashSet set = (LinkedHashSet)this.get(component2);
        if (set != null) {
            for (Object data : set) {
                if (!predicate.test(component2, data)) continue;
                noneDataMatch = false;
                break;
            }
        }
        return noneDataMatch;
    }
}

