/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.utils.SwingUtils;
import java.awt.event.MouseEvent;

public enum MouseButton {
    left(1),
    middle(2),
    right(3);

    private final int code;

    private MouseButton(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static MouseButton get(MouseEvent event) {
        if (SwingUtils.isRightMouseButton(event)) {
            return right;
        }
        if (SwingUtils.isMiddleMouseButton(event)) {
            return middle;
        }
        return left;
    }

    public static MouseButton get(int code) {
        switch (code) {
            case 1: {
                return left;
            }
            case 2: {
                return middle;
            }
            case 3: {
                return right;
            }
        }
        return null;
    }
}

