/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.UtilityException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public final class EnumLazyIconProvider {
    @NotNull
    private static final Map<Enum, Map<String, ImageIcon>> icons = new HashMap<Enum, Map<String, ImageIcon>>();
    @NotNull
    private static final String DEFAULT_EXTENSION = ".png";

    @NotNull
    public static <E extends Enum<E>> ImageIcon getIcon(@NotNull E enumeration, @NotNull String folder) {
        return EnumLazyIconProvider.getIcon(enumeration, null, folder);
    }

    @NotNull
    public static <E extends Enum<E>> ImageIcon getIcon(@NotNull E enumeration, @Nullable String state, @NotNull String folder) {
        return EnumLazyIconProvider.getIcon(enumeration, state, folder, DEFAULT_EXTENSION);
    }

    @NotNull
    public static <E extends Enum<E>> ImageIcon getIcon(@NotNull E enumeration, @Nullable String state, @NotNull String folder, @NotNull String extension2) {
        ImageIcon imageIcon;
        Map<String, ImageIcon> stateIcons = icons.get(enumeration);
        if (stateIcons == null) {
            stateIcons = new HashMap<String, ImageIcon>(1);
            icons.put(enumeration, stateIcons);
        }
        if ((imageIcon = stateIcons.get(state)) == null) {
            String stateSuffix = state != null ? "-" + state : "";
            String path = folder + enumeration + stateSuffix + extension2;
            try {
                imageIcon = new ImageIcon(enumeration.getClass().getResource(path));
                stateIcons.put(state, imageIcon);
            }
            catch (Exception e) {
                String msg = "Unable to find icon '%s' near class: %s";
                String cn = enumeration.getClass().getCanonicalName();
                throw new UtilityException(String.format("Unable to find icon '%s' near class: %s", path, cn), e);
            }
        }
        return imageIcon;
    }
}

