/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.merge.Mergeable;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;

@XStreamAlias(value="ComponentSize")
public class ComponentSize
implements Mergeable,
Cloneable,
Serializable {
    @XStreamAsAttribute
    @Nullable
    protected Type type;
    @XStreamAsAttribute
    @Nullable
    protected Integer minimumWidth;
    @XStreamAsAttribute
    @Nullable
    protected Integer minimumHeight;
    @XStreamAsAttribute
    @Nullable
    protected Insets insets;

    @NotNull
    public Type getType() {
        return this.type != null ? this.type : Type.none;
    }

    public int getMinimumWidth() {
        return this.minimumWidth != null ? this.minimumWidth : 0;
    }

    public int getMinimumHeight() {
        return this.minimumHeight != null ? this.minimumHeight : 0;
    }

    @NotNull
    public Insets getInsets() {
        return this.insets != null ? new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right) : new Insets(0, 0, 0, 0);
    }

    @NotNull
    public Dimension size(@NotNull Component component2) {
        Dimension size;
        switch (this.getType()) {
            default: {
                size = new Dimension(0, 0);
                break;
            }
            case fixed: {
                size = new Dimension((this.minimumWidth != null ? this.minimumWidth : 0) + (this.insets != null ? this.insets.left + this.insets.right : 0), (this.minimumHeight != null ? this.minimumHeight : 0) + (this.insets != null ? this.insets.top + this.insets.bottom : 0));
                break;
            }
            case minimum: 
            case preferred: 
            case maximum: {
                Dimension min = this.getType().size(component2);
                size = new Dimension((this.minimumWidth != null ? Math.max(this.minimumWidth, min.width) : min.width) + (this.insets != null ? this.insets.left + this.insets.right : 0), (this.minimumHeight != null ? Math.max(this.minimumHeight, min.height) : min.height) + (this.insets != null ? this.insets.top + this.insets.bottom : 0));
            }
        }
        return size;
    }

    public static enum Type {
        none,
        fixed,
        minimum,
        preferred,
        maximum;


        @NotNull
        public Dimension size(@NotNull Component component2) {
            Dimension size;
            switch (this) {
                default: {
                    size = new Dimension(0, 0);
                    break;
                }
                case minimum: {
                    size = component2.getMinimumSize();
                    break;
                }
                case preferred: {
                    size = component2.getPreferredSize();
                    break;
                }
                case maximum: {
                    size = component2.getMaximumSize();
                }
            }
            return size;
        }
    }
}

