/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.UtilityException;
import java.io.Serializable;
import javax.swing.JComponent;

public final class ClientProperty<V extends Serializable>
implements Serializable {
    @NotNull
    private final String key;
    @Nullable
    private final V defaultValue;

    public ClientProperty(@NotNull String key, @Nullable V defaultValue2) {
        this.key = key;
        this.defaultValue = defaultValue2;
    }

    @NotNull
    public String key() {
        return this.key;
    }

    @Nullable
    public V defaultValue() {
        return this.defaultValue;
    }

    @NotNull
    public V get(@NotNull JComponent component2) {
        Object value = component2.getClientProperty(this.key);
        if (value != null || this.defaultValue != null) {
            return (V)(value != null ? (Serializable)value : this.defaultValue);
        }
        throw new UtilityException("Value and default value are both null for client property: " + this.key);
    }

    @Nullable
    public V set(@NotNull JComponent component2, @Nullable V value) {
        Object old = component2.getClientProperty(this.key);
        if (value != null || this.defaultValue != null) {
            component2.putClientProperty(this.key, value);
            return (V)(old != null ? (Serializable)old : this.defaultValue);
        }
        throw new UtilityException("Provided value and default value are both null for client property: " + this.key);
    }

    @Nullable
    public V reset(@NotNull JComponent component2) {
        if (this.defaultValue != null) {
            return this.set(component2, null);
        }
        throw new UtilityException("Value cannot be reset because default value is null for client property: " + this.key);
    }
}

