/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.StringReader;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ParagraphView;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;

public final class BasicHTML {
    private static final String htmlDisable = "html.disable";
    private static BasicEditorKit basicHTMLFactory;
    private static ViewFactory basicHTMLViewFactory;
    private static final String styleChanges = "p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }";

    public static boolean isHTMLString(@NotNull JComponent c, @Nullable String text) {
        boolean isHTML = false;
        Boolean disabled = (Boolean)c.getClientProperty(htmlDisable);
        if (disabled != Boolean.TRUE && text != null && text.length() >= 6 && text.charAt(0) == '<' && text.charAt(5) == '>') {
            String tag = text.substring(1, 5);
            isHTML = tag.equalsIgnoreCase("html");
        }
        return isHTML;
    }

    public static View createHTMLView(JComponent c, String html, Font defaultFont, Color foreground) {
        BasicEditorKit kit = BasicHTML.getFactory();
        Document doc = kit.createDefaultDocument(defaultFont, foreground);
        Object base = c.getClientProperty("html.base");
        if (base instanceof URL) {
            ((HTMLDocument)doc).setBase((URL)base);
        }
        StringReader r = new StringReader(html);
        try {
            kit.read(r, doc, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ViewFactory f = kit.getViewFactory();
        View hview = f.create(doc.getDefaultRootElement());
        return new Renderer(c, f, hview);
    }

    public static int getHTMLBaseline(View view, int w, int h) {
        if (w < 0 || h < 0) {
            throw new IllegalArgumentException("Width and height must be >= 0");
        }
        if (view instanceof Renderer) {
            return BasicHTML.getBaseline(view.getView(0), w, h);
        }
        return -1;
    }

    private static int getBaseline(JComponent c, int y, int ascent, int w, int h) {
        View view = (View)c.getClientProperty("html");
        if (view != null) {
            int baseline = BasicHTML.getHTMLBaseline(view, w, h);
            if (baseline < 0) {
                return baseline;
            }
            return y + baseline;
        }
        return y + ascent;
    }

    private static int getBaseline(View view, int w, int h) {
        if (BasicHTML.hasParagraph(view)) {
            view.setSize(w, h);
            return BasicHTML.getBaseline(view, new Rectangle(0, 0, w, h));
        }
        return -1;
    }

    private static int getBaseline(View view, Shape bounds) {
        if (view.getViewCount() == 0) {
            return -1;
        }
        AttributeSet attributes = view.getElement().getAttributes();
        Object name = null;
        if (attributes != null) {
            name = attributes.getAttribute(StyleConstants.NameAttribute);
        }
        int index = 0;
        if (name == HTML.Tag.HTML && view.getViewCount() > 1) {
            ++index;
        }
        if ((bounds = view.getChildAllocation(index, bounds)) == null) {
            return -1;
        }
        View child = view.getView(index);
        if (view instanceof ParagraphView) {
            Rectangle rect = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            return rect.y + (int)((float)rect.height * child.getAlignment(1));
        }
        return BasicHTML.getBaseline(child, bounds);
    }

    private static boolean hasParagraph(View view) {
        if (view instanceof ParagraphView) {
            return true;
        }
        if (view.getViewCount() == 0) {
            return false;
        }
        AttributeSet attributes = view.getElement().getAttributes();
        Object name = null;
        if (attributes != null) {
            name = attributes.getAttribute(StyleConstants.NameAttribute);
        }
        int index = 0;
        if (name == HTML.Tag.HTML && view.getViewCount() > 1) {
            index = 1;
        }
        return BasicHTML.hasParagraph(view.getView(index));
    }

    private static BasicEditorKit getFactory() {
        if (basicHTMLFactory == null) {
            basicHTMLViewFactory = new BasicHTMLViewFactory();
            basicHTMLFactory = new BasicEditorKit();
        }
        return basicHTMLFactory;
    }

    private static class Renderer
    extends View {
        private final JComponent host;
        private final View view;
        private final ViewFactory factory;
        private int width;

        public Renderer(JComponent c, ViewFactory f, View v) {
            super(null);
            this.host = c;
            this.factory = f;
            this.view = v;
            this.view.setParent(this);
            this.setSize(this.view.getPreferredSpan(0), this.view.getPreferredSpan(1));
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public float getPreferredSpan(int axis) {
            if (axis == 0) {
                return this.width;
            }
            return this.view.getPreferredSpan(axis);
        }

        @Override
        public float getMinimumSpan(int axis) {
            return this.view.getMinimumSpan(axis);
        }

        @Override
        public float getMaximumSpan(int axis) {
            return 2.1474836E9f;
        }

        @Override
        public void preferenceChanged(View child, boolean width, boolean height) {
        }

        @Override
        public float getAlignment(int axis) {
            return this.view.getAlignment(axis);
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            Rectangle alloc = allocation.getBounds();
            this.view.setSize(alloc.width, alloc.height);
            this.view.paint(g, allocation);
        }

        @Override
        public void setParent(View parent) {
            throw new Error("Can't set parent on root view");
        }

        @Override
        public int getViewCount() {
            return 1;
        }

        @Override
        public View getView(int n) {
            return this.view;
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            return this.view.modelToView(pos, a, b);
        }

        @Override
        public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            return this.view.modelToView(p0, b0, p1, b1, a);
        }

        @Override
        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            return this.view.viewToModel(x, y, a, bias);
        }

        @Override
        public Document getDocument() {
            return this.view.getDocument();
        }

        @Override
        public int getStartOffset() {
            return this.view.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.view.getEndOffset();
        }

        @Override
        public Element getElement() {
            return this.view.getElement();
        }

        @Override
        public void setSize(float width, float height) {
            this.width = (int)width;
            this.view.setSize(width, height);
        }

        @Override
        public Container getContainer() {
            return this.host;
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.factory;
        }
    }

    private static class BasicDocument
    extends HTMLDocument {
        public BasicDocument(StyleSheet s, Font defaultFont, Color foreground) {
            super(s);
            this.setPreservesUnknownTags(false);
            this.setFontAndColor(defaultFont, foreground);
        }

        private void setFontAndColor(Font font, Color fg) {
            this.getStyleSheet().addRule(this.displayPropertiesToCSS(font, fg));
        }

        private String displayPropertiesToCSS(Font font, Color fg) {
            StringBuilder rule = new StringBuilder("body {");
            if (font != null) {
                rule.append(" font-family: ");
                rule.append(font.getFamily());
                rule.append(" ; ");
                rule.append(" font-size: ");
                rule.append(font.getSize());
                rule.append("pt ;");
                if (font.isBold()) {
                    rule.append(" font-weight: 700 ; ");
                }
                if (font.isItalic()) {
                    rule.append(" font-style: italic ; ");
                }
            }
            if (fg != null) {
                rule.append(" color: #");
                if (fg.getRed() < 16) {
                    rule.append('0');
                }
                rule.append(Integer.toHexString(fg.getRed()));
                if (fg.getGreen() < 16) {
                    rule.append('0');
                }
                rule.append(Integer.toHexString(fg.getGreen()));
                if (fg.getBlue() < 16) {
                    rule.append('0');
                }
                rule.append(Integer.toHexString(fg.getBlue()));
                rule.append(" ; ");
            }
            rule.append(" }");
            return rule.toString();
        }
    }

    private static class BasicHTMLViewFactory
    extends HTMLEditorKit.HTMLFactory {
        private BasicHTMLViewFactory() {
        }

        @Override
        public View create(Element elem) {
            View view = super.create(elem);
            if (view instanceof ImageView) {
                ((ImageView)view).setLoadsSynchronously(true);
            }
            return view;
        }
    }

    private static class BasicEditorKit
    extends HTMLEditorKit {
        private static StyleSheet defaultStyles;

        private BasicEditorKit() {
        }

        @Override
        public StyleSheet getStyleSheet() {
            if (defaultStyles == null) {
                defaultStyles = new StyleSheet();
                StringReader r = new StringReader(BasicHTML.styleChanges);
                try {
                    defaultStyles.loadRules(r, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                r.close();
                defaultStyles.addStyleSheet(super.getStyleSheet());
            }
            return defaultStyles;
        }

        public Document createDefaultDocument(Font defaultFont, Color foreground) {
            StyleSheet styles = this.getStyleSheet();
            StyleSheet ss = new StyleSheet();
            ss.addStyleSheet(styles);
            BasicDocument doc = new BasicDocument(ss, defaultFont, foreground);
            doc.setAsynchronousLoadPriority(Integer.MAX_VALUE);
            doc.setPreservesUnknownTags(false);
            return doc;
        }

        @Override
        public ViewFactory getViewFactory() {
            return basicHTMLViewFactory;
        }
    }
}

