/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.reflection;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.ReflectUtils;
import com.alee.utils.reflection.ReflectionException;

public final class LazyInstance<T> {
    @NotNull
    private final Class<? extends T> clazz;
    @NotNull
    private final Object[] arguments;
    @Nullable
    private T instance;

    public LazyInstance(@NotNull Class<? extends T> clazz, Object ... arguments) {
        this.clazz = clazz;
        this.arguments = arguments;
    }

    @NotNull
    public T create() {
        try {
            return ReflectUtils.createInstance(this.clazz, this.arguments);
        }
        catch (Exception e) {
            String msg = "Unable to instantiate skin for class: %s";
            throw new ReflectionException(String.format("Unable to instantiate skin for class: %s", this.clazz), e);
        }
    }

    @NotNull
    public synchronized T get() {
        if (this.instance == null) {
            this.instance = this.create();
        }
        return this.instance;
    }
}

