/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.ninepatch;

import com.alee.api.Identifiable;
import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.Clone;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Rectangle;
import java.io.Serializable;

@XStreamAlias(value="NinePatchInterval")
public final class NinePatchInterval
implements Identifiable,
Cloneable,
Serializable {
    private final transient String id = TextUtils.generateId("NPINT");
    @XStreamAsAttribute
    private boolean pixel;
    @XStreamAsAttribute
    private int start;
    @XStreamAsAttribute
    private int end;

    public NinePatchInterval() {
        this(0, 0, true);
    }

    public NinePatchInterval(int start2) {
        this(start2, start2, true);
    }

    public NinePatchInterval(int start2, boolean pixel) {
        this(start2, start2, pixel);
    }

    public NinePatchInterval(int start2, int end) {
        this(start2, end, true);
    }

    public NinePatchInterval(int start2, int end, boolean pixel) {
        this.start = start2;
        this.end = end;
        this.pixel = pixel;
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    public boolean isPixel() {
        return this.pixel;
    }

    public void setPixel(boolean pixel) {
        this.pixel = pixel;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start2) {
        this.start = start2;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public boolean intersects(NinePatchInterval npi) {
        return new Rectangle(this.getStart(), 0, this.getEnd() - this.getStart(), 1).intersects(new Rectangle(npi.getStart(), 0, npi.getEnd() - npi.getStart(), 1));
    }

    public int getLength() {
        return this.getEnd() - this.getStart();
    }

    @NotNull
    public NinePatchInterval clone() {
        return Clone.deep().nonNullClone(this);
    }

    public boolean equals(Object object) {
        boolean equals;
        if (object instanceof NinePatchInterval) {
            NinePatchInterval npi = (NinePatchInterval)object;
            equals = this.isPixel() == npi.isPixel() && this.getStart() == npi.getStart() && this.getEnd() == npi.getEnd();
        } else {
            equals = false;
        }
        return equals;
    }
}

