/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.ninepatch;

import com.alee.api.resource.ClassResource;
import com.alee.managers.style.StyleException;
import com.alee.utils.ReflectUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;

public class NinePatchIconConverter
extends ReflectionConverter {
    public static final String NEAR_CLASS_ATTRIBUTE = "nearClass";

    public NinePatchIconConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    @Override
    public boolean canConvert(Class type) {
        return type.equals(NinePatchIcon.class);
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class nearClass;
        String nearClassPath = reader.getAttribute(NEAR_CLASS_ATTRIBUTE);
        if (nearClassPath != null) {
            nearClass = ReflectUtils.getClassSafely(nearClassPath);
            if (nearClass == null) {
                String skinClassName = (String)context.get("skin.class");
                Class skinClass = ReflectUtils.getClassSafely(skinClassName);
                if (skinClass == null) {
                    String msg = "Specified skin class '%s' cannot be found";
                    throw new StyleException(String.format("Specified skin class '%s' cannot be found", skinClassName));
                }
                nearClassPath = skinClass.getPackage().getName() + "." + nearClassPath;
                nearClass = ReflectUtils.getClassSafely(nearClassPath);
            }
        } else {
            nearClass = (Class)context.get("painter.class");
            nearClassPath = nearClass.getCanonicalName();
        }
        String iconPath = reader.getValue();
        if (nearClass != null) {
            try {
                return new NinePatchIcon(new ClassResource(nearClass, iconPath), true);
            }
            catch (Exception e) {
                String msg = "Unable to read 9-patch icon '%s' at path '%s' near class '%s'";
                throw new StyleException(String.format("Unable to read 9-patch icon '%s' at path '%s' near class '%s'", iconPath, nearClassPath, nearClass), e);
            }
        }
        String msg = "Unable to find relative class for 9-patch icon '%s'";
        throw new StyleException(String.format("Unable to find relative class for 9-patch icon '%s'", iconPath));
    }
}

