/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.collection;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakHashSet<E>
extends AbstractSet<E> {
    @NotNull
    protected final WeakHashMap<E, Boolean> map;
    @NotNull
    protected final transient Set<E> keySet;

    public WeakHashSet() {
        this(10);
    }

    public WeakHashSet(int initialCapacity) {
        this.map = new WeakHashMap(initialCapacity);
        this.keySet = this.map.keySet();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean remove(@Nullable Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean add(@Nullable E e) {
        return this.map.put(e, Boolean.TRUE) == null;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.keySet.iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.keySet.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.keySet.toArray(a);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.keySet.containsAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.keySet.removeAll(c);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.keySet.retainAll(c);
    }

    @Override
    public int hashCode() {
        return this.keySet.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof Set && this.keySet.equals(o);
    }

    @Override
    @NotNull
    public String toString() {
        return this.keySet.toString();
    }
}

