/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.collection;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.utils.ArrayUtils;
import com.alee.utils.array.ArrayIterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class ImmutableCollection<E>
implements Collection<E>,
Cloneable,
Serializable {
    @NotNull
    protected final E[] data;

    public ImmutableCollection(E ... data) {
        this.data = data;
    }

    public ImmutableCollection(@NotNull Collection<? extends E> collection) {
        this.data = collection.toArray();
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public boolean contains(@Nullable Object element) {
        return ArrayUtils.contains(element, this.data);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.data;
    }

    @Override
    @NotNull
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array.length < this.size()) {
            return Arrays.copyOf(this.data, size, this.data.getClass());
        }
        System.arraycopy(this.data, 0, array, 0, size);
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new ArrayIterator((Object[])this.data){

            @Override
            public void remove() {
                throw ImmutableCollection.this.createModificationException();
            }
        };
    }

    @Override
    public boolean add(@Nullable E element) {
        throw this.createModificationException();
    }

    @Override
    public boolean remove(@Nullable Object element) {
        throw this.createModificationException();
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        for (Object element : collection) {
            if (ArrayUtils.contains(element, this.data)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> collection) {
        throw this.createModificationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        throw this.createModificationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        throw this.createModificationException();
    }

    @Override
    public void clear() {
        throw this.createModificationException();
    }

    @NotNull
    protected UnsupportedOperationException createModificationException() {
        return new UnsupportedOperationException("ImmutableCollection is unmodifiable");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.data);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutableCollection) {
            ImmutableCollection other = (ImmutableCollection)o;
            return Arrays.equals(this.data, other.data);
        }
        return false;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.data);
    }
}

