/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.utils.UtilityException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public final class NetUtils {
    private NetUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    @NotNull
    public static String getAddress(@NotNull URL url2) {
        try {
            return url2.toURI().toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to convert URL to address: " + url2, e);
        }
    }

    @NotNull
    public static URL getURL(@NotNull String address) {
        try {
            return new URL(address);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to create URL for address: " + address, e);
        }
    }

    @NotNull
    public static URI getURI(@NotNull String address) {
        return NetUtils.toURI(NetUtils.getURL(address));
    }

    @NotNull
    public static URI toURI(@NotNull URL url2) {
        try {
            return url2.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to convert URL to URI: " + url2, e);
        }
    }

    @NotNull
    public static String getHost(@NotNull String address) {
        return NetUtils.getURL(address).getHost();
    }

    public static int getPort(@NotNull String address) {
        return NetUtils.getURL(address).getPort();
    }

    @NotNull
    public static String getBaseAddress(@NotNull String address) {
        URL url2 = NetUtils.getURL(address);
        return url2.getHost() + (url2.getPort() != 80 && url2.getPort() != -1 ? ":" + url2.getPort() : "");
    }

    @NotNull
    public static String joinUrlPaths(@NotNull String part1, @NotNull String part2) {
        String separator = "/";
        boolean p1s = part1.endsWith("/");
        boolean p2s = part2.startsWith("/");
        String path = p1s && p2s ? part1 + part2.substring(1) : (!p1s && !p2s ? part1 + "/" + part2 : part1 + part2);
        return path;
    }
}

