/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.LookAndFeelException;
import com.alee.laf.rootpane.WRootPaneUI;
import com.alee.managers.style.ComponentDescriptor;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleManager;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.UtilityException;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.RootPaneUI;

public final class LafUtils {
    private LafUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static boolean isInDecoratedWindow(@Nullable Component component2) {
        RootPaneUI ui;
        boolean result2 = false;
        JRootPane rootPane = CoreSwingUtils.getRootPane(component2);
        if (rootPane != null && (ui = rootPane.getUI()) instanceof WRootPaneUI) {
            result2 = ((WRootPaneUI)ui).isDecorated();
        }
        return result2;
    }

    public static boolean hasUI(@NotNull JComponent component2) {
        return ReflectUtils.hasMethod(component2, "getUI", new Object[0]);
    }

    @Nullable
    public static <U extends ComponentUI> U getUI(@NotNull JComponent component2) {
        try {
            return (U)((ComponentUI)ReflectUtils.callMethod(component2, "getUI", new Object[0]));
        }
        catch (Exception e) {
            throw new StyleException("Unable to retrieve component UI: " + component2, e);
        }
    }

    public static void setUI(@NotNull JComponent component2, @Nullable ComponentUI ui) {
        try {
            ReflectUtils.callMethod(component2, "setUI", ui);
        }
        catch (Exception e) {
            throw new StyleException("Unable to setup component UI: " + component2, e);
        }
    }

    public static boolean hasWebLafUI(@NotNull JComponent component2) {
        boolean webUI;
        if (StyleManager.isSupported(component2)) {
            Object ui = LafUtils.getUI(component2);
            ComponentDescriptor descriptor = StyleManager.getDescriptor(component2);
            webUI = ui != null && descriptor.getBaseUIClass().isAssignableFrom(ui.getClass());
        } else {
            webUI = false;
        }
        return webUI;
    }

    @NotNull
    public static Point getTextCenterShift(@NotNull FontMetrics metrics, @NotNull String text) {
        return new Point(LafUtils.getTextCenterShiftX(metrics, text), LafUtils.getTextCenterShiftY(metrics));
    }

    public static int getTextCenterShiftX(@NotNull FontMetrics metrics, @NotNull String text) {
        return -metrics.stringWidth(text) / 2;
    }

    public static int getTextCenterShiftY(@NotNull FontMetrics metrics) {
        return (metrics.getAscent() - metrics.getLeading() - metrics.getDescent()) / 2;
    }

    public static void setupLookAndFeel(@NotNull Class<? extends LookAndFeel> clazz) throws LookAndFeelException {
        LafUtils.setupLookAndFeel(clazz.getCanonicalName());
    }

    public static void setupLookAndFeel(@NotNull String className) throws LookAndFeelException {
        try {
            UIManager.setLookAndFeel(className);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize LaF for class name: " + className, e);
        }
    }

    public static void installDefaults(@NotNull JComponent component2, @NotNull String prefix) {
        if (SwingUtils.isUIResource(component2.getFont())) {
            component2.setFont(UIManager.getFont(prefix + "font"));
        }
        if (SwingUtils.isUIResource(component2.getBackground())) {
            component2.setBackground(UIManager.getColor(prefix + "background"));
        }
        if (SwingUtils.isUIResource(component2.getForeground())) {
            component2.setForeground(UIManager.getColor(prefix + "foreground"));
        }
    }

    public static void uninstallDefaults(@NotNull JComponent component2) {
        if (SwingUtils.isUIResource(component2.getForeground())) {
            component2.setForeground(null);
        }
        if (SwingUtils.isUIResource(component2.getBackground())) {
            component2.setBackground(null);
        }
        if (SwingUtils.isUIResource(component2.getFont())) {
            component2.setFont(null);
        }
        LookAndFeel.uninstallBorder(component2);
    }
}

