/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Function;
import com.alee.laf.LookAndFeelException;
import com.alee.laf.WebUI;
import com.alee.utils.LafUtils;
import com.alee.utils.UtilityException;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public final class LafLookup {
    private LafLookup() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    @Nullable
    public static InputMap getInputMap(final @NotNull JComponent component2, int condition) {
        InputMap inputMap;
        Object ui = LafUtils.getUI(component2);
        if (ui instanceof WebUI) {
            WebUI webUI = (WebUI)ui;
            inputMap = condition == 2 ? LafLookup.getCompleteInputMap(component2, ui, webUI, condition, new Function<Object, InputMap>(){

                @Override
                @Nullable
                public InputMap apply(Object property) {
                    Object[] bindings = (Object[])property;
                    return bindings != null ? LookAndFeel.makeComponentInputMap(component2, bindings) : null;
                }
            }) : LafLookup.getCompleteInputMap(component2, ui, webUI, condition, new Function<Object, InputMap>(){

                @Override
                @Nullable
                public InputMap apply(Object property) {
                    return (InputMap)property;
                }
            });
        } else {
            throw new LookAndFeelException("Component UI is not a WebUI implementation: " + ui);
        }
        return inputMap;
    }

    @Nullable
    private static InputMap getCompleteInputMap(@NotNull JComponent component2, @NotNull ComponentUI ui, @NotNull WebUI webUI, int condition, @NotNull Function<Object, InputMap> propertyToInputMap) {
        InputMap rtlInputMap;
        String key = LafLookup.getInputMapPropertyKey(webUI, condition);
        InputMap inputMap = propertyToInputMap.apply(LafLookup.get(component2, ui, key));
        if (inputMap != null && !component2.getComponentOrientation().isLeftToRight() && (rtlInputMap = propertyToInputMap.apply(LafLookup.get(component2, ui, key + ".RightToLeft"))) != null) {
            rtlInputMap.setParent(inputMap);
            inputMap = rtlInputMap;
        }
        return inputMap;
    }

    @NotNull
    private static String getInputMapPropertyKey(@NotNull WebUI webUI, int condition) {
        String key;
        if (condition == 2) {
            key = webUI.getPropertyPrefix() + "windowBindings";
        } else if (condition == 0) {
            key = webUI.getPropertyPrefix() + "focusInputMap";
        } else if (condition == 1) {
            key = webUI.getPropertyPrefix() + "ancestorInputMap";
        } else {
            throw new LookAndFeelException("Unsupported InputMap condition: " + condition);
        }
        return key;
    }

    public static int getInt(@NotNull JComponent component2, @NotNull ComponentUI ui, @NotNull String key) {
        return LafLookup.getInt(component2, ui, key, -1);
    }

    public static int getInt(@NotNull JComponent component2, @NotNull ComponentUI ui, @NotNull String key, int defaultValue2) {
        Object iValue = LafLookup.get(component2, ui, key);
        int result2 = iValue instanceof Number ? ((Number)iValue).intValue() : defaultValue2;
        return result2;
    }

    @Nullable
    public static Insets getInsets(@NotNull JComponent component2, @NotNull ComponentUI ui, @NotNull String key) {
        return LafLookup.getInsets(component2, ui, key, null);
    }

    @Nullable
    public static Insets getInsets(@NotNull JComponent component2, @NotNull ComponentUI ui, @NotNull String key, @Nullable Insets defaultValue2) {
        Object iValue = LafLookup.get(component2, ui, key);
        Insets result2 = iValue instanceof Insets ? (Insets)iValue : defaultValue2;
        return result2;
    }

    public static boolean getBoolean(@NotNull JComponent component2, @NotNull ComponentUI ui, @NotNull String key) {
        return LafLookup.getBoolean(component2, ui, key, false);
    }

    public static boolean getBoolean(@NotNull JComponent component2, @NotNull ComponentUI ui, @NotNull String key, boolean defaultValue2) {
        Object iValue = LafLookup.get(component2, ui, key);
        boolean result2 = iValue instanceof Boolean ? (Boolean)iValue : defaultValue2;
        return result2;
    }

    @Nullable
    public static Color getColor(@NotNull JComponent component2, @NotNull ComponentUI ui, @NotNull String key) {
        return LafLookup.getColor(component2, ui, key, null);
    }

    @Nullable
    public static Color getColor(@NotNull JComponent component2, @NotNull ComponentUI ui, @NotNull String key, @Nullable Color defaultValue2) {
        Object iValue = LafLookup.get(component2, ui, key);
        Color result2 = iValue instanceof Color ? (Color)iValue : defaultValue2;
        return result2;
    }

    @Nullable
    public static Icon getIcon(@NotNull JComponent component2, @NotNull ComponentUI ui, @NotNull String key) {
        return LafLookup.getIcon(component2, ui, key, null);
    }

    @Nullable
    public static Icon getIcon(@NotNull JComponent component2, @NotNull ComponentUI ui, @NotNull String key, @Nullable Icon defaultValue2) {
        Object iValue = LafLookup.get(component2, ui, key);
        Icon result2 = iValue instanceof Icon ? (Icon)iValue : defaultValue2;
        return result2;
    }

    @Nullable
    public static Border getBorder(@NotNull JComponent component2, @NotNull ComponentUI ui, @NotNull String key) {
        return LafLookup.getBorder(component2, ui, key, null);
    }

    @Nullable
    public static Border getBorder(@NotNull JComponent component2, @NotNull ComponentUI ui, @NotNull String key, @Nullable Border defaultValue2) {
        Object iValue = LafLookup.get(component2, ui, key);
        Border result2 = iValue instanceof Border ? (Border)iValue : defaultValue2;
        return result2;
    }

    @Nullable
    public static Object get(@NotNull JComponent component2, @NotNull ComponentUI ui, @NotNull String key) {
        return UIManager.get(key, component2.getLocale());
    }
}

