/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.utils.UtilityException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    public static final int EOF = -1;

    public static byte[] toByteArray(@NotNull InputStream inputStream) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, output);
        return output.toByteArray();
    }

    public static long copy(@NotNull InputStream input, @NotNull OutputStream output) {
        return IOUtils.copy(input, output, 10240);
    }

    public static long copy(@NotNull InputStream input, @NotNull OutputStream output, int bufferSize) {
        return IOUtils.copy(input, output, new byte[bufferSize]);
    }

    public static long copy(@NotNull InputStream input, @NotNull OutputStream output, @NotNull byte[] buffer) {
        try {
            int n;
            long count = 0L;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
            return count;
        }
        catch (Exception e) {
            throw new UtilityException("Unable to copy InputStream to OutputStream: " + input, e);
        }
    }
}

