/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.resource.Resource;
import com.alee.managers.language.LM;
import com.alee.managers.proxy.ProxyManager;
import com.alee.utils.ImageUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.WebUtils;
import com.alee.utils.compare.Filter;
import com.alee.utils.file.FileComparator;
import com.alee.utils.file.FileDescription;
import com.alee.utils.file.FileDownloadListener;
import com.alee.utils.file.SystemFileListener;
import com.alee.utils.filefilter.AbstractFileFilter;
import com.alee.utils.filefilter.AllFilesFilter;
import com.alee.utils.filefilter.IOFileFilterAdapter;
import com.alee.utils.filefilter.SwingFileFilterAdapter;
import com.alee.utils.swing.WebTimer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.JTextComponent;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final String CACHE_KEYS_SEPARATOR = "|";
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final long PB = 0x4000000000000L;
    private static final FileSystemView fsv = FileSystemView.getFileSystemView();
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy HH:mm");
    private static final String defaultEncoding = "UTF-8";
    private static final int MD5_BUFFER_LENGTH = 102400;
    private static final int TEXT_BUFFER_SIZE = 65536;
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '\"', '`', '!', '?', '*', '\\', '<', '>', '|', ':', ';', '.', ',', '%', '$', '@', '#', '^', '{', '}', '[', ']', ']'};
    private static final Map<String, Boolean> isDriveCache = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> isComputerCache = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> isCdDriveCache = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> isFileCache = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> isDirectoryCache = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> isHiddenCache = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, String> displayFileNameCache = new ConcurrentHashMap<String, String>();
    private static final Map<String, FileDescription> fileDescriptionCache = new ConcurrentHashMap<String, FileDescription>();
    private static final Map<String, String> fileTypeDescriptionCache = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> displayFileCreationDateCache = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> displayFileModificationDateCache = new ConcurrentHashMap<String, String>();
    private static final Object extensionIconsCacheLock = new Object();
    private static final Map<String, Icon> extensionIconsCache = new ConcurrentHashMap<String, Icon>();
    private static final Map<String, Icon> resourceIconsCache = new ConcurrentHashMap<String, Icon>();
    private static final int FILE_TRACKING_DELAY = 5000;
    public static final FileComparator FILE_COMPARATOR = new FileComparator();

    private FileUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    @Nullable
    public static URL getJarLocationURL(@NotNull Class jarClass) {
        CodeSource src = jarClass.getProtectionDomain().getCodeSource();
        return src != null ? src.getLocation() : null;
    }

    @Nullable
    public static File getJarLocationFile(@NotNull Class jarClass) {
        File file = null;
        try {
            URL jarUrl;
            URI uri;
            String scheme;
            CodeSource src = jarClass.getProtectionDomain().getCodeSource();
            if (src != null && (scheme = (uri = (jarUrl = src.getLocation()).toURI()).getScheme()) != null && scheme.equalsIgnoreCase("file")) {
                file = new File(uri);
            }
        }
        catch (URISyntaxException e) {
            LoggerFactory.getLogger(FileUtils.class).error(e.toString(), e);
        }
        return file;
    }

    public static void clearFilesCaches(File ... files2) {
        if (files2 != null && files2.length > 0) {
            for (File file : files2) {
                FileUtils.clearFileCaches(file);
            }
        }
    }

    public static void clearFileCaches(@Nullable File file) {
        if (file != null) {
            FileUtils.clearFileCaches(file.getAbsolutePath());
        }
    }

    public static void clearFileCaches(@NotNull String path) {
        FileUtils.clearDisplayFileNameCache(path);
        FileUtils.clearIsHiddenCache(path);
        FileUtils.clearIsFileCache(path);
        FileUtils.clearIsDirectoryCache(path);
        FileUtils.clearIsComputerCache(path);
        FileUtils.clearIsDriveCache(path);
        FileUtils.clearIsCdDriveCache(path);
        FileUtils.clearFileDescriptionCache(path);
        FileUtils.clearFileTypeDescriptionCache(path);
        FileUtils.clearDisplayFileCreationDateCache(path);
        FileUtils.clearDisplayFileModificationDateCache(path);
    }

    @NotNull
    public static List<File> getFilePath(@Nullable File file) {
        ArrayList<File> path = new ArrayList<File>();
        while (file != null) {
            path.add(0, file);
            file = FileUtils.getParent(file);
        }
        return path;
    }

    @NotNull
    public static String getRelativePath(@NotNull File file, @NotNull File folder) {
        return folder.toURI().relativize(file.toURI()).getPath();
    }

    public static boolean isNameEditable(@NotNull File file) {
        File parent = FileUtils.getParent(file);
        return parent != null && parent.canWrite() && file.canWrite();
    }

    public static void displayFileName(@NotNull JTextComponent editor, @NotNull File file) {
        String name = file.getName();
        editor.setText(name);
        editor.setSelectionStart(0);
        editor.setSelectionEnd(file.isDirectory() ? name.length() : FileUtils.getFileNamePart(name).length());
    }

    @NotNull
    public static File getSystemTemp() {
        return new File(FileUtils.getSystemTempPath());
    }

    @NotNull
    public static String getSystemTempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static boolean grantExecutePermissions(@NotNull File file) {
        boolean granted;
        try {
            granted = file.setExecutable(true, false);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(FileUtils.class).error(e.toString(), e);
            granted = false;
        }
        return granted;
    }

    @Nullable
    public static File normalize(@Nullable File file) {
        File normalized;
        try {
            normalized = file != null ? file.getCanonicalFile() : null;
        }
        catch (IOException e) {
            normalized = file;
        }
        return normalized;
    }

    @Nullable
    public static File getSystemRoot() {
        File[] roots = FileUtils.getSystemRoots();
        return roots.length > 0 ? roots[0] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static File[] getSystemRoots() {
        File[] systemRoots;
        FileSystemView fileSystemView = fsv;
        synchronized (fileSystemView) {
            systemRoots = fsv.getRoots();
        }
        File[] roots = systemRoots != null && systemRoots.length > 0 ? systemRoots : FileUtils.getDiskRoots();
        return roots;
    }

    @NotNull
    public static File[] getDiskRoots() {
        File[] roots = File.listRoots();
        int proper = 0;
        for (File root : roots) {
            if (!FileUtils.isDirectory(root)) continue;
            ++proper;
        }
        File[] properRoots = new File[proper];
        int currentIndex = 0;
        for (File root : roots) {
            if (!FileUtils.isDirectory(root)) continue;
            properRoots[currentIndex] = root;
            ++currentIndex;
        }
        return properRoots;
    }

    @NotNull
    public static File[] listFiles(@NotNull File directory) {
        return FileUtils.listFiles(directory, (FileFilter)null);
    }

    @NotNull
    public static File[] listFiles(@NotNull File directory, final @Nullable Filter<File> fileFilter) {
        return FileUtils.listFiles(directory, fileFilter != null ? new FileFilter(){

            @Override
            public boolean accept(@NotNull File file) {
                return fileFilter.accept(file);
            }
        } : null);
    }

    @NotNull
    public static File[] listFiles(@NotNull File directory, @Nullable FileFilter fileFilter) {
        File[] files2 = fileFilter != null ? directory.listFiles(fileFilter) : directory.listFiles();
        return files2 != null ? files2 : new File[]{};
    }

    @NotNull
    public static String computeMD5(@NotNull String data) {
        return FileUtils.computeMD5(data, 102400);
    }

    @NotNull
    public static String computeMD5(@NotNull String data, int bufferLength) {
        return FileUtils.computeMD5(new ByteArrayInputStream(data.getBytes()), bufferLength);
    }

    @NotNull
    public static String computeMD5(@NotNull Resource resource) {
        return FileUtils.computeMD5(resource, 102400);
    }

    @NotNull
    public static String computeMD5(@NotNull Resource resource, int bufferLength) {
        return FileUtils.computeMD5(resource.getInputStream(), bufferLength);
    }

    @NotNull
    public static String computeMD5(@NotNull InputStream inputStream) {
        return FileUtils.computeMD5(inputStream, 102400);
    }

    @NotNull
    public static String computeMD5(@NotNull InputStream inputStream, int bufferLength) {
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        try {
            int bytesRead;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[bufferLength];
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) > 0) {
                digest.update(buffer, 0, bytesRead);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            String string = bigInt.toString(16);
            return string;
        }
        catch (Exception e) {
            throw new UtilityException("Unable to compute MD5 for InputStream: " + inputStream, e);
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception exception) {}
        }
    }

    @NotNull
    public static File getWorkingDirectory() {
        return new File(FileUtils.getWorkingDirectoryPath());
    }

    @NotNull
    public static String getWorkingDirectoryPath() {
        return System.getProperty("user.dir");
    }

    @NotNull
    public static File getUserHome() {
        return new File(FileUtils.getUserHomePath());
    }

    @NotNull
    public static String getUserHomePath() {
        String home = System.getProperty("user.home");
        if (!home.endsWith(File.separator)) {
            home = home + File.separator;
        }
        return home;
    }

    @Nullable
    public static File getDesktop() {
        File common;
        File desktop = null;
        File[] roots = fsv.getRoots();
        if (roots.length > 0) {
            for (File root : roots) {
                if (!root.getName().toLowerCase(Locale.ROOT).contains("desktop")) continue;
                desktop = root;
                break;
            }
        }
        if (desktop == null && (common = new File(FileUtils.getUserHome(), "Desktop")).exists()) {
            desktop = common;
        }
        return desktop;
    }

    @Nullable
    public static String getDesktopPath() {
        File desktop = FileUtils.getDesktop();
        return desktop != null ? desktop.getAbsolutePath() : null;
    }

    public static boolean equals(@Nullable File file1, @Nullable File file2) {
        boolean equals;
        if (file1 == null && file2 == null) {
            equals = true;
        } else {
            try {
                boolean notNull = file1 != null && file2 != null;
                equals = notNull && file1.getCanonicalPath().equals(file2.getCanonicalPath());
            }
            catch (IOException e) {
                equals = file1.getAbsolutePath().equals(file2.getAbsolutePath());
            }
        }
        return equals;
    }

    public static boolean equals(@NotNull List<File> files1, @NotNull List<File> files2) {
        boolean equals;
        if (files1.size() == files2.size()) {
            equals = true;
            if (files1.size() != 0) {
                for (int i = 0; i < files1.size(); ++i) {
                    if (FileUtils.equals(files1.get(i), files2.get(i))) continue;
                    equals = false;
                    break;
                }
            }
        } else {
            equals = false;
        }
        return equals;
    }

    public static boolean containsFile(@NotNull List files2, @NotNull File file) {
        boolean contains = false;
        for (Object f : files2) {
            if (f instanceof File) {
                if (!((File)f).getAbsolutePath().equals(file.getAbsolutePath())) continue;
                contains = true;
                break;
            }
            if (!(f instanceof String) || !f.equals(file.getAbsolutePath())) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static boolean isFileAccepted(@NotNull File file, @Nullable List<AbstractFileFilter> filters) {
        boolean accepted;
        if (filters != null && filters.size() != 0) {
            accepted = false;
            for (FileFilter fileFilter : filters) {
                if (!fileFilter.accept(file)) continue;
                accepted = true;
                break;
            }
        } else {
            accepted = true;
        }
        return accepted;
    }

    @NotNull
    public static String getProperFileName(@NotNull String name) {
        StringBuilder newName = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (FileUtils.isIllegalFileNameChar(name.charAt(i))) continue;
            newName.append(name.charAt(i));
        }
        return newName.toString().replaceAll(" ", "_");
    }

    public static boolean isIllegalFileNameChar(char c) {
        boolean isIllegal = false;
        for (char ILLEGAL_CHARACTER : ILLEGAL_CHARACTERS) {
            if (c != ILLEGAL_CHARACTER) continue;
            isIllegal = true;
        }
        return isIllegal;
    }

    @NotNull
    public static String canonicalPath(@NotNull File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new UtilityException("Unable to retrieve file canonical path: " + file, e);
        }
    }

    @Nullable
    public static File getParent(@NotNull File file) {
        String parentPath;
        File nativeParent = file.getParentFile();
        File parent = nativeParent != null ? nativeParent : ((parentPath = file.getParent()) != null ? new File(parentPath) : null);
        return parent;
    }

    @Nullable
    public static File getTopParent(@NotNull File file) {
        File result2 = null;
        File parent = FileUtils.getParent(file.getAbsoluteFile());
        while (parent != null) {
            result2 = parent;
            parent = FileUtils.getParent(parent);
        }
        return result2;
    }

    public static boolean isParent(@Nullable File parent, @Nullable File child) {
        boolean isParent;
        if (child == parent) {
            isParent = false;
        } else if (child == null) {
            isParent = false;
        } else if (parent == null) {
            isParent = true;
        } else if (child.equals(parent)) {
            isParent = false;
        } else {
            isParent = false;
            child = child.getAbsoluteFile();
            File cp = FileUtils.getParent(child);
            while (cp != null) {
                if (cp.equals(parent)) {
                    isParent = true;
                    break;
                }
                cp = FileUtils.getParent(cp);
            }
        }
        return isParent;
    }

    @NotNull
    public static String getFileNamePart(@Nullable File file) {
        return file != null ? FileUtils.getFileNamePart(file.getName()) : "";
    }

    @NotNull
    public static String getFileNamePart(@Nullable String name) {
        String namePart;
        if (TextUtils.notEmpty(name)) {
            int first = name.indexOf(".");
            int last = name.lastIndexOf(".");
            namePart = last == -1 || first == 0 && first == last ? name : name.substring(0, last);
        } else {
            namePart = "";
        }
        return namePart;
    }

    @NotNull
    public static String getFileExtPart(@Nullable File file, boolean withDot) {
        return file != null ? FileUtils.getFileExtPart(file.getName(), withDot) : "";
    }

    @NotNull
    public static String getFileExtPart(@Nullable String name, boolean withDot) {
        int i;
        String ext = TextUtils.notEmpty(name) ? ((i = name.lastIndexOf(".")) == -1 ? "" : (withDot ? name.substring(i) : name.substring(i + 1))) : "";
        return ext;
    }

    @NotNull
    public static String getShortFileName(@Nullable String name) {
        return FileUtils.getShortFileName(name, 30);
    }

    @NotNull
    public static String getShortFileName(@Nullable String name, int length) {
        String newName;
        String shortName;
        String string = shortName = name != null ? name : "";
        if (length >= 2 && (newName = FileUtils.getFileNamePart(name)).length() > length) {
            shortName = newName.substring(0, length - 2) + "..." + FileUtils.getFileExtPart(name, false);
        }
        return shortName;
    }

    @Nullable
    public static List<File> sortFiles(@Nullable List<File> files2) {
        if (files2 != null) {
            Collections.sort(files2, FILE_COMPARATOR);
        }
        return files2;
    }

    @Nullable
    public static File[] sortFiles(@Nullable File[] files2) {
        if (files2 != null) {
            Arrays.sort(files2, FILE_COMPARATOR);
        }
        return files2;
    }

    @NotNull
    public static String getAvailableName(@NotNull String dir, @NotNull String name) {
        return FileUtils.getAvailableName(new File(dir), name);
    }

    @NotNull
    public static String getAvailableName(@NotNull File dir, @NotNull String name) {
        ArrayList<String> exist = new ArrayList<String>();
        File[] files2 = dir.listFiles();
        if (files2 != null) {
            for (File file : files2) {
                exist.add(file.getName());
            }
        }
        return FileUtils.getAvailableName(exist, name);
    }

    @NotNull
    public static String getAvailableName(@NotNull List<String> existingNames, @NotNull String name) {
        String availableName = name;
        if (existingNames.contains(availableName)) {
            Integer n;
            int dot = availableName.lastIndexOf(".");
            String nameStart = dot != -1 ? availableName.substring(0, dot).trim() : availableName;
            String nameExt = dot != -1 ? availableName.substring(availableName.lastIndexOf(".")) : null;
            int ob = nameStart.lastIndexOf("(");
            int cb = nameStart.lastIndexOf(")");
            String nameReal = null;
            Integer index = null;
            if (ob < cb && cb == nameStart.length() - 1) {
                try {
                    nameReal = nameStart.substring(0, ob);
                    Integer n2 = index = Integer.valueOf(Integer.parseInt(nameStart.substring(ob + 1, cb)));
                    n = index = Integer.valueOf(index + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int i = 1;
            while (existingNames.contains(availableName)) {
                if (nameReal != null && index != null) {
                    availableName = nameReal + "(" + index + ")" + nameExt;
                    n = index;
                    Integer n3 = index = Integer.valueOf(index + 1);
                    continue;
                }
                availableName = nameStart + " (" + i + ")" + (nameExt != null ? nameExt : "");
                ++i;
            }
        }
        return availableName;
    }

    @NotNull
    public static List<File> toFilesList(Object ... object) {
        ArrayList<File> files2 = new ArrayList<File>(object != null ? object.length : 0);
        for (Object e : files2) {
            if (!(e instanceof File)) continue;
            files2.add((File)e);
        }
        return files2;
    }

    public static void deleteFiles(Object ... files2) {
        for (Object object : files2) {
            if (!(object instanceof File)) continue;
            FileUtils.deleteFile((File)object);
        }
    }

    public static void deleteFiles(@NotNull List files2) {
        for (Object object : files2) {
            if (!(object instanceof File)) continue;
            FileUtils.deleteFile((File)object);
        }
    }

    public static void deleteFile(@NotNull File file) {
        if (file.exists()) {
            if (file.isFile()) {
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            } else if (file.isDirectory()) {
                File[] files2 = file.listFiles();
                if (files2 != null) {
                    for (File child : files2) {
                        FileUtils.deleteFile(child);
                    }
                }
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
        }
    }

    public static void clearDirectory(@NotNull File dir) {
        File[] files2;
        if (dir.exists() && dir.isDirectory() && (files2 = dir.listFiles()) != null) {
            for (File child : files2) {
                FileUtils.deleteFile(child);
            }
        }
    }

    @NotNull
    public static AbstractFileFilter transformFileFilter(@NotNull FileFilter fileFilter) {
        AbstractFileFilter abstractFileFilter = fileFilter instanceof AbstractFileFilter ? (AbstractFileFilter)fileFilter : new IOFileFilterAdapter(fileFilter, AllFilesFilter.ICON, LM.get("weblaf.file.filter.custom", new Object[0]));
        return abstractFileFilter;
    }

    @NotNull
    public static AbstractFileFilter transformFileFilter(@NotNull javax.swing.filechooser.FileFilter fileFilter) {
        AbstractFileFilter abstractFileFilter = fileFilter instanceof AbstractFileFilter ? (AbstractFileFilter)fileFilter : new SwingFileFilterAdapter(fileFilter, AllFilesFilter.ICON);
        return abstractFileFilter;
    }

    @Nullable
    public static javax.swing.filechooser.FileFilter getSwingFileFilter(@Nullable AbstractFileFilter fileFilter) {
        return fileFilter != null && fileFilter instanceof SwingFileFilterAdapter ? ((SwingFileFilterAdapter)fileFilter).getFileFilter() : fileFilter;
    }

    @NotNull
    public static List<File> filterFiles(@NotNull Collection<File> files2, @NotNull AbstractFileFilter fileFilter) {
        ArrayList<File> filteredFiles = new ArrayList<File>(files2.size());
        for (File file : files2) {
            if (!fileFilter.accept(file)) continue;
            filteredFiles.add(file);
        }
        return filteredFiles;
    }

    @NotNull
    public static List<File> filterFiles(@NotNull Collection<File> files2, @NotNull Filter<File> fileFilter) {
        ArrayList<File> filteredFiles = new ArrayList<File>(files2.size());
        for (File file : files2) {
            if (!fileFilter.accept(file)) continue;
            filteredFiles.add(file);
        }
        return filteredFiles;
    }

    @NotNull
    public static FileDescription createFileDescription(@NotNull File file, @Nullable String fileSize) {
        String name = FileUtils.getDisplayFileName(file);
        String size = file.isFile() ? FileUtils.getDisplayFileSize(file) + (fileSize != null ? " (" + fileSize + ")" : "") : null;
        String description = FileUtils.getFileTypeDescription(file);
        return new FileDescription(name, size, description, null);
    }

    @NotNull
    public static String getDisplayFileSize(@NotNull File file) {
        return FileUtils.getFileSizeString(file.length());
    }

    @NotNull
    public static String getDisplayFileSize(@NotNull File file, int digits) {
        return FileUtils.getFileSizeString(file.length(), digits);
    }

    @NotNull
    public static String getFileSizeString(long size) {
        return FileUtils.getFileSizeString(size, 2);
    }

    @NotNull
    public static String getFileSizeString(long size, int digits) {
        DecimalFormat df = new DecimalFormat(digits > 0 ? "#." + TextUtils.createString("#", digits) : "#");
        String fileSizeString = size < 1024L ? df.format(size) + " " + LM.get("weblaf.file.size.b", new Object[0]) : (size < 0x100000L ? df.format((float)size / 1024.0f) + " " + LM.get("weblaf.file.size.kb", new Object[0]) : (size < 0x40000000L ? df.format((float)size / 1048576.0f) + " " + LM.get("weblaf.file.size.mb", new Object[0]) : (size < 0x10000000000L ? df.format((float)size / 1.0737418E9f) + " " + LM.get("weblaf.file.size.gb", new Object[0]) : (size < 0x4000000000000L ? df.format((float)size / 1.0995116E12f) + " " + LM.get("weblaf.file.size.tb", new Object[0]) : df.format((float)size / 1.1258999E15f) + " " + LM.get("weblaf.file.size.pb", new Object[0])))));
        return fileSizeString;
    }

    public static boolean copyDirectory(@NotNull String src, @NotNull String dst) {
        return FileUtils.copyDirectory(src, dst, false);
    }

    public static boolean copyDirectory(@NotNull String src, @NotNull String dst, boolean stopOnFail) {
        return FileUtils.copyDirectory(new File(src), new File(dst), stopOnFail);
    }

    public static boolean copyDirectory(@NotNull File srcDir, @NotNull File dstDir) {
        return FileUtils.copyDirectory(srcDir, dstDir, false);
    }

    public static boolean copyDirectory(@NotNull File srcDir, @NotNull File dstDir, boolean stopOnFail) {
        boolean success;
        if (srcDir.exists() && srcDir.isDirectory()) {
            if (FileUtils.ensureDirectoryExists(dstDir)) {
                success = true;
                File[] files2 = srcDir.listFiles();
                if (files2 != null) {
                    for (File file : files2) {
                        String copied = dstDir.getAbsolutePath() + File.separator + file.getName();
                        if (file.isDirectory()) {
                            boolean bl = success = FileUtils.copyDirectory(file.getAbsolutePath(), copied) && success;
                            if (success || !stopOnFail) continue;
                        } else {
                            boolean bl = success = FileUtils.copyFile(file.getAbsolutePath(), copied) && success;
                            if (success || !stopOnFail) {
                                continue;
                            }
                        }
                        break;
                    }
                }
            } else {
                success = false;
            }
        } else {
            success = false;
        }
        return success;
    }

    public static boolean copyFile(@Nullable String src, @Nullable String dst) {
        File srcFile = src != null ? new File(src) : null;
        File dstFile = dst != null ? new File(dst) : null;
        return FileUtils.copyFile(srcFile, dstFile);
    }

    public static boolean copyFile(@Nullable File srcFile, @Nullable File dstFile) {
        boolean success = false;
        if (srcFile != null && srcFile.exists() && srcFile.isFile() && dstFile != null) {
            try {
                if (FileUtils.ensureDirectoryExists(FileUtils.getParent(dstFile))) {
                    FileChannel srcFC = new FileInputStream(srcFile).getChannel();
                    FileChannel dstFC = new FileOutputStream(dstFile).getChannel();
                    success = FileUtils.copyFile(srcFC, dstFC);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return success;
    }

    public static boolean copyFile(@NotNull FileChannel srcFC, @NotNull FileChannel dstFC) {
        boolean success;
        try {
            dstFC.transferFrom(srcFC, 0L, srcFC.size());
            srcFC.close();
            dstFC.close();
            success = true;
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    @NotNull
    public static String readToString(@NotNull Resource resource) {
        return FileUtils.readToString(resource, defaultEncoding);
    }

    @NotNull
    public static String readToString(@NotNull Resource resource, @NotNull String encoding) {
        return FileUtils.readToString(resource.getInputStream(), encoding);
    }

    @NotNull
    public static String readToString(@NotNull InputStream inputStream) {
        return FileUtils.readToString(inputStream, defaultEncoding);
    }

    @NotNull
    public static String readToString(@NotNull InputStream inputStream, @NotNull String encoding) {
        try {
            String string = FileUtils.readToString(new InputStreamReader(inputStream, encoding));
            return string;
        }
        catch (Exception e) {
            throw new UtilityException("Unable to read InputStream to string: " + inputStream, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    public static String readToString(@NotNull Reader reader) {
        try {
            int charsRead;
            char[] buffer = new char[65536];
            StringBuilder sb = new StringBuilder();
            while ((charsRead = reader.read(buffer, 0, 65536)) != -1) {
                sb.append(buffer, 0, charsRead);
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw new UtilityException("Unable to read Reader to string: " + reader, e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void writeStringToFile(@NotNull String text, @NotNull File file) {
        FileUtils.writeStringToFile(text, file, defaultEncoding);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeStringToFile(@NotNull String text, @NotNull File file, @NotNull String encoding) {
        if (file.exists() && file.isDirectory()) throw new UtilityException("Specified file points to existing folder!");
        File parent = FileUtils.getParent(file);
        if (parent == null) throw new UtilityException("Unable to determine file location: " + file);
        parent.mkdirs();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file, encoding);
            writer.write(text);
            return;
        }
        catch (Exception e) {
            throw new UtilityException("Unable to write string to file: " + file, e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @NotNull
    public static List<String> getSubPaths(@NotNull String dir) {
        return FileUtils.getSubPaths(new File(dir));
    }

    @NotNull
    public static List<String> getSubPaths(@NotNull File dir) {
        return FileUtils.getSubPaths(dir, "");
    }

    @NotNull
    public static List<String> getSubPaths(@NotNull File dir, @NotNull String path) {
        return FileUtils.getSubPaths(dir, path, new ArrayList<String>());
    }

    @NotNull
    public static List<String> getSubPaths(@NotNull File dir, @NotNull String path, @NotNull List<String> paths) {
        File[] files2 = dir.listFiles();
        if (files2 != null) {
            for (File file : files2) {
                if (file.isFile()) {
                    paths.add(path + file.getName());
                    continue;
                }
                if (!file.isDirectory()) continue;
                FileUtils.getSubPaths(file, path + file.getName() + File.separator, paths);
            }
        }
        return paths;
    }

    @NotNull
    public static File downloadFile(@NotNull String url2, @NotNull File dstFile) {
        return FileUtils.downloadFile(url2, dstFile, false, null, 3000, null);
    }

    @NotNull
    public static File downloadFile(@NotNull String url2, @NotNull File dstFile, @Nullable FileDownloadListener listener) {
        return FileUtils.downloadFile(url2, dstFile, false, null, 3000, listener);
    }

    @NotNull
    public static File downloadFile(@NotNull String url2, @NotNull String dst, boolean encodeUrl, @Nullable String contentType, int timeout) {
        return FileUtils.downloadFile(url2, new File(dst), encodeUrl, contentType, timeout, null);
    }

    @NotNull
    public static File downloadFile(@NotNull String url2, @NotNull String dst, boolean encodeUrl, @Nullable String contentType, int timeout, @Nullable FileDownloadListener listener) {
        return FileUtils.downloadFile(url2, new File(dst), encodeUrl, contentType, timeout, listener);
    }

    @NotNull
    public static File downloadFile(@NotNull String url2, @NotNull File dstFile, boolean encodeUrl, @Nullable String contentType, int timeout) {
        return FileUtils.downloadFile(url2, dstFile, encodeUrl, contentType, timeout, null);
    }

    @NotNull
    public static File downloadFile(@NotNull String url2, @NotNull File dstFile, boolean encodeUrl, @Nullable String contentType, int timeout, @Nullable FileDownloadListener listener) {
        try {
            int bytesRead;
            String ct;
            URL encodedUrl = new URL(encodeUrl ? WebUtils.encodeUrl(url2) : url2);
            URLConnection uc = ProxyManager.getURLConnection(encodedUrl);
            if (timeout != 0) {
                uc.setConnectTimeout(timeout);
                uc.setReadTimeout(timeout);
            }
            if (listener != null && listener.shouldStopDownload()) {
                FileUtils.deleteFile(dstFile);
                listener.fileDownloadAborted();
                throw new UtilityException("File download was aborted");
            }
            if (contentType != null && !(ct = uc.getContentType()).contains(contentType)) {
                FileUtils.deleteFile(dstFile);
                if (listener != null) {
                    listener.fileDownloadAborted();
                }
                throw new UtilityException("File download was aborted due to content type not matching requested content type");
            }
            if (listener != null) {
                listener.sizeDetermined(uc.getContentLength());
                if (listener.shouldStopDownload()) {
                    FileUtils.deleteFile(dstFile);
                    listener.fileDownloadAborted();
                    throw new UtilityException("File download was aborted");
                }
            }
            InputStream in = uc.getInputStream();
            FileOutputStream out = new FileOutputStream(dstFile);
            if (listener != null && listener.shouldStopDownload()) {
                out.flush();
                out.close();
                in.close();
                FileUtils.deleteFile(dstFile);
                listener.fileDownloadAborted();
                throw new UtilityException("File download was aborted");
            }
            byte[] buf2 = new byte[51200];
            int totalBytesRead = 0;
            while ((bytesRead = in.read(buf2)) != -1) {
                if (listener != null) {
                    listener.partDownloaded(totalBytesRead += bytesRead);
                    if (listener.shouldStopDownload()) {
                        out.flush();
                        out.close();
                        in.close();
                        FileUtils.deleteFile(dstFile);
                        listener.fileDownloadAborted();
                        throw new UtilityException("File download was aborted");
                    }
                }
                out.write(buf2, 0, bytesRead);
            }
            out.flush();
            out.close();
            in.close();
            if (listener != null) {
                listener.fileDownloaded(dstFile);
            }
            return dstFile;
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fileDownloadFailed(e);
            }
            throw new UtilityException("Unable to download file from URL: " + url2, e);
        }
    }

    public static int getFileSize(@NotNull String url2) {
        try {
            return FileUtils.getFileSize(new URL(url2));
        }
        catch (Exception e) {
            throw new UtilityException("Unable to retrieve file size for URL: " + url2, e);
        }
    }

    public static int getFileSize(@NotNull URL url2) {
        try {
            URLConnection uc = ProxyManager.getURLConnection(url2);
            return uc.getContentLength();
        }
        catch (Exception e) {
            throw new UtilityException("Unable to retrieve file size for URL: " + url2, e);
        }
    }

    @NotNull
    public static List<File> findFilesRecursively(@NotNull String dir, @NotNull List<String> extension2) {
        return FileUtils.findFilesRecursively(new File(dir), extension2);
    }

    @NotNull
    public static List<File> findFilesRecursively(@NotNull File dir, @NotNull List<String> extension2) {
        return FileUtils.findFilesRecursively(dir, extension2, true);
    }

    @NotNull
    public static List<File> findFilesRecursively(@NotNull String dir, @NotNull List<String> extension2, boolean withDot) {
        return FileUtils.findFilesRecursively(new File(dir), extension2, withDot);
    }

    @NotNull
    public static List<File> findFilesRecursively(@NotNull File dir, @NotNull List<String> extension2, boolean withDot) {
        return FileUtils.findFilesRecursively(dir, extension2, withDot, new ArrayList<File>());
    }

    @NotNull
    public static List<File> findFilesRecursively(@NotNull String dir, @NotNull List<String> extension2, boolean withDot, @NotNull List<File> found) {
        return FileUtils.findFilesRecursively(new File(dir), extension2, withDot, found);
    }

    @NotNull
    public static List<File> findFilesRecursively(@NotNull File dir, final @NotNull List<String> extension2, final boolean withDot, @NotNull List<File> found) {
        return FileUtils.findFilesRecursively(dir, new FileFilter(){

            @Override
            public boolean accept(@NotNull File file) {
                return file.isFile() && extension2.contains(FileUtils.getFileExtPart(file.getName(), withDot));
            }
        }, found);
    }

    @NotNull
    public static List<File> findFilesRecursively(@NotNull String dir, @NotNull FileFilter filter2) {
        return FileUtils.findFilesRecursively(new File(dir), filter2);
    }

    @NotNull
    public static List<File> findFilesRecursively(@NotNull File dir, @NotNull FileFilter filter2) {
        return FileUtils.findFilesRecursively(dir, filter2, new ArrayList<File>());
    }

    @NotNull
    public static List<File> findFilesRecursively(@NotNull String dir, @NotNull FileFilter filter2, @NotNull List<File> found) {
        return FileUtils.findFilesRecursively(new File(dir), filter2, found);
    }

    @NotNull
    public static List<File> findFilesRecursively(@NotNull File dir, @NotNull FileFilter filter2, @NotNull List<File> found) {
        File[] files2;
        if (dir.exists() && dir.isDirectory() && (files2 = dir.listFiles()) != null) {
            for (File file : files2) {
                if (filter2.accept(file)) {
                    found.add(file);
                }
                if (!file.isDirectory()) continue;
                FileUtils.findFilesRecursively(file, filter2, found);
            }
        }
        return found;
    }

    public static boolean ensureDirectoryExists(@Nullable String dir) {
        return dir != null && FileUtils.ensureDirectoryExists(new File(dir));
    }

    public static boolean ensureDirectoryExists(@Nullable File dir) {
        return dir != null && (dir.exists() || dir.mkdirs());
    }

    public static void clearIsDriveCache() {
        isDriveCache.clear();
    }

    public static void clearIsDriveCache(@NotNull String absolutePath) {
        isDriveCache.remove(absolutePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDrive(@NotNull File file) {
        boolean isDrive;
        String absolutePath = file.getAbsolutePath();
        if (isDriveCache.containsKey(absolutePath)) {
            isDrive = isDriveCache.get(absolutePath);
        } else if (file.exists()) {
            FileSystemView fileSystemView = fsv;
            synchronized (fileSystemView) {
                isDrive = fsv.isDrive(file);
            }
            isDriveCache.put(absolutePath, isDrive);
        } else {
            isDrive = false;
        }
        return isDrive;
    }

    public static void clearIsComputerCache() {
        isComputerCache.clear();
    }

    public static void clearIsComputerCache(@NotNull String absolutePath) {
        isComputerCache.remove(absolutePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isComputer(@NotNull File file) {
        boolean isComputer;
        String absolutePath = file.getAbsolutePath();
        if (isComputerCache.containsKey(absolutePath)) {
            isComputer = isComputerCache.get(absolutePath);
        } else if (file.exists()) {
            FileSystemView fileSystemView = fsv;
            synchronized (fileSystemView) {
                isComputer = fsv.isComputerNode(file);
            }
            isComputerCache.put(absolutePath, isComputer);
        } else {
            isComputer = false;
        }
        return isComputer;
    }

    public static void clearIsCdDriveCache() {
        isCdDriveCache.clear();
    }

    public static void clearIsCdDriveCache(@NotNull String absolutePath) {
        isCdDriveCache.remove(absolutePath);
    }

    public static boolean isCdDrive(@NotNull File file) {
        boolean isCdDrive;
        String absolutePath = file.getAbsolutePath();
        if (isCdDriveCache.containsKey(absolutePath)) {
            isCdDrive = isCdDriveCache.get(absolutePath);
        } else if (file.exists()) {
            if (file.getParent() == null) {
                String sysDes = FileUtils.getFileTypeDescription(file);
                String description = TextUtils.notEmpty(sysDes) ? sysDes.toLowerCase(Locale.ROOT) : file.getName();
                isCdDrive = description.contains("cd") || description.contains("dvd") || description.contains("blu-ray") || description.contains("bluray");
            } else {
                isCdDrive = false;
            }
            isCdDriveCache.put(absolutePath, isCdDrive);
        } else {
            isCdDrive = false;
        }
        return isCdDrive;
    }

    public static void clearIsFileCache() {
        isFileCache.clear();
    }

    public static void clearIsFileCache(@NotNull String absolutePath) {
        isFileCache.remove(absolutePath);
    }

    public static boolean isFile(@Nullable File file) {
        boolean isFile = false;
        if (file != null) {
            String absolutePath = file.getAbsolutePath();
            if (isFileCache.containsKey(absolutePath)) {
                isFile = isFileCache.get(absolutePath);
            } else if (file.exists()) {
                isFile = file.isFile();
                isFileCache.put(absolutePath, isFile);
            }
        }
        return isFile;
    }

    public static void clearIsDirectoryCache() {
        isDirectoryCache.clear();
    }

    public static void clearIsDirectoryCache(@NotNull String absolutePath) {
        isDirectoryCache.remove(absolutePath);
    }

    public static boolean isDirectory(@Nullable File file) {
        boolean isDirectory = false;
        if (file != null) {
            String absolutePath = file.getAbsolutePath();
            if (isDirectoryCache.containsKey(absolutePath)) {
                isDirectory = isDirectoryCache.get(absolutePath);
            } else if (file.exists()) {
                isDirectory = file.isDirectory();
                isDirectoryCache.put(absolutePath, isDirectory);
            }
        }
        return isDirectory;
    }

    public static void clearIsHiddenCache() {
        isHiddenCache.clear();
    }

    public static void clearIsHiddenCache(@NotNull String absolutePath) {
        isHiddenCache.remove(absolutePath);
    }

    public static boolean isHidden(@Nullable File file) {
        boolean isHidden = false;
        if (file != null) {
            String absolutePath = file.getAbsolutePath();
            if (isHiddenCache.containsKey(absolutePath)) {
                isHidden = isHiddenCache.get(absolutePath);
            } else if (file.exists()) {
                File absoluteFile = file.getAbsoluteFile();
                isHidden = FileUtils.getParent(absoluteFile) != null && absoluteFile.isHidden();
                isHiddenCache.put(absolutePath, isHidden);
            }
        }
        return isHidden;
    }

    public static void clearFileDescriptionCache() {
        fileDescriptionCache.clear();
    }

    public static void clearFileDescriptionCache(@NotNull String absolutePath) {
        fileDescriptionCache.remove(absolutePath);
    }

    public static FileDescription getFileDescription(@NotNull File file, @Nullable String fileSize) {
        FileDescription fileDescription;
        String absolutePath = file.getAbsolutePath();
        if (fileDescriptionCache.containsKey(absolutePath)) {
            fileDescription = fileDescriptionCache.get(absolutePath);
        } else if (file.exists()) {
            fileDescription = FileUtils.createFileDescription(file, fileSize);
            fileDescriptionCache.put(absolutePath, fileDescription);
        } else {
            fileDescription = new FileDescription("Unknown", "0", "", null);
        }
        return fileDescription;
    }

    @NotNull
    public static String appropriateFileName(@NotNull String text) {
        return FileUtils.appropriateFileName(text, "");
    }

    @NotNull
    public static String appropriateFileName(@NotNull String text, @NotNull String replacement) {
        return text.replaceAll("[^ a-zA-Z\u0430-\u044f\u0410-\u042f0-9.-]", replacement);
    }

    public static void clearDisplayFileNameCache() {
        displayFileNameCache.clear();
    }

    public static void clearDisplayFileNameCache(@NotNull String absolutePath) {
        displayFileNameCache.remove(absolutePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String getDisplayFileName(@NotNull File file) {
        String name;
        String absolutePath = file.getAbsolutePath();
        if (displayFileNameCache.containsKey(absolutePath)) {
            name = displayFileNameCache.get(absolutePath);
        } else if (file.exists()) {
            FileSystemView fileSystemView = fsv;
            synchronized (fileSystemView) {
                name = fsv.getSystemDisplayName(file);
            }
            if (TextUtils.isBlank(name)) {
                name = FileUtils.getFileTypeDescription(file);
            }
            displayFileNameCache.put(absolutePath, name);
        } else if (!file.exists()) {
            displayFileNameCache.put(absolutePath, file.getName());
            name = file.getName();
        } else {
            name = file.getName();
        }
        return name;
    }

    public static void clearDisplayFileCreationDateCache() {
        displayFileCreationDateCache.clear();
    }

    public static void clearDisplayFileCreationDateCache(@NotNull String absolutePath) {
        displayFileCreationDateCache.remove(absolutePath);
    }

    @NotNull
    public static String getDisplayFileCreationDate(@NotNull File file) {
        String date;
        String absolutePath = file.getAbsolutePath();
        if (displayFileCreationDateCache.containsKey(absolutePath)) {
            date = displayFileCreationDateCache.get(absolutePath);
        } else if (file.exists()) {
            date = sdf.format(new Date(file.lastModified()));
            displayFileCreationDateCache.put(absolutePath, date);
        } else {
            date = "";
        }
        return date;
    }

    public static void clearDisplayFileModificationDateCache() {
        displayFileModificationDateCache.clear();
    }

    public static void clearDisplayFileModificationDateCache(@NotNull String absolutePath) {
        displayFileModificationDateCache.remove(absolutePath);
    }

    @NotNull
    public static String getDisplayFileModificationDate(@NotNull File file) {
        String date;
        String absolutePath = file.getAbsolutePath();
        if (displayFileModificationDateCache.containsKey(absolutePath)) {
            date = displayFileModificationDateCache.get(absolutePath);
        } else if (file.exists()) {
            date = sdf.format(new Date(file.lastModified()));
            displayFileModificationDateCache.put(absolutePath, date);
        } else {
            date = "";
        }
        return date;
    }

    public static void clearFileTypeDescriptionCache() {
        fileTypeDescriptionCache.clear();
    }

    public static void clearFileTypeDescriptionCache(@NotNull String absolutePath) {
        fileTypeDescriptionCache.remove(absolutePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String getFileTypeDescription(@Nullable File file) {
        String description = "";
        if (file != null) {
            String absolutePath = file.getAbsolutePath();
            if (fileTypeDescriptionCache.containsKey(absolutePath)) {
                description = fileTypeDescriptionCache.get(absolutePath);
            } else if (file.exists()) {
                FileSystemView fileSystemView = fsv;
                synchronized (fileSystemView) {
                    description = fsv.getSystemTypeDescription(file);
                }
                if (description == null) {
                    description = "";
                }
                fileTypeDescriptionCache.put(absolutePath, absolutePath);
            }
        }
        return description;
    }

    @Nullable
    public static Icon getFileIcon(@Nullable File file) {
        return FileUtils.getFileIcon(file, false);
    }

    @Nullable
    public static Icon getFileIcon(@Nullable File file, boolean large) {
        return FileUtils.getStandardFileIcon(file, large);
    }

    @Nullable
    public static Icon getStandardFileIcon(@Nullable File file, boolean large) {
        return FileUtils.getStandardFileIcon(file, large, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Icon getStandardFileIcon(@Nullable File file, boolean large, boolean enabled) {
        Icon icon = null;
        if (file != null) {
            boolean contains;
            String extension2;
            if (!FileUtils.isDirectory(file)) {
                extension2 = FileUtils.getFileExtPart(file.getName(), false).trim().toLowerCase(Locale.ROOT);
                if (extension2.trim().equals("")) {
                    extension2 = file.getAbsolutePath();
                }
            } else {
                extension2 = FileUtils.isCdDrive(file) ? "cd_drive" : (FileUtils.isDrive(file) ? "drive" : (FileUtils.isComputer(file) ? "computer" : "folder"));
            }
            float opacity = FileUtils.isHidden(file) ? 0.5f : 1.0f;
            String key = FileUtils.getStandardFileIconCacheKey(extension2, large, opacity, enabled);
            Object object = extensionIconsCacheLock;
            synchronized (object) {
                contains = extensionIconsCache.containsKey(key);
            }
            if (contains) {
                object = extensionIconsCacheLock;
                synchronized (object) {
                    icon = extensionIconsCache.get(key);
                }
            }
            icon = FileUtils.getStandardFileIcon(large, extension2, opacity);
            if (icon == null) {
                icon = FileUtils.getStandardFileIcon(large, "file", opacity);
            }
            if (enabled) {
                if (icon != null) {
                    object = extensionIconsCacheLock;
                    synchronized (object) {
                        extensionIconsCache.put(key, icon);
                    }
                }
            } else {
                Object object2;
                String keyEnabled = FileUtils.getStandardFileIconCacheKey(extension2, large, opacity, true);
                if (icon != null) {
                    object2 = extensionIconsCacheLock;
                    synchronized (object2) {
                        extensionIconsCache.put(keyEnabled, icon);
                    }
                }
                if (icon != null) {
                    icon = ImageUtils.getDisabledCopy(icon);
                    object2 = extensionIconsCacheLock;
                    synchronized (object2) {
                        extensionIconsCache.put(key, icon);
                    }
                }
            }
        }
        return icon;
    }

    @NotNull
    private static String getStandardFileIconCacheKey(@NotNull String extension2, boolean large, float opacity, boolean enabled) {
        return extension2 + CACHE_KEYS_SEPARATOR + large + CACHE_KEYS_SEPARATOR + opacity + CACHE_KEYS_SEPARATOR + enabled;
    }

    @Nullable
    public static Icon getStandardFileIcon(boolean large, @NotNull String extension2, float opacity) {
        String path = "icons/extensions/" + (large ? "32" : "16") + "/file_extension_" + extension2 + ".png";
        return FileUtils.getIconResource(FileUtils.class, path, opacity);
    }

    @Nullable
    public static Icon getIconResource(@NotNull Class nearClass, @NotNull String resource) {
        return FileUtils.getIconResource(nearClass, resource, 1.0f);
    }

    @Nullable
    public static Icon getIconResource(@NotNull Class nearClass, @NotNull String resource, float opacity) {
        Icon icon;
        String key = nearClass.getCanonicalName() + CACHE_KEYS_SEPARATOR + resource + CACHE_KEYS_SEPARATOR + opacity;
        if (resourceIconsCache.containsKey(key)) {
            icon = resourceIconsCache.get(key);
        } else {
            URL url2 = nearClass.getResource(resource);
            if (url2 != null) {
                icon = new ImageIcon(url2);
                if (opacity < 1.0f) {
                    icon = ImageUtils.createTransparentCopy(icon, opacity);
                }
            } else {
                icon = null;
            }
            if (icon != null) {
                resourceIconsCache.put(key, icon);
            }
        }
        return icon;
    }

    @NotNull
    public static WebTimer trackFile(@NotNull File file, @NotNull SystemFileListener listener) {
        return FileUtils.trackFile(file, listener, 5000L);
    }

    @NotNull
    public static WebTimer trackFile(final @NotNull File file, final @NotNull SystemFileListener listener, long delay) {
        final WebTimer tracker = new WebTimer("File tracker - " + file.getName(), delay, 0L);
        tracker.addActionListener(new ActionListener(){
            private Long lastModified = null;

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (file.exists()) {
                    long lm = file.lastModified();
                    if (this.lastModified != lm) {
                        listener.modified(file);
                        this.lastModified = lm;
                    }
                } else {
                    listener.unbound(file);
                    tracker.stop();
                }
            }
        });
        tracker.setUseDaemonThread(true);
        return tracker;
    }
}

