/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.shape;

import com.alee.api.annotations.NotNull;
import com.alee.painter.decoration.shape.Round;
import com.alee.utils.xml.XmlException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.util.StringTokenizer;

public final class RoundConverter
extends AbstractSingleValueConverter {
    public static final String separator = ",";

    @Override
    public boolean canConvert(@NotNull Class type) {
        return Round.class.isAssignableFrom(type);
    }

    @Override
    @NotNull
    public String toString(@NotNull Object object) {
        return RoundConverter.roundToString((Round)object);
    }

    @Override
    @NotNull
    public Object fromString(@NotNull String round) {
        return RoundConverter.roundFromString(round);
    }

    @NotNull
    public static String roundToString(@NotNull Round round) {
        String string = round.topLeft == round.topRight && round.bottomLeft == round.bottomRight && round.topLeft == round.bottomLeft ? Integer.toString(round.topLeft) : (round.topLeft == round.bottomRight && round.topRight == round.bottomLeft ? round.topLeft + separator + round.topRight : (round.topRight == round.bottomLeft ? round.topLeft + separator + round.topRight + separator + round.bottomRight : round.topLeft + separator + round.topRight + separator + round.bottomRight + separator + round.bottomLeft));
        return string;
    }

    @NotNull
    public static Round roundFromString(@NotNull String string) {
        try {
            Round round;
            StringTokenizer tokenizer = new StringTokenizer(string, separator, false);
            if (tokenizer.hasMoreTokens()) {
                int topLeft = Integer.parseInt(tokenizer.nextToken().trim());
                if (tokenizer.hasMoreTokens()) {
                    int topRight = Integer.parseInt(tokenizer.nextToken().trim());
                    if (tokenizer.hasMoreTokens()) {
                        int bottomRight = Integer.parseInt(tokenizer.nextToken().trim());
                        if (tokenizer.hasMoreTokens()) {
                            int bottomLeft = Integer.parseInt(tokenizer.nextToken().trim());
                            round = new Round(topLeft, topRight, bottomRight, bottomLeft);
                        } else {
                            round = new Round(topLeft, topRight, bottomRight, topRight);
                        }
                    } else {
                        round = new Round(topLeft, topRight, topLeft, topRight);
                    }
                } else {
                    round = new Round(topLeft, topLeft, topLeft, topLeft);
                }
            } else {
                round = new Round();
            }
            return round;
        }
        catch (Exception e) {
            throw new XmlException("Unable to parse Round: " + string, e);
        }
    }
}

