/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.content;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;

public enum TextRasterization {
    none(0),
    basic(1),
    subpixel(2);

    @Nullable
    private Map renderingHints;

    private TextRasterization(int type) {
        if (type == 0) {
            this.setupHints(new RenderingHints(new HashMap(0)));
        } else if (type == 1) {
            this.setupHints(this.getDefaultHints());
        } else if (type == 2) {
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                String hintsProperty = "awt.font.desktophints";
                this.setupHints((RenderingHints)toolkit.getDesktopProperty("awt.font.desktophints"));
                toolkit.addPropertyChangeListener("awt.font.desktophints", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getNewValue() instanceof RenderingHints) {
                            TextRasterization.this.setupHints((RenderingHints)evt.getNewValue());
                        }
                    }
                });
            }
            catch (Exception e) {
                this.setupHints(this.getDefaultHints());
            }
        }
    }

    private void setupHints(@Nullable Map hints) {
        this.renderingHints = hints != null ? hints : this.getDefaultHints();
    }

    @NotNull
    private Map getDefaultHints() {
        return new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    @Nullable
    public Map getRenderingHints() {
        return this.renderingHints;
    }
}

