/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.border;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.border.AbstractBorder;
import com.alee.painter.decoration.border.BorderWidth;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.JComponent;

@XStreamAlias(value="LineBorder")
public class LineBorder<C extends JComponent, D extends IDecoration<C, D>, I extends LineBorder<C, D, I>>
extends AbstractBorder<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected Stroke stroke;
    @XStreamAsAttribute
    @Nullable
    protected Color color;

    @Nullable
    public Stroke getStroke() {
        return this.stroke;
    }

    @Nullable
    public Color getColor() {
        return this.color;
    }

    @Override
    @NotNull
    public BorderWidth getWidth() {
        float opacity = this.getOpacity();
        Stroke stroke = this.getStroke();
        float lineWidth = opacity > 0.0f ? (stroke instanceof BasicStroke ? ((BasicStroke)stroke).getLineWidth() : 1.0f) : 0.0f;
        int width = Math.round(lineWidth);
        return new BorderWidth(width, width, width, width);
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d, @NotNull Shape shape) {
        Color color;
        float opacity = this.getOpacity();
        if (opacity > 0.0f && !this.getWidth().isEmpty() && (color = this.getColor()) != null) {
            Stroke stroke = this.getStroke();
            Composite oc = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(opacity), opacity < 1.0f);
            Stroke os = GraphicsUtils.setupStroke(g2d, stroke, stroke != null);
            Paint op = GraphicsUtils.setupPaint(g2d, color);
            g2d.draw(shape);
            GraphicsUtils.restorePaint(g2d, op);
            GraphicsUtils.restoreStroke(g2d, os, stroke != null);
            GraphicsUtils.restoreComposite(g2d, oc, opacity < 1.0f);
        }
    }
}

