/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.background;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.merge.behavior.OverwriteOnMerge;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractBackground;
import com.alee.painter.decoration.background.GradientColor;
import com.alee.painter.decoration.background.GradientType;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JComponent;

@XStreamAlias(value="GradientBackground")
public class GradientBackground<C extends JComponent, D extends IDecoration<C, D>, I extends GradientBackground<C, D, I>>
extends AbstractBackground<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected GradientType type;
    @XStreamAsAttribute
    @Nullable
    protected Point2D.Float from;
    @XStreamAsAttribute
    @Nullable
    protected Point2D.Float to;
    @XStreamImplicit(itemFieldName="color")
    @OverwriteOnMerge
    @Nullable
    protected List<GradientColor> colors;

    @NotNull
    protected GradientType getType(@NotNull C c, @NotNull D d) {
        return this.type != null ? this.type : GradientType.linear;
    }

    @NotNull
    protected Point2D.Float getFrom(@NotNull C c, @NotNull D d) {
        return this.from != null ? this.from : new Point2D.Float(0.0f, 0.0f);
    }

    @NotNull
    protected Point2D.Float getTo(@NotNull C c, @NotNull D d) {
        return this.to != null ? this.to : new Point2D.Float(0.0f, 1.0f);
    }

    @Nullable
    public List<GradientColor> getColors(@NotNull C c, @NotNull D d) {
        return this.colors;
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d, @NotNull Shape shape) {
        List<GradientColor> colors;
        float opacity = this.getOpacity(c, d);
        if (opacity > 0.0f && (colors = this.getColors(c, d)) != null) {
            Composite oc = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(opacity), opacity < 1.0f);
            Rectangle b = shape.getBounds();
            Point2D.Float from = this.getFrom(c, d);
            Point2D.Float to = this.getTo(c, d);
            int x1 = (int)Math.round((double)b.x + (double)b.width * from.getX());
            int y1 = (int)Math.round((double)b.y + (double)b.height * from.getY());
            int x2 = (int)Math.round((double)b.x + (double)b.width * to.getX());
            int y2 = (int)Math.round((double)b.y + (double)b.height * to.getY());
            Paint paint = DecorationUtils.getPaint(this.getType(c, d), colors, x1, y1, x2, y2);
            Paint op = GraphicsUtils.setupPaint(g2d, paint);
            g2d.fill(shape);
            GraphicsUtils.restorePaint(g2d, op);
            GraphicsUtils.restoreComposite(g2d, oc, opacity < 1.0f);
        }
    }
}

