/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.background;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.behavior.OmitOnClone;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractTextureBackground;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public abstract class AbstractImageTextureBackground<C extends JComponent, D extends IDecoration<C, D>, I extends AbstractImageTextureBackground<C, D, I>>
extends AbstractTextureBackground<C, D, I> {
    @OmitOnClone
    @OmitOnMerge
    @Nullable
    protected transient BufferedImage image;

    @Override
    @NotNull
    protected TexturePaint createTexturePaint(@NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        if (this.image == null) {
            this.image = this.createTextureImage(c, d);
        }
        return new TexturePaint(this.image, new Rectangle(bounds.x, bounds.y, this.image.getWidth(), this.image.getHeight()));
    }

    @NotNull
    protected abstract BufferedImage createTextureImage(@NotNull C var1, @NotNull D var2);
}

