/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration;

import com.alee.api.annotations.NotNull;
import com.alee.painter.Painter;
import com.alee.painter.PainterException;
import com.alee.painter.SectionPainter;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.IDecorationPainter;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public abstract class AbstractSectionDecorationPainter<C extends JComponent, U extends ComponentUI, D extends IDecoration<C, D>>
extends AbstractDecorationPainter<C, U, D>
implements SectionPainter<C, U> {
    protected transient WeakReference<Painter<C, U>> origin;

    @Override
    public void install(C c, U ui, Painter<C, U> origin) {
        this.origin = new WeakReference<Painter<C, U>>(origin);
        super.install(c, ui);
    }

    @Override
    public void uninstall(C c, U ui, Painter<C, U> origin) {
        super.uninstall(c, ui);
        this.origin = null;
    }

    @Override
    public Painter<C, U> getOrigin() {
        if (this.origin == null) {
            throw new PainterException("Origin Painter was not specified for painter: " + this);
        }
        Painter originPainter = (Painter)this.origin.get();
        if (originPainter == null) {
            throw new PainterException("Origin Painter was destroyed before its SectionPainter: " + this);
        }
        return originPainter;
    }

    @Override
    protected boolean usesContainerView() {
        return false;
    }

    @Override
    protected boolean usesFocusedView() {
        return false;
    }

    @Override
    protected boolean usesInFocusedParentView() {
        return false;
    }

    @Override
    protected boolean usesHoverView() {
        return false;
    }

    @Override
    protected boolean usesInHoveredParentView() {
        return false;
    }

    @Override
    protected boolean usesHierarchyBasedView() {
        return false;
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        List<String> states;
        Painter<C, U> origin = this.getOrigin();
        if (origin != null && origin instanceof IDecorationPainter) {
            IDecorationPainter painter = (IDecorationPainter)origin;
            states = painter.getDecorationStates();
        } else {
            states = super.getDecorationStates();
        }
        return states;
    }

    @Override
    protected boolean isPlainBackgroundRequired(@NotNull C c) {
        return false;
    }
}

