/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.merge.behavior.OverwriteOnMerge;
import com.alee.managers.style.Bounds;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.swing.CursorType;
import com.alee.utils.xml.ListToStringConverter;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;

public abstract class AbstractDecoration<C extends JComponent, I extends AbstractDecoration<C, I>>
implements IDecoration<C, I> {
    public static final String defaultStateId = "default";
    @XStreamAsAttribute
    @XStreamConverter(value=ListToStringConverter.class)
    @OverwriteOnMerge
    protected List<String> states;
    @XStreamAsAttribute
    protected Boolean overwrite;
    @XStreamAsAttribute
    protected Boolean visible;
    @XStreamAsAttribute
    protected Dimension size;
    @XStreamAsAttribute
    protected Float opacity;
    @XStreamAsAttribute
    protected CursorType cursor;
    protected transient Boolean section;
    protected transient Cursor previousCursor;

    @Override
    @Nullable
    public String getId() {
        return this.states != null ? TextUtils.listToString(this.states, ",") : defaultStateId;
    }

    @Override
    public void activate(C c) {
        Cursor customCursor = this.getCursor();
        if (customCursor != null) {
            this.previousCursor = ((Component)c).getCursor();
            ((Component)c).setCursor(customCursor);
        }
    }

    @Override
    public void deactivate(C c) {
        Cursor customCursor = this.getCursor();
        if (customCursor != null) {
            ((Component)c).setCursor(this.previousCursor);
            this.previousCursor = null;
        }
    }

    @Override
    public List<String> getStates() {
        return this.states;
    }

    @Override
    public boolean usesState(String state) {
        return this.states != null && this.states.contains(state);
    }

    @Override
    public boolean isApplicableTo(@NotNull List<String> states) {
        boolean applicable = true;
        if (!CollectionUtils.isEmpty(this.states)) {
            if (CollectionUtils.isEmpty(states)) {
                applicable = false;
            } else {
                for (String state : this.states) {
                    if (states.contains(state)) continue;
                    applicable = false;
                    break;
                }
            }
        }
        return applicable;
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite != null && this.overwrite != false;
    }

    @Override
    public boolean isVisible() {
        return this.visible == null || this.visible != false;
    }

    @Override
    public boolean isSection() {
        return this.section != null && this.section != false;
    }

    @Override
    public void setSection(boolean section) {
        this.section = section;
    }

    public float getOpacity() {
        return this.opacity != null ? this.opacity.floatValue() : 1.0f;
    }

    public Cursor getCursor() {
        return this.cursor != null ? this.cursor.getCursor() : null;
    }

    @Override
    public Insets getBorderInsets(C c) {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public boolean contains(C c, Bounds bounds, int x, int y) {
        return bounds.get().contains(x, y);
    }

    @Override
    public int getBaseline(C c, Bounds bounds) {
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(C c) {
        return Component.BaselineResizeBehavior.OTHER;
    }

    @Override
    public Dimension getPreferredSize(C c) {
        return this.size;
    }

    public String toString() {
        return ReflectUtils.getClassName(this) + " [ id=" + this.getId() + "; visible=" + this.isVisible() + " ]";
    }
}

