/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.common;

import com.alee.api.annotations.NotNull;
import com.alee.managers.style.Bounds;
import com.alee.painter.AbstractPainter;
import com.alee.utils.GraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class BorderPainter<C extends JComponent, U extends ComponentUI>
extends AbstractPainter<C, U> {
    protected Integer round;
    protected Stroke stroke;
    protected Color color;

    public BorderPainter() {
    }

    public BorderPainter(Color color) {
        this.color = color;
    }

    public int getRound() {
        return this.round != null ? this.round : 0;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    protected int getStrokeWidth() {
        Stroke stroke = this.getStroke();
        return stroke != null && stroke instanceof BasicStroke ? Math.round(((BasicStroke)stroke).getLineWidth()) : 1;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    @NotNull
    protected Insets getBorder() {
        int width = this.getStrokeWidth();
        return new Insets(width, width, width, width);
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Bounds bounds) {
        Object aa = GraphicsUtils.setupAntialias(g2d);
        Stroke os = GraphicsUtils.setupStroke(g2d, this.stroke, this.stroke != null);
        g2d.setPaint(this.color);
        g2d.draw(this.getBorderShape(bounds.get()));
        GraphicsUtils.restoreStroke(g2d, os, this.stroke != null);
        GraphicsUtils.restoreAntialias(g2d, aa);
    }

    protected RectangularShape getBorderShape(Rectangle bounds) {
        int round = this.getRound();
        int width = this.getStrokeWidth();
        double shear = width == 1 ? 0.0 : (double)width / 2.0;
        RectangularShape shape = round > 0 ? new RoundRectangle2D.Double((double)bounds.x + shear, (double)bounds.y + shear, (double)bounds.width - shear * 2.0 - 1.0, (double)bounds.height - shear * 2.0 - 1.0, round * 2, round * 2) : new Rectangle2D.Double((double)bounds.x + shear, (double)bounds.y + shear, (double)bounds.width - shear * 2.0 - 1.0, (double)bounds.height - shear * 2.0 - 1.0);
        return shape;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        int width = this.getStrokeWidth();
        return new Dimension(Math.max(width * 2, this.round * 2), Math.max(width * 2, this.round * 2));
    }
}

