/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.data;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.merge.Merge;
import com.alee.api.resource.ClassResource;
import com.alee.api.resource.Resource;
import com.alee.managers.icon.set.IconSet;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.data.ComponentStyle;
import com.alee.managers.style.data.SkinInfo;
import com.alee.utils.ReflectUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.xml.XStreamContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public final class SkinInfoConverter
extends ReflectionConverter {
    public static final String SKIN_CLASS = "skin.class";
    public static final String META_DATA_ONLY_KEY = "meta.data.only";
    public static final String ID_NODE = "id";
    public static final String CLASS_NODE = "class";
    public static final String SUPPORTED_SYSTEMS_NODE = "supportedSystems";
    public static final String ICON_NODE = "icon";
    public static final String TITLE_NODE = "title";
    public static final String DESCRIPTION_NODE = "description";
    public static final String AUTHOR_NODE = "author";
    public static final String EXTENDS_NODE = "extends";
    public static final String INCLUDE_NODE = "include";
    public static final String ICON_SET_NODE = "iconSet";
    public static final String STYLE_NODE = "style";
    public static final String NEAR_CLASS_ATTRIBUTE = "nearClass";
    protected static final Map<String, Map<String, String>> resourceMap = new LinkedHashMap<String, Map<String, String>>();

    public SkinInfoConverter(@NotNull Mapper mapper, @NotNull ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public static void addCustomResource(@NotNull String nearClass, @NotNull String src, @NotNull String xml) {
        Map<String, String> nearClassMap = resourceMap.get(nearClass);
        if (nearClassMap == null) {
            nearClassMap = new LinkedHashMap<String, String>();
            resourceMap.put(nearClass, nearClassMap);
        }
        nearClassMap.put(src, xml);
    }

    @Override
    public boolean canConvert(@NotNull Class type) {
        return type.equals(SkinInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Object unmarshal(@NotNull HierarchicalStreamReader reader, @NotNull UnmarshallingContext context) {
        String superSkinClass = (String)context.get(SKIN_CLASS);
        try {
            SkinInfo skinInfo = new SkinInfo();
            skinInfo.setSkinClass(superSkinClass);
            Object mdo = context.get(META_DATA_ONLY_KEY);
            boolean metaDataOnly = mdo != null && (Boolean)mdo != false;
            List<IconSet> iconSets = new ArrayList<IconSet>(1);
            ArrayList<ComponentStyle> styles = new ArrayList<ComponentStyle>(10);
            while (reader.hasMoreChildren()) {
                Object skinClass;
                reader.moveDown();
                String nodeName = reader.getNodeName();
                if (nodeName.equals(ID_NODE)) {
                    skinInfo.setId(reader.getValue());
                } else if (nodeName.equals(CLASS_NODE)) {
                    skinClass = reader.getValue();
                    this.getSkinClass((String)skinClass);
                    skinInfo.setSkinClass((String)skinClass);
                    context.put(SKIN_CLASS, skinClass);
                } else if (nodeName.equals(SUPPORTED_SYSTEMS_NODE)) {
                    skinInfo.setSupportedSystems(reader.getValue());
                } else if (nodeName.equals(ICON_NODE)) {
                    skinClass = this.getSkinClass(skinInfo.getSkinClass());
                    skinInfo.setIcon(new ImageIcon(((Class)skinClass).getResource(reader.getValue())));
                } else if (nodeName.equals(TITLE_NODE)) {
                    skinInfo.setTitle(reader.getValue());
                } else if (nodeName.equals(DESCRIPTION_NODE)) {
                    skinInfo.setDescription(reader.getValue());
                } else if (nodeName.equals(AUTHOR_NODE)) {
                    skinInfo.setAuthor(reader.getValue());
                } else if (nodeName.equals(EXTENDS_NODE)) {
                    List<String> extendedSkins = skinInfo.getExtendedSkins();
                    if (extendedSkins == null) {
                        extendedSkins = new ArrayList<String>(1);
                        skinInfo.setExtendedSkins(extendedSkins);
                    }
                    extendedSkins.add(reader.getValue());
                } else if (nodeName.equals(ICON_SET_NODE) && !metaDataOnly) {
                    String className = reader.getValue();
                    Class realClass = this.mapper.realClass(className);
                    IconSet iconSet = this.readIconSet(realClass);
                    iconSets.add(iconSet);
                } else if (nodeName.equals(STYLE_NODE) && !metaDataOnly) {
                    ComponentStyle style = (ComponentStyle)context.convertAnother(styles, ComponentStyle.class);
                    styles.add(style);
                } else if (nodeName.equals(INCLUDE_NODE) && !metaDataOnly) {
                    String nearClass = reader.getAttribute(NEAR_CLASS_ATTRIBUTE);
                    String path = reader.getValue();
                    SkinInfo include = this.readInclude(skinInfo, nearClass, path);
                    iconSets = (List)Merge.basicRaw().nonNullMerge(iconSets, include.getIconSets());
                    styles.addAll(include.getStyles());
                }
                reader.moveUp();
            }
            skinInfo.setIconSets(iconSets);
            skinInfo.setStyles(styles);
            SkinInfo skinInfo2 = skinInfo;
            return skinInfo2;
        }
        finally {
            context.put(SKIN_CLASS, superSkinClass);
        }
    }

    @NotNull
    private Class<? extends Skin> getSkinClass(@NotNull String skinClass) {
        try {
            return ReflectUtils.getClass(skinClass);
        }
        catch (ClassNotFoundException e) {
            throw new StyleException("Unable to find skin class: " + skinClass, e);
        }
    }

    @NotNull
    private SkinInfo readInclude(@NotNull SkinInfo parent, @Nullable String nearClass, @NotNull String path) {
        ClassResource resource = nearClass != null ? new ClassResource(this.mapper.realClass(nearClass), path) : new ClassResource(parent.getSkinClass(), path);
        return this.loadSkinInfo(parent, resource);
    }

    @NotNull
    private SkinInfo loadSkinInfo(@NotNull SkinInfo parent, @NotNull ClassResource resource) {
        try {
            String xml;
            XStreamContext context = new XStreamContext(SKIN_CLASS, parent.getSkinClass());
            Map<String, String> nearClassMap = resourceMap.get(resource.getClassName());
            SkinInfo skinInfo = nearClassMap != null ? ((xml = nearClassMap.get(resource.getPath())) != null ? (SkinInfo)XmlUtils.fromXML(xml, context) : (SkinInfo)XmlUtils.fromXML((Resource)resource, context)) : (SkinInfo)XmlUtils.fromXML((Resource)resource, context);
            return skinInfo;
        }
        catch (Exception e) {
            String msg = "Included skin file '%s' cannot be read";
            throw new StyleException(String.format("Included skin file '%s' cannot be read", resource.getPath()), e);
        }
    }

    @NotNull
    private IconSet readIconSet(@NotNull Class<? extends IconSet> className) {
        try {
            return (IconSet)ReflectUtils.createInstance(className, new Object[0]);
        }
        catch (Exception e) {
            String msg = "Unable to load icon set '%s'";
            throw new StyleException(String.format("Unable to load icon set '%s'", className), e);
        }
    }
}

