/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings;

import com.alee.api.jdk.BiConsumer;
import com.alee.extended.accordion.AccordionPaneState;
import com.alee.extended.accordion.AccordionSettingsProcessor;
import com.alee.extended.accordion.AccordionState;
import com.alee.extended.accordion.WebAccordion;
import com.alee.extended.collapsible.CollapsiblePaneSettingsProcessor;
import com.alee.extended.collapsible.CollapsiblePaneState;
import com.alee.extended.collapsible.WebCollapsiblePane;
import com.alee.extended.colorchooser.GradientColorChooserSettingsProcessor;
import com.alee.extended.colorchooser.GradientColorChooserState;
import com.alee.extended.colorchooser.GradientColorData;
import com.alee.extended.colorchooser.GradientData;
import com.alee.extended.colorchooser.WebGradientColorChooser;
import com.alee.extended.date.DateFieldSettingsProcessor;
import com.alee.extended.date.DateFieldState;
import com.alee.extended.date.WebDateField;
import com.alee.extended.dock.DockablePaneSettingsProcessor;
import com.alee.extended.dock.DockablePaneState;
import com.alee.extended.dock.WebDockablePane;
import com.alee.extended.dock.data.AbstractDockableElement;
import com.alee.extended.dock.data.DockableContentElement;
import com.alee.extended.dock.data.DockableFrameElement;
import com.alee.extended.dock.data.DockableListContainer;
import com.alee.extended.split.MultiSplitPaneSettingsProcessor;
import com.alee.extended.split.MultiSplitState;
import com.alee.extended.split.WebMultiSplitPane;
import com.alee.extended.tab.DocumentPaneSettingsProcessor;
import com.alee.extended.tab.DocumentPaneState;
import com.alee.extended.tab.WebDocumentPane;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.ButtonSettingsProcessor;
import com.alee.laf.button.ButtonState;
import com.alee.laf.colorchooser.HSBColor;
import com.alee.laf.combobox.ComboBoxSettingsProcessor;
import com.alee.laf.combobox.ComboBoxState;
import com.alee.laf.rootpane.RootPaneSettingsProcessor;
import com.alee.laf.rootpane.WindowState;
import com.alee.laf.scroll.ScrollBarSettingsProcessor;
import com.alee.laf.scroll.ScrollBarState;
import com.alee.laf.scroll.ScrollPaneSettingsProcessor;
import com.alee.laf.scroll.ScrollPaneState;
import com.alee.laf.slider.SliderSettingsProcessor;
import com.alee.laf.slider.SliderState;
import com.alee.laf.splitpane.SplitPaneSettingsProcessor;
import com.alee.laf.splitpane.SplitPaneState;
import com.alee.laf.tabbedpane.TabbedPaneSettingsProcessor;
import com.alee.laf.tabbedpane.TabbedPaneState;
import com.alee.laf.text.PasswordFieldSettingsProcessor;
import com.alee.laf.text.PasswordFieldState;
import com.alee.laf.text.TextComponentSettingsProcessor;
import com.alee.laf.text.TextComponentState;
import com.alee.laf.text.TextFieldSettingsProcessor;
import com.alee.laf.tree.NodeState;
import com.alee.laf.tree.TreeSettingsProcessor;
import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.WebTree;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsException;
import com.alee.managers.settings.SettingsListener;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.utils.ReflectUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.swing.WeakComponentData;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public final class UISettingsManager {
    private static final Map<Class<? extends JComponent>, Class<? extends SettingsProcessor>> settingsProcessorClasses = new LinkedHashMap<Class<? extends JComponent>, Class<? extends SettingsProcessor>>();
    private static final WeakComponentData<JComponent, SettingsProcessor> settingsProcessors = new WeakComponentData("UISettingsManager.SettingsProcessor", 10);
    private static boolean initialized = false;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            SettingsManager.initialize();
            XmlUtils.processAnnotations(ButtonState.class);
            XmlUtils.processAnnotations(TextComponentState.class);
            XmlUtils.processAnnotations(PasswordFieldState.class);
            XmlUtils.processAnnotations(DateFieldState.class);
            XmlUtils.processAnnotations(ComboBoxState.class);
            XmlUtils.processAnnotations(SliderState.class);
            XmlUtils.processAnnotations(SplitPaneState.class);
            XmlUtils.processAnnotations(ScrollBarState.class);
            XmlUtils.processAnnotations(ScrollPaneState.class);
            XmlUtils.processAnnotations(WindowState.class);
            XmlUtils.processAnnotations(CollapsiblePaneState.class);
            XmlUtils.processAnnotations(AccordionState.class);
            XmlUtils.processAnnotations(AccordionPaneState.class);
            XmlUtils.processAnnotations(MultiSplitState.class);
            XmlUtils.processAnnotations(TabbedPaneState.class);
            XmlUtils.processAnnotations(DocumentPaneState.class);
            XmlUtils.processAnnotations(TreeState.class);
            XmlUtils.processAnnotations(NodeState.class);
            XmlUtils.processAnnotations(GradientColorChooserState.class);
            XmlUtils.processAnnotations(GradientData.class);
            XmlUtils.processAnnotations(GradientColorData.class);
            XmlUtils.processAnnotations(HSBColor.class);
            XmlUtils.processAnnotations(DockablePaneState.class);
            XmlUtils.processAnnotations(AbstractDockableElement.class);
            XmlUtils.processAnnotations(DockableContentElement.class);
            XmlUtils.processAnnotations(DockableFrameElement.class);
            XmlUtils.processAnnotations(DockableListContainer.class);
            UISettingsManager.registerSettingsProcessor(AbstractButton.class, ButtonSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(JComboBox.class, ComboBoxSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(JSlider.class, SliderSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(JPasswordField.class, PasswordFieldSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(JTextField.class, TextFieldSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(JTextComponent.class, TextComponentSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(JScrollBar.class, ScrollBarSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(JScrollPane.class, ScrollPaneSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(JSplitPane.class, SplitPaneSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(JTabbedPane.class, TabbedPaneSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(JRootPane.class, RootPaneSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(WebMultiSplitPane.class, MultiSplitPaneSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(WebDocumentPane.class, DocumentPaneSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(WebTree.class, TreeSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(WebDateField.class, DateFieldSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(WebCollapsiblePane.class, CollapsiblePaneSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(WebAccordion.class, AccordionSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(WebGradientColorChooser.class, GradientColorChooserSettingsProcessor.class);
            UISettingsManager.registerSettingsProcessor(WebDockablePane.class, DockablePaneSettingsProcessor.class);
            SettingsManager.addSettingsListener(new SettingsListener(){

                @Override
                public void settingsChanged(final String group, final String key, Object oldValue, Object newValue) {
                    settingsProcessors.forEach(new BiConsumer<JComponent, SettingsProcessor>(){

                        @Override
                        public void accept(JComponent component2, SettingsProcessor processor) {
                            Object configuration = processor.configuration();
                            if (((Configuration)configuration).isApplySettingsChanges() && group.equals(((Configuration)configuration).group()) && key.equals(((Configuration)configuration).key())) {
                                processor.load();
                            }
                        }
                    });
                }
            });
        }
    }

    public static boolean isComponentSupported(JComponent component2) {
        return UISettingsManager.isComponentSupported(component2.getClass());
    }

    public static boolean isComponentSupported(Class<? extends JComponent> componentType) {
        return UISettingsManager.findSuitableSettingsProcessorClass(componentType) != null;
    }

    public static Class<? extends SettingsProcessor> registerSettingsProcessor(Class<? extends JComponent> componentType, Class<? extends SettingsProcessor> settingsProcessor) {
        return settingsProcessorClasses.put(componentType, settingsProcessor);
    }

    public static void registerComponent(JComponent component2, Configuration data) {
        UISettingsManager.registerComponent(component2, UISettingsManager.createSettingsProcessor(component2, data));
    }

    public static void registerComponent(JComponent component2, SettingsProcessor processor) {
        WebLookAndFeel.checkEventDispatchThread();
        if (component2 != processor.component()) {
            throw new SettingsException("SettingsProcessor cannot be referencing different component");
        }
        settingsProcessors.set((JComponent)processor.component(), processor, new BiConsumer<JComponent, SettingsProcessor>(){

            @Override
            public void accept(JComponent component2, SettingsProcessor settingsProcessor) {
                settingsProcessor.destroy();
            }
        });
    }

    public static void unregisterComponent(JComponent component2) {
        WebLookAndFeel.checkEventDispatchThread();
        settingsProcessors.clear(component2, new BiConsumer<JComponent, SettingsProcessor>(){

            @Override
            public void accept(JComponent component2, SettingsProcessor settingsProcessor) {
                settingsProcessor.destroy();
            }
        });
    }

    public static void loadSettings(JComponent component2) {
        WebLookAndFeel.checkEventDispatchThread();
        if (!settingsProcessors.contains(component2)) {
            String msg = "Processor is not registered for component: %s";
            throw new SettingsException(String.format("Processor is not registered for component: %s", component2));
        }
        settingsProcessors.get(component2).load();
    }

    public static void saveSettings(JComponent component2) {
        WebLookAndFeel.checkEventDispatchThread();
        if (!settingsProcessors.contains(component2)) {
            String msg = "Processor is not registered for component: %s";
            throw new SettingsException(String.format("Processor is not registered for component: %s", component2));
        }
        settingsProcessors.get(component2).save(false);
    }

    public static void saveSettings() {
        WebLookAndFeel.checkEventDispatchThread();
        SettingsManager.saveSettings();
        settingsProcessors.forEach(new BiConsumer<JComponent, SettingsProcessor>(){

            @Override
            public void accept(JComponent component2, SettingsProcessor settingsProcessor) {
                UISettingsManager.saveSettings(component2);
            }
        });
    }

    private static Class<? extends SettingsProcessor> findSuitableSettingsProcessorClass(Class<? extends JComponent> componentType) {
        for (Class<? extends JComponent> type : settingsProcessorClasses.keySet()) {
            if (!ReflectUtils.isAssignable(type, componentType)) continue;
            return settingsProcessorClasses.get(type);
        }
        return null;
    }

    private static SettingsProcessor createSettingsProcessor(JComponent component2, Configuration configuration) {
        Class<? extends SettingsProcessor> settingsProcessorClass = UISettingsManager.findSuitableSettingsProcessorClass(component2.getClass());
        if (settingsProcessorClass != null) {
            try {
                return (SettingsProcessor)ReflectUtils.createInstance(settingsProcessorClass, component2, configuration);
            }
            catch (Exception e) {
                String msg = "Unable to instantiate SettingsProcessor class: %s";
                throw new SettingsException(String.format("Unable to instantiate SettingsProcessor class: %s", settingsProcessorClass), e);
            }
        }
        String msg = "Unable to find SettingsProcessor for data: %s";
        throw new SettingsException(String.format("Unable to find SettingsProcessor for data: %s", configuration));
    }
}

