/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.popup;

import com.alee.api.jdk.Supplier;
import com.alee.extended.window.Popup;
import com.alee.extended.window.PopupListener;
import com.alee.extended.window.PopupMethods;
import com.alee.extended.window.PopupMethodsImpl;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.popup.PopupLayer;
import com.alee.managers.popup.PopupManager;
import com.alee.managers.style.StyleId;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.FadeStateType;
import com.alee.utils.swing.NoOpMouseListener;
import com.alee.utils.swing.WebTimer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class WebInnerPopup
extends WebPanel
implements Popup,
PopupMethods {
    protected static final int fadeFps = 24;
    protected static final long fadeTime = 400L;
    protected boolean animated = false;
    protected boolean closeOnFocusLoss = false;
    protected boolean requestFocusOnShow = true;
    protected Component defaultFocusComponent = null;
    protected List<WeakReference<Component>> focusableChildren = new ArrayList<WeakReference<Component>>();
    protected Component lastComponent = null;
    protected ComponentListener lastComponentListener = null;
    protected AncestorListener lastAncestorListener = null;
    protected boolean focused = false;
    protected FadeStateType fadeStateType;
    protected float fade = 0.0f;
    protected WebTimer fadeTimer;
    protected DefaultFocusTracker focusTracker;

    public WebInnerPopup() {
        this(PopupManager.getDefaultPopupStyleId());
    }

    public WebInnerPopup(StyleId styleId) {
        super(styleId);
        this.initializePopup();
    }

    protected void initializePopup() {
        this.setFocusCycleRoot(true);
        NoOpMouseListener.install(this);
        this.fadeTimer = new WebTimer("WebPopup.fade", 41L);
        this.fadeTimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float roundsCount = 9.599999f;
                float fadeSpeed = 0.10416667f;
                if (WebInnerPopup.this.fadeStateType.equals((Object)FadeStateType.fadeIn)) {
                    if (WebInnerPopup.this.fade < 1.0f) {
                        WebInnerPopup.this.fade = Math.min(WebInnerPopup.this.fade + 0.10416667f, 1.0f);
                        WebInnerPopup.this.repaint();
                    } else {
                        WebInnerPopup.this.fadeTimer.stop();
                    }
                } else if (WebInnerPopup.this.fadeStateType.equals((Object)FadeStateType.fadeOut)) {
                    if (WebInnerPopup.this.fade > 0.0f) {
                        WebInnerPopup.this.fade = Math.max(WebInnerPopup.this.fade - 0.10416667f, 0.0f);
                        WebInnerPopup.this.repaint();
                    } else {
                        WebInnerPopup.this.hidePopupImpl();
                        WebInnerPopup.this.fadeTimer.stop();
                    }
                }
            }
        });
        this.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (WebInnerPopup.this.requestFocusOnShow) {
                    if (WebInnerPopup.this.defaultFocusComponent != null) {
                        WebInnerPopup.this.defaultFocusComponent.requestFocusInWindow();
                    } else {
                        WebInnerPopup.this.transferFocus();
                    }
                }
                if (WebInnerPopup.this.animated) {
                    WebInnerPopup.this.fade = 0.0f;
                    WebInnerPopup.this.fadeStateType = FadeStateType.fadeIn;
                    WebInnerPopup.this.fadeTimer.start();
                } else {
                    WebInnerPopup.this.fade = 1.0f;
                }
                WebInnerPopup.this.firePopupOpened();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                WebInnerPopup.this.firePopupClosed();
            }
        });
        this.focusTracker = new DefaultFocusTracker(this, true){

            @Override
            public void focusChanged(boolean focused) {
                WebInnerPopup.this.focusChanged(focused);
            }
        };
        FocusManager.addFocusTracker(this, this.focusTracker);
    }

    protected void focusChanged(boolean focused) {
        if (this.isShowing() && !focused && !this.isChildFocused() && this.closeOnFocusLoss) {
            this.hidePopup();
        }
    }

    public PopupLayer getPopupLayer() {
        return (PopupLayer)this.getParent();
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public boolean isCloseOnFocusLoss() {
        return this.closeOnFocusLoss;
    }

    public void setCloseOnFocusLoss(boolean closeOnFocusLoss) {
        this.closeOnFocusLoss = closeOnFocusLoss;
    }

    public boolean isRequestFocusOnShow() {
        return this.requestFocusOnShow;
    }

    public void setRequestFocusOnShow(boolean requestFocusOnShow) {
        this.requestFocusOnShow = requestFocusOnShow;
    }

    public Component getDefaultFocusComponent() {
        return this.defaultFocusComponent;
    }

    public void setDefaultFocusComponent(Component defaultFocusComponent) {
        this.defaultFocusComponent = defaultFocusComponent;
    }

    public List<Component> getFocusableChildren() {
        ArrayList<Component> actualFocusableChildren = new ArrayList<Component>(this.focusableChildren.size());
        for (WeakReference<Component> focusableChild : this.focusableChildren) {
            Component component2 = (Component)focusableChild.get();
            if (component2 == null) continue;
            actualFocusableChildren.add(component2);
        }
        return actualFocusableChildren;
    }

    public void addFocusableChild(Component child) {
        this.focusableChildren.add(new WeakReference<Component>(child));
    }

    public void removeFocusableChild(Component child) {
        this.focusableChildren.remove(child);
    }

    public boolean isChildFocused() {
        for (WeakReference<Component> focusableChild : this.focusableChildren) {
            Component component2 = (Component)focusableChild.get();
            if (component2 == null || !SwingUtils.hasFocusOwner(component2)) continue;
            return true;
        }
        return false;
    }

    public void showAsPopupMenu(final Component component2) {
        this.showPopup(component2, new Supplier<Rectangle>(){

            @Override
            public Rectangle get() {
                Rectangle cb = CoreSwingUtils.getBoundsInWindow(component2);
                Dimension rps = CoreSwingUtils.getNonNullRootPane(component2).getSize();
                Dimension ps = WebInnerPopup.this.getPreferredSize();
                Point p = new Point();
                p.x = cb.x + ps.width < rps.width || rps.width - cb.x - ps.width > cb.x ? 0 : cb.width - ps.width;
                p.y = cb.y + cb.height + ps.height < rps.height || rps.height - cb.y - cb.height - ps.height > cb.y ? cb.height : -ps.height;
                return new Rectangle(p, WebInnerPopup.this.getPreferredSize());
            }
        });
    }

    public void showPopup(Component component2) {
        PopupManager.showPopup(component2, this, this.requestFocusOnShow);
        this.clearLocationListeners();
    }

    public void showPopup(Component component2, Rectangle bounds) {
        this.showPopup(component2, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void showPopup(Component component2, int x, int y, int width, int height) {
        this.updatePopupBounds(component2, x, y, width, height);
        PopupManager.showPopup(component2, this, this.requestFocusOnShow);
        this.updateComponentAncestorListener(component2, x, y, width, height);
    }

    public void showPopup(Component component2, Point location) {
        this.showPopup(component2, location.x, location.y);
    }

    public void showPopup(Component component2, final int x, final int y) {
        this.showPopup(component2, new Supplier<Rectangle>(){

            @Override
            public Rectangle get() {
                Dimension ps = WebInnerPopup.this.getPreferredSize();
                return new Rectangle(x, y, ps.width, ps.height);
            }
        });
    }

    public void showPopup(Component component2, Supplier<Rectangle> boundsSupplier) {
        this.updatePopupBounds(component2, boundsSupplier.get());
        PopupManager.showPopup(component2, this, this.requestFocusOnShow);
        this.updateLocationListeners(component2, boundsSupplier);
    }

    protected void updatePopupBounds(Component component2, Rectangle bounds) {
        this.updatePopupBounds(component2, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    protected void updatePopupBounds(Component component2, int x, int y, int width, int height) {
        if (component2.isShowing()) {
            Rectangle cb = CoreSwingUtils.getBoundsInWindow(component2);
            this.setBounds(cb.x + x, cb.y + y, width, height);
            this.revalidate();
            this.repaint();
        }
    }

    protected void updateComponentAncestorListener(final Component component2, final int x, final int y, final int width, final int height) {
        this.clearLocationListeners();
        this.lastComponent = component2;
        if (component2 instanceof JComponent) {
            this.lastAncestorListener = new AncestorAdapter(){

                @Override
                public void ancestorMoved(AncestorEvent event) {
                    WebInnerPopup.this.updatePopupBounds(component2, x, y, width, height);
                }
            };
            ((JComponent)this.lastComponent).addAncestorListener(this.lastAncestorListener);
        }
    }

    protected void updateLocationListeners(final Component component2, final Supplier<Rectangle> boundsSupplier) {
        this.clearLocationListeners();
        this.lastComponent = component2;
        this.lastComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WebInnerPopup.this.updatePopupBounds(component2, (Rectangle)boundsSupplier.get());
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                WebInnerPopup.this.updatePopupBounds(component2, (Rectangle)boundsSupplier.get());
            }
        };
        this.lastComponent.addComponentListener(this.lastComponentListener);
        if (component2 instanceof JComponent) {
            this.lastAncestorListener = new AncestorAdapter(){

                @Override
                public void ancestorMoved(AncestorEvent event) {
                    WebInnerPopup.this.updatePopupBounds(component2, (Rectangle)boundsSupplier.get());
                }
            };
            ((JComponent)this.lastComponent).addAncestorListener(this.lastAncestorListener);
        }
    }

    protected void clearLocationListeners() {
        if (this.lastComponent != null) {
            if (this.lastComponentListener != null) {
                this.lastComponent.removeComponentListener(this.lastComponentListener);
            }
            if (this.lastAncestorListener != null && this.lastComponent instanceof JComponent) {
                ((JComponent)this.lastComponent).removeAncestorListener(this.lastAncestorListener);
            }
        }
    }

    public void showPopupAsModal(Component component2) {
        this.showPopupAsModal(component2, false, false);
    }

    public void showPopupAsModal(Component component2, boolean hfill, boolean vfill) {
        PopupManager.showModalPopup(component2, this, hfill, vfill);
    }

    public void hidePopup() {
        if (this.animated) {
            this.fadeStateType = FadeStateType.fadeOut;
            if (!this.fadeTimer.isRunning()) {
                this.fadeTimer.start();
            }
        } else {
            this.hidePopupImpl();
        }
    }

    protected void hidePopupImpl() {
        this.clearLocationListeners();
        PopupLayer layer = (PopupLayer)this.getParent();
        if (layer != null) {
            layer.hidePopup(this);
        }
    }

    public void packPopup() {
        this.setSize(this.getPreferredSize());
    }

    public void updateBounds() {
        if (this.lastAncestorListener != null) {
            this.lastAncestorListener.ancestorMoved(null);
        }
    }

    @Override
    public boolean contains(int x, int y) {
        return this.fadeStateType != FadeStateType.fadeOut && this.getPainterShape().contains(x, y);
    }

    @Override
    public void addPopupListener(PopupListener listener) {
        this.listenerList.add(PopupListener.class, listener);
    }

    @Override
    public void removePopupListener(PopupListener listener) {
        this.listenerList.remove(PopupListener.class, listener);
    }

    @Override
    public PopupListener beforePopupOpen(Runnable action) {
        return PopupMethodsImpl.beforePopupOpen(this, action);
    }

    @Override
    public PopupListener onPopupOpen(Runnable action) {
        return PopupMethodsImpl.onPopupOpen(this, action);
    }

    @Override
    public PopupListener beforePopupClose(Runnable action) {
        return PopupMethodsImpl.beforePopupClose(this, action);
    }

    @Override
    public PopupListener onPopupClose(Runnable action) {
        return PopupMethodsImpl.onPopupClose(this, action);
    }

    public void firePopupWillBeOpened() {
        for (PopupListener listener : (PopupListener[])this.listenerList.getListeners(PopupListener.class)) {
            listener.popupWillBeOpened();
        }
    }

    public void firePopupOpened() {
        for (PopupListener listener : (PopupListener[])this.listenerList.getListeners(PopupListener.class)) {
            listener.popupOpened();
        }
    }

    public void firePopupWillBeClosed() {
        for (PopupListener listener : (PopupListener[])this.listenerList.getListeners(PopupListener.class)) {
            listener.popupWillBeClosed();
        }
    }

    public void firePopupClosed() {
        for (PopupListener listener : (PopupListener[])this.listenerList.getListeners(PopupListener.class)) {
            listener.popupClosed();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.fade < 1.0f) {
            GraphicsUtils.setupAlphaComposite((Graphics2D)g, Float.valueOf(this.fade));
        }
        super.paintComponent(g);
    }
}

