/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.popup;

import com.alee.api.jdk.BiConsumer;
import com.alee.api.jdk.Function;
import com.alee.managers.popup.PopupLayer;
import com.alee.managers.popup.ShadeLayer;
import com.alee.managers.popup.WebInnerPopup;
import com.alee.managers.style.StyleId;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.swing.WeakComponentData;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;

public final class PopupManager {
    protected static final WeakComponentData<JComponent, ShadeLayer> shadeLayers = new WeakComponentData("PopupManager.ShadeLayer", 3);
    protected static final WeakComponentData<JComponent, PopupLayer> popupLayers = new WeakComponentData("PopupManager.PopupLayer", 3);
    protected static StyleId defaultPopupStyleId = StyleId.innerpopup;

    public static void hideAllPopups() {
        shadeLayers.forEach(new BiConsumer<JComponent, ShadeLayer>(){

            @Override
            public void accept(JComponent component2, ShadeLayer shadeLayer) {
                shadeLayer.hideAllPopups();
            }
        });
        popupLayers.forEach(new BiConsumer<JComponent, PopupLayer>(){

            @Override
            public void accept(JComponent component2, PopupLayer popupLayer) {
                popupLayer.hideAllPopups();
            }
        });
    }

    public static void hideAllPopups(JComponent component2) {
        PopupManager.hideAllPopups(CoreSwingUtils.getRootPane(component2));
    }

    public static void hideAllPopups(JRootPane rootPane) {
        if (shadeLayers.contains(rootPane)) {
            shadeLayers.get(rootPane).hideAllPopups();
        }
        if (popupLayers.contains(rootPane)) {
            popupLayers.get(rootPane).hideAllPopups();
        }
    }

    public static StyleId getDefaultPopupStyleId() {
        return defaultPopupStyleId;
    }

    public static void setDefaultPopupStyleId(StyleId id) {
        defaultPopupStyleId = id;
    }

    public static void showPopup(Component component2, WebInnerPopup popup) {
        PopupManager.showPopup(component2, popup, true);
    }

    public static void showPopup(Component component2, WebInnerPopup popup, boolean transferFocus) {
        JRootPane rootPane = CoreSwingUtils.getRootPane(component2);
        if (rootPane != null) {
            PopupManager.showPopup(rootPane, popup, transferFocus);
        }
    }

    public static void showPopup(JRootPane rootPane, WebInnerPopup popup, boolean transferFocus) {
        PopupManager.getPopupLayer(rootPane).showPopup(popup);
        if (transferFocus) {
            popup.transferFocus();
        }
    }

    public static void showModalPopup(Component component2, WebInnerPopup popup, boolean hfill, boolean vfill) {
        PopupManager.showModalPopup(component2, popup, hfill, vfill, false);
    }

    public static void showModalPopup(Component component2, WebInnerPopup popup, boolean hfill, boolean vfill, boolean blockClose) {
        JRootPane rootPane = CoreSwingUtils.getRootPane(component2);
        if (rootPane != null) {
            PopupManager.showModalPopup(rootPane, popup, hfill, vfill, blockClose);
        }
    }

    public static void showModalPopup(JRootPane rootPane, WebInnerPopup popup, boolean hfill, boolean vfill) {
        PopupManager.showModalPopup(rootPane, popup, hfill, vfill, false);
    }

    public static void showModalPopup(JRootPane rootPane, WebInnerPopup popup, boolean hfill, boolean vfill, boolean blockClose) {
        PopupManager.hideAllPopups(rootPane);
        ShadeLayer shadeLayer = PopupManager.getShadeLayer(rootPane);
        shadeLayer.setBlockClose(blockClose);
        shadeLayer.showPopup(popup, hfill, vfill);
        popup.transferFocus();
    }

    public static PopupLayer getPopupLayer(Component component2) {
        return PopupManager.getPopupLayer(CoreSwingUtils.getRootPane(component2));
    }

    public static PopupLayer getPopupLayer(final JRootPane rootPane) {
        if (rootPane != null) {
            return popupLayers.get(rootPane, new Function<JComponent, PopupLayer>(){

                @Override
                public PopupLayer apply(JComponent component2) {
                    JLayeredPane layeredPane = rootPane.getLayeredPane();
                    if (layeredPane == null) {
                        throw new RuntimeException("PopupLayer can be installed only into window or applet with JLayeredPane");
                    }
                    PopupLayer popupLayer = new PopupLayer();
                    PopupManager.installPopupLayer(popupLayer, rootPane, layeredPane);
                    return popupLayer;
                }
            });
        }
        throw new RuntimeException("JRootPane for PopupLayer was not specified");
    }

    public static ShadeLayer getShadeLayer(final JRootPane rootPane) {
        if (rootPane != null) {
            return shadeLayers.get(rootPane, new Function<JComponent, ShadeLayer>(){

                @Override
                public ShadeLayer apply(JComponent component2) {
                    JLayeredPane layeredPane = rootPane.getLayeredPane();
                    if (layeredPane != null) {
                        throw new RuntimeException("ShadeLayer can be installed only into window or applet with JLayeredPane");
                    }
                    ShadeLayer shadeLayer = new ShadeLayer();
                    PopupManager.installPopupLayer(shadeLayer, rootPane, layeredPane);
                    return shadeLayer;
                }
            });
        }
        throw new RuntimeException("JRootPane for ShadeLayer was not specified");
    }

    protected static void installPopupLayer(final PopupLayer popupLayer, JRootPane rootPane, final JLayeredPane layeredPane) {
        popupLayer.setBounds(0, 0, layeredPane.getWidth(), layeredPane.getHeight());
        popupLayer.setVisible(true);
        layeredPane.add((Component)popupLayer, JLayeredPane.PALETTE_LAYER);
        layeredPane.revalidate();
        layeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                popupLayer.setBounds(0, 0, layeredPane.getWidth(), layeredPane.getHeight());
                popupLayer.revalidate();
            }
        });
        Window window = CoreSwingUtils.getWindowAncestor(rootPane);
        if (window != null) {
            window.addWindowStateListener(new WindowStateListener(){

                @Override
                public void windowStateChanged(WindowEvent e) {
                    popupLayer.setBounds(0, 0, layeredPane.getWidth(), layeredPane.getHeight());
                    popupLayer.revalidate();
                }
            });
        }
    }
}

