/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.notification;

import com.alee.managers.notification.DisplayType;
import com.alee.managers.notification.NotificationManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.SwingConstants;

public final class NotificationsLayoutUtils
implements SwingConstants {
    public static void layout(List<? extends Component> notifications, Rectangle bounds) {
        int startY;
        int location = NotificationManager.getLocation();
        boolean east = location == 4 || location == 2;
        boolean south = location == 4 || location == 6;
        boolean flowDisplayType = NotificationManager.getDisplayType() == DisplayType.flow;
        Insets margin = NotificationManager.getMargin();
        int gap = NotificationManager.getGap();
        boolean cascade = NotificationManager.isCascade();
        int cascadeAmount = NotificationManager.getCascadeAmount();
        int maxWidth = 0;
        int maxCascade = 0;
        int x = east ? bounds.x + bounds.width - margin.right : bounds.x + margin.left;
        int y = startY = south ? bounds.y + bounds.height - margin.bottom : bounds.y + margin.top;
        int count = 0;
        for (Component component2 : notifications) {
            Dimension ps = component2.getPreferredSize();
            if (south ? y - ps.height < bounds.y : y + ps.height > bounds.height) {
                int gapsAmount = cascade ? Math.max(1, maxCascade) : 1;
                y = startY;
                x = east ? x - maxWidth - gap * gapsAmount : x + maxWidth + gap;
                maxWidth = 0;
                maxCascade = 0;
                count = 0;
            }
            int cascadeShear = cascade ? gap * count : 0;
            int x1 = east ? x - ps.width - cascadeShear : x + cascadeShear;
            int y1 = south ? y - ps.height : y;
            component2.setBounds(x1, y1, ps.width, ps.height);
            maxWidth = Math.max(maxWidth, ps.width);
            y += (south ? -1 : 1) * (flowDisplayType ? ps.height + gap : gap);
            if (!cascade) continue;
            maxCascade = Math.max(maxCascade, ++count);
            if (count <= cascadeAmount - 1) continue;
            count = 0;
        }
    }
}

