/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.notification;

import com.alee.api.jdk.BiConsumer;
import com.alee.api.jdk.Function;
import com.alee.extended.label.WebStyledLabel;
import com.alee.extended.window.PopupAdapter;
import com.alee.managers.notification.DisplayType;
import com.alee.managers.notification.NotificationIcon;
import com.alee.managers.notification.NotificationOption;
import com.alee.managers.notification.NotificationsLayout;
import com.alee.managers.notification.NotificationsScreenLayout;
import com.alee.managers.notification.WebInnerNotification;
import com.alee.managers.notification.WebNotification;
import com.alee.managers.popup.PopupLayer;
import com.alee.managers.popup.PopupManager;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.swing.WeakComponentData;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingConstants;

public final class NotificationManager
implements SwingConstants {
    private static int location = -1;
    private static DisplayType displayType = DisplayType.stack;
    private static Insets margin = new Insets(0, 0, 0, 0);
    private static int gap = 10;
    private static boolean cascade = true;
    private static int cascadeAmount = 4;
    private static boolean avoidOverlappingSystemToolbar = true;
    private static final WeakComponentData<PopupLayer, NotificationsLayout> notificationsLayouts = new WeakComponentData("NotificationManager.NotificationsLayout", 2);
    private static final WeakComponentData<WebInnerNotification, PopupLayer> notificationPopups = new WeakComponentData("NotificationManager.PopupLayer", 5);
    private static final Map<GraphicsDevice, NotificationsScreenLayout> screenLayouts = new HashMap<GraphicsDevice, NotificationsScreenLayout>(1);
    private static final WeakComponentData<WebNotification, Window> notificationWindows = new WeakComponentData("NotificationManager.Window", 5);

    public static int getLocation() {
        return location != -1 ? location : (SystemUtils.isWindows() ? 4 : 2);
    }

    public static void setLocation(int location) {
        NotificationManager.location = location;
        NotificationManager.updateNotificationLayouts();
    }

    public static DisplayType getDisplayType() {
        return displayType;
    }

    public static void setDisplayType(DisplayType displayType) {
        NotificationManager.displayType = displayType;
        NotificationManager.updateNotificationLayouts();
    }

    public static Insets getMargin() {
        return margin;
    }

    public static void setMargin(int margin) {
        NotificationManager.setMargin(margin, margin, margin, margin);
    }

    public static void setMargin(int top, int left, int bottom, int right) {
        NotificationManager.setMargin(new Insets(top, left, bottom, right));
    }

    public static void setMargin(Insets margin) {
        NotificationManager.margin = margin;
        NotificationManager.updateNotificationLayouts();
    }

    public static int getGap() {
        return gap;
    }

    public static void setGap(int gap) {
        NotificationManager.gap = gap;
        NotificationManager.updateNotificationLayouts();
    }

    public static boolean isCascade() {
        return cascade;
    }

    public static void setCascade(boolean cascade) {
        NotificationManager.cascade = cascade;
        NotificationManager.updateNotificationLayouts();
    }

    public static int getCascadeAmount() {
        return cascadeAmount;
    }

    public static void setCascadeAmount(int cascadeAmount) {
        NotificationManager.cascadeAmount = cascadeAmount;
        if (cascade) {
            NotificationManager.updateNotificationLayouts();
        }
    }

    public static boolean isAvoidOverlappingSystemToolbar() {
        return avoidOverlappingSystemToolbar;
    }

    public static void setAvoidOverlappingSystemToolbar(boolean avoid) {
        avoidOverlappingSystemToolbar = avoid;
    }

    public static void updateNotificationLayouts() {
        final ArrayList layers = new ArrayList();
        notificationPopups.forEach(new BiConsumer<WebInnerNotification, PopupLayer>(){

            @Override
            public void accept(WebInnerNotification webInnerNotification, PopupLayer popupLayer) {
                if (!layers.contains(popupLayer)) {
                    layers.add(popupLayer);
                    popupLayer.revalidate();
                }
            }
        });
        for (Map.Entry<GraphicsDevice, NotificationsScreenLayout> entry : screenLayouts.entrySet()) {
            entry.getValue().layoutScreen();
        }
    }

    public static void hideAllNotifications() {
        notificationPopups.forEach(new BiConsumer<WebInnerNotification, PopupLayer>(){

            @Override
            public void accept(WebInnerNotification webInnerNotification, PopupLayer popupLayer) {
                webInnerNotification.hidePopup();
            }
        });
        notificationWindows.forEach(new BiConsumer<WebNotification, Window>(){

            @Override
            public void accept(WebNotification webNotification, Window window) {
                webNotification.hidePopup();
            }
        });
    }

    public static WebNotification showNotification(String content) {
        return NotificationManager.showNotification(null, (Component)new WebStyledLabel(content), (Icon)NotificationIcon.information.getIcon());
    }

    public static WebNotification showNotification(String content, Icon icon) {
        return NotificationManager.showNotification(null, (Component)new WebStyledLabel(content), icon);
    }

    public static WebNotification showNotification(Component showFor, String content) {
        return NotificationManager.showNotification(showFor, (Component)new WebStyledLabel(content), (Icon)NotificationIcon.information.getIcon());
    }

    public static WebNotification showNotification(Component showFor, String content, Icon icon) {
        return NotificationManager.showNotification(showFor, (Component)new WebStyledLabel(content), icon);
    }

    public static WebNotification showNotification(Component content) {
        return NotificationManager.showNotification(null, content, (Icon)NotificationIcon.information.getIcon());
    }

    public static WebNotification showNotification(Component content, Icon icon) {
        return NotificationManager.showNotification(null, content, icon);
    }

    public static WebNotification showNotification(Component showFor, Component content) {
        return NotificationManager.showNotification(showFor, content, (Icon)NotificationIcon.information.getIcon());
    }

    public static WebNotification showNotification(Component showFor, Component content, Icon icon) {
        WebNotification notificationWindow = new WebNotification();
        notificationWindow.setIcon(icon);
        notificationWindow.setContent(content);
        return NotificationManager.showNotification(showFor, notificationWindow);
    }

    public static WebNotification showNotification(String content, NotificationOption ... options) {
        return NotificationManager.showNotification(null, (Component)new WebStyledLabel(content), (Icon)NotificationIcon.information.getIcon(), options);
    }

    public static WebNotification showNotification(String content, Icon icon, NotificationOption ... options) {
        return NotificationManager.showNotification(null, (Component)new WebStyledLabel(content), icon, options);
    }

    public static WebNotification showNotification(Component showFor, String content, NotificationOption ... options) {
        return NotificationManager.showNotification(showFor, (Component)new WebStyledLabel(content), (Icon)NotificationIcon.information.getIcon(), options);
    }

    public static WebNotification showNotification(Component showFor, String content, Icon icon, NotificationOption ... options) {
        return NotificationManager.showNotification(showFor, (Component)new WebStyledLabel(content), icon, options);
    }

    public static WebNotification showNotification(Component content, NotificationOption ... options) {
        return NotificationManager.showNotification(null, content, (Icon)NotificationIcon.information.getIcon(), options);
    }

    public static WebNotification showNotification(Component content, Icon icon, NotificationOption ... options) {
        return NotificationManager.showNotification(null, content, icon, options);
    }

    public static WebNotification showNotification(Component showFor, Component content, NotificationOption ... options) {
        return NotificationManager.showNotification(showFor, content, (Icon)NotificationIcon.information.getIcon(), options);
    }

    public static WebNotification showNotification(Component showFor, Component content, Icon icon, NotificationOption ... options) {
        WebNotification notificationPopup = new WebNotification();
        notificationPopup.setIcon(icon);
        notificationPopup.setContent(content);
        notificationPopup.setOptions(options);
        return NotificationManager.showNotification(showFor, notificationPopup);
    }

    public static WebNotification showNotification(WebNotification notification) {
        return NotificationManager.showNotification(null, notification);
    }

    public static WebNotification showNotification(Component showFor, final WebNotification notification) {
        final NotificationsScreenLayout layout = NotificationManager.getLayout(showFor);
        notificationWindows.set(notification, CoreSwingUtils.getWindowAncestor(showFor));
        notification.addPopupListener(new PopupAdapter(){

            @Override
            public void popupWillBeClosed() {
                notificationWindows.clear(notification);
                layout.removeWindow(notification.getWindow());
                notification.removePopupListener(this);
            }
        });
        notification.showPopup(showFor, 0, 0);
        layout.addWindow(notification.getWindow());
        return notification;
    }

    private static NotificationsScreenLayout getLayout(Component showFor) {
        Window window = showFor != null && showFor.isShowing() ? CoreSwingUtils.getWindowAncestor(showFor) : null;
        GraphicsDevice gd = SystemUtils.getGraphicsDevice(window);
        if (!screenLayouts.containsKey(gd)) {
            screenLayouts.put(gd, new NotificationsScreenLayout(gd));
        }
        return screenLayouts.get(gd);
    }

    public static WebInnerNotification showInnerNotification(String content) {
        return NotificationManager.showInnerNotification((Component)SwingUtils.getAvailableWindow(), (Component)new WebStyledLabel(content), (Icon)NotificationIcon.information.getIcon());
    }

    public static WebInnerNotification showInnerNotification(String content, Icon icon) {
        return NotificationManager.showInnerNotification((Component)SwingUtils.getAvailableWindow(), (Component)new WebStyledLabel(content), icon);
    }

    public static WebInnerNotification showInnerNotification(Component showFor, String content) {
        return NotificationManager.showInnerNotification(showFor, (Component)new WebStyledLabel(content), (Icon)NotificationIcon.information.getIcon());
    }

    public static WebInnerNotification showInnerNotification(Component showFor, String content, Icon icon) {
        return NotificationManager.showInnerNotification(showFor, (Component)new WebStyledLabel(content), icon);
    }

    public static WebInnerNotification showInnerNotification(Component content) {
        return NotificationManager.showInnerNotification((Component)SwingUtils.getAvailableWindow(), content, (Icon)NotificationIcon.information.getIcon());
    }

    public static WebInnerNotification showInnerNotification(Component content, Icon icon) {
        return NotificationManager.showInnerNotification((Component)SwingUtils.getAvailableWindow(), content, icon);
    }

    public static WebInnerNotification showInnerNotification(Component showFor, Component content) {
        return NotificationManager.showInnerNotification(showFor, content, (Icon)NotificationIcon.information.getIcon());
    }

    public static WebInnerNotification showInnerNotification(Component showFor, Component content, Icon icon) {
        WebInnerNotification notificationPopup = new WebInnerNotification();
        notificationPopup.setIcon(icon);
        notificationPopup.setContent(content);
        return NotificationManager.showInnerNotification(showFor, notificationPopup);
    }

    public static WebInnerNotification showInnerNotification(String content, NotificationOption ... options) {
        return NotificationManager.showInnerNotification((Component)SwingUtils.getAvailableWindow(), (Component)new WebStyledLabel(content), (Icon)NotificationIcon.information.getIcon(), options);
    }

    public static WebInnerNotification showInnerNotification(String content, Icon icon, NotificationOption ... options) {
        return NotificationManager.showInnerNotification((Component)SwingUtils.getAvailableWindow(), (Component)new WebStyledLabel(content), icon, options);
    }

    public static WebInnerNotification showInnerNotification(Component showFor, String content, NotificationOption ... options) {
        return NotificationManager.showInnerNotification(showFor, (Component)new WebStyledLabel(content), (Icon)NotificationIcon.information.getIcon(), options);
    }

    public static WebInnerNotification showInnerNotification(Component showFor, String content, Icon icon, NotificationOption ... options) {
        return NotificationManager.showInnerNotification(showFor, (Component)new WebStyledLabel(content), icon, options);
    }

    public static WebInnerNotification showInnerNotification(Component content, NotificationOption ... options) {
        return NotificationManager.showInnerNotification((Component)SwingUtils.getAvailableWindow(), content, (Icon)NotificationIcon.information.getIcon(), options);
    }

    public static WebInnerNotification showInnerNotification(Component content, Icon icon, NotificationOption ... options) {
        return NotificationManager.showInnerNotification((Component)SwingUtils.getAvailableWindow(), content, icon, options);
    }

    public static WebInnerNotification showInnerNotification(Component showFor, Component content, NotificationOption ... options) {
        return NotificationManager.showInnerNotification(showFor, content, (Icon)NotificationIcon.information.getIcon(), options);
    }

    public static WebInnerNotification showInnerNotification(Component showFor, Component content, Icon icon, NotificationOption ... options) {
        WebInnerNotification notificationPopup = new WebInnerNotification();
        notificationPopup.setIcon(icon);
        notificationPopup.setContent(content);
        notificationPopup.setOptions(options);
        return NotificationManager.showInnerNotification(showFor, notificationPopup);
    }

    public static WebInnerNotification showInnerNotification(WebInnerNotification notification) {
        return NotificationManager.showInnerNotification((Component)SwingUtils.getAvailableWindow(), notification);
    }

    public static WebInnerNotification showInnerNotification(Component showFor, final WebInnerNotification notification) {
        if (showFor == null) {
            throw new RuntimeException("There is no visible windows to display inner notification!");
        }
        PopupLayer popupLayer = PopupManager.getPopupLayer(showFor);
        notificationsLayouts.get(popupLayer, new Function<PopupLayer, NotificationsLayout>(){

            @Override
            public NotificationsLayout apply(PopupLayer popupLayer) {
                NotificationsLayout layout = new NotificationsLayout();
                popupLayer.addLayoutManager(layout);
                return layout;
            }
        });
        notificationPopups.set(notification, popupLayer);
        notification.addPopupListener(new PopupAdapter(){

            @Override
            public void popupWillBeClosed() {
                notificationPopups.clear(notification);
                notification.removePopupListener(this);
            }
        });
        notification.showPopup(showFor);
        return notification;
    }
}

