/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.managers.language.LanguageUtils;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Value;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.Locale;

public final class ValueConverter
implements Converter {
    private static final String LANGUAGE = "lang";
    private static final String STATE = "state";
    private static final String MNEMONIC = "mnemonic";

    @Override
    public boolean canConvert(Class type) {
        return Value.class.getCanonicalName().equals(type.getCanonicalName());
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Value value = (Value)source;
        Locale locale = value.getLocale();
        writer.addAttribute(LANGUAGE, LanguageUtils.toString(locale));
        if (value.textsCount() == 1) {
            Text text = value.getTexts().get(0);
            if (text.getState() != null) {
                writer.addAttribute(STATE, text.getState());
            }
            if (text.getMnemonic() != -1) {
                writer.addAttribute(MNEMONIC, Character.toString((char)text.getMnemonic()));
            }
            writer.setValue(text.getText(new Object[0]));
        } else if (value.textsCount() > 0) {
            context.convertAnother(value.getTexts());
        } else {
            writer.setValue("");
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Value value = new Value();
        String locale = reader.getAttribute(LANGUAGE);
        value.setLocale(LanguageUtils.fromString(locale));
        String state = reader.getAttribute(STATE);
        String character = reader.getAttribute(MNEMONIC);
        int mnemonic = character != null ? (int)character.charAt(0) : -1;
        String text = reader.getValue();
        ArrayList<Text> texts = new ArrayList<Text>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            texts.add((Text)context.convertAnother(value, Text.class));
            reader.moveUp();
        }
        if (texts.size() == 0) {
            value.addText(new Text(text, state, mnemonic));
        } else {
            value.setTexts(texts);
        }
        return value;
    }
}

