/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.BiConsumer;
import com.alee.api.jdk.Objects;
import com.alee.api.resource.ClassResource;
import com.alee.extended.collapsible.WebCollapsiblePaneLU;
import com.alee.extended.dock.WebDockableFrameLU;
import com.alee.extended.filechooser.WebFileDropLU;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.AbstractButtonLU;
import com.alee.laf.desktoppane.JInternalFrameLU;
import com.alee.laf.filechooser.JFileChooserLU;
import com.alee.laf.label.JLabelLU;
import com.alee.laf.progressbar.JProgressBarLU;
import com.alee.laf.rootpane.JRootPaneLU;
import com.alee.laf.tabbedpane.JTabbedPaneLU;
import com.alee.laf.text.JTextComponentLU;
import com.alee.laf.tooltip.SwingToolTipLanguage;
import com.alee.managers.language.AbstractToolTipLanguage;
import com.alee.managers.language.DictionaryListener;
import com.alee.managers.language.LM;
import com.alee.managers.language.Language;
import com.alee.managers.language.LanguageException;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.LanguageUpdater;
import com.alee.managers.language.LanguageUpdaterComparator;
import com.alee.managers.language.LanguageUtils;
import com.alee.managers.language.ToolTipLU;
import com.alee.managers.language.TranslationKey;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.tooltip.CustomToolTipLanguage;
import com.alee.utils.ArrayUtils;
import com.alee.utils.swing.WeakComponentData;
import com.alee.utils.swing.WeakComponentDataOrderedSet;
import java.awt.ComponentOrientation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public final class UILanguageManager {
    private static final ImageIcon UNKNOWN_LANGUAGE = new ImageIcon(UILanguageManager.class.getResource("icons/unknown.png"));
    @NotNull
    private static final Map<String, Icon> localeIcons = new HashMap<String, Icon>();
    private static boolean checkComponentsTextForTranslations;
    @NotNull
    private static final WeakComponentData<JComponent, TranslationKey> components;
    @NotNull
    private static final LanguageUpdaterComparator languageUpdaterComparator;
    @NotNull
    private static final List<LanguageUpdater> updaters;
    @NotNull
    private static final WeakComponentData<JComponent, LanguageUpdater> customUpdaters;
    @NotNull
    private static final Map<Class, LanguageUpdater> updatersCache;
    @NotNull
    private static final WeakComponentDataOrderedSet<JComponent, LanguageListener> componentLanguageListeners;
    @NotNull
    private static final WeakComponentDataOrderedSet<JComponent, DictionaryListener> componentDictionaryListeners;
    private static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            LanguageManager.initialize();
            UILanguageManager.setCheckComponentsTextForTranslations(true);
            initialized = true;
            UILanguageManager.registerLanguageUpdater(new ToolTipLU());
            UILanguageManager.registerLanguageUpdater(new JLabelLU());
            UILanguageManager.registerLanguageUpdater(new AbstractButtonLU());
            UILanguageManager.registerLanguageUpdater(new JTextComponentLU());
            UILanguageManager.registerLanguageUpdater(new JTabbedPaneLU());
            UILanguageManager.registerLanguageUpdater(new JProgressBarLU());
            UILanguageManager.registerLanguageUpdater(new JFileChooserLU());
            UILanguageManager.registerLanguageUpdater(new JRootPaneLU());
            UILanguageManager.registerLanguageUpdater(new JInternalFrameLU());
            UILanguageManager.registerLanguageUpdater(new WebFileDropLU());
            UILanguageManager.registerLanguageUpdater(new WebCollapsiblePaneLU());
            UILanguageManager.registerLanguageUpdater(new WebDockableFrameLU());
            UILanguageManager.registerLanguageUpdater(new SwingToolTipLanguage());
            UILanguageManager.registerLanguageUpdater(new CustomToolTipLanguage());
            AbstractToolTipLanguage.setDefaultToolTipType("CUSTOM");
            LanguageManager.addLanguageListener(new LanguageListener(){

                @Override
                public void languageChanged(@NotNull Language oldLanguage, @NotNull Language newLanguage) {
                    ComponentOrientation oo = ComponentOrientation.getOrientation(oldLanguage.getLocale());
                    ComponentOrientation no = ComponentOrientation.getOrientation(newLanguage.getLocale());
                    if (oo.isLeftToRight() != no.isLeftToRight()) {
                        WebLookAndFeel.updateOrientation();
                    }
                    UILanguageManager.updateComponents();
                    UILanguageManager.fireLanguageChanged(oldLanguage, newLanguage);
                }
            });
            LanguageManager.addDictionaryListener(new DictionaryListener(){

                @Override
                public void dictionaryAdded(@NotNull Dictionary dictionary) {
                    UILanguageManager.updateComponents(dictionary.getKeys());
                    UILanguageManager.fireDictionaryAdded(dictionary);
                }

                @Override
                public void dictionaryRemoved(@NotNull Dictionary dictionary) {
                    UILanguageManager.updateComponents(dictionary.getKeys());
                    UILanguageManager.fireDictionaryRemoved(dictionary);
                }

                @Override
                public void dictionariesCleared() {
                    UILanguageManager.updateComponents();
                    UILanguageManager.fireDictionariesCleared();
                }
            });
            LanguageManager.addDictionary(new Dictionary(new ClassResource(UILanguageManager.class, "resources/ui-language.xml")));
        }
    }

    private static void mustBeInitialized() throws LanguageException {
        if (!initialized) {
            throw new LanguageException("WebLanguageManager must be initialized first");
        }
    }

    public static boolean isCheckComponentsTextForTranslations() {
        return checkComponentsTextForTranslations;
    }

    public static void setCheckComponentsTextForTranslations(boolean check) {
        checkComponentsTextForTranslations = check;
    }

    @NotNull
    public static Icon getLanguageIcon(@NotNull Language language2) {
        return UILanguageManager.getLocaleIcon(language2.getLocale());
    }

    @NotNull
    public static Icon getLocaleIcon(@NotNull Locale locale) {
        Icon localeIcon;
        String key = LanguageUtils.toString(locale);
        if (localeIcons.containsKey(key)) {
            localeIcon = localeIcons.get(key);
        } else {
            ImageIcon icon;
            try {
                URL res = UILanguageManager.class.getResource("icons/" + key + ".png");
                if (res == null) {
                    res = UILanguageManager.class.getResource("icons/" + locale.getLanguage() + ".png");
                }
                icon = new ImageIcon(res);
            }
            catch (Exception e) {
                icon = UNKNOWN_LANGUAGE;
            }
            localeIcons.put(key, icon);
            localeIcon = icon;
        }
        return localeIcon;
    }

    @Nullable
    public static Icon setLanguageIcon(@NotNull Language language2, @Nullable Icon icon) {
        return UILanguageManager.setLocaleIcon(language2.getLocale(), icon);
    }

    @Nullable
    public static Icon setLocaleIcon(@NotNull Locale locale, @Nullable Icon icon) {
        String key = LanguageUtils.toString(locale);
        return localeIcons.put(key, icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLanguageUpdater(@NotNull LanguageUpdater updater) {
        List<LanguageUpdater> list = updaters;
        synchronized (list) {
            Iterator<LanguageUpdater> iterator = updaters.iterator();
            while (iterator.hasNext()) {
                if (updater.getComponentClass() != iterator.next().getComponentClass()) continue;
                iterator.remove();
            }
            updaters.add(updater);
            updatersCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterLanguageUpdater(@NotNull LanguageUpdater updater) {
        List<LanguageUpdater> list = updaters;
        synchronized (list) {
            updaters.remove(updater);
            updatersCache.clear();
        }
    }

    public static void registerLanguageUpdater(@NotNull JComponent component2, @NotNull LanguageUpdater updater) {
        customUpdaters.set(component2, updater);
    }

    public static void unregisterLanguageUpdater(@NotNull JComponent component2) {
        customUpdaters.clear(component2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static LanguageUpdater getLanguageUpdater(@NotNull JComponent component2) {
        LanguageUpdater updater;
        LanguageUpdater customUpdater = customUpdaters.get(component2);
        if (customUpdater != null) {
            updater = customUpdater;
        } else {
            List<LanguageUpdater> list = updaters;
            synchronized (list) {
                LanguageUpdater cachedUpdater = updatersCache.get(component2.getClass());
                if (cachedUpdater != null) {
                    updater = cachedUpdater;
                } else {
                    ArrayList<LanguageUpdater> foundUpdaters = new ArrayList<LanguageUpdater>();
                    for (LanguageUpdater lu : updaters) {
                        if (!lu.getComponentClass().isInstance(component2)) continue;
                        foundUpdaters.add(lu);
                    }
                    if (foundUpdaters.size() == 1) {
                        updater = (LanguageUpdater)foundUpdaters.get(0);
                    } else if (foundUpdaters.size() > 1) {
                        Collections.sort(foundUpdaters, languageUpdaterComparator);
                        updater = (LanguageUpdater)foundUpdaters.get(0);
                    } else {
                        throw new RuntimeException("Unable to find LanguageUpdater for component: " + component2);
                    }
                    updatersCache.put(component2.getClass(), updater);
                }
            }
        }
        return updater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static LanguageUpdater getLanguageUpdater(@NotNull Class<? extends JComponent> clazz) {
        LanguageUpdater updater;
        List<LanguageUpdater> list = updaters;
        synchronized (list) {
            updater = updatersCache.get(clazz);
            if (updater == null) {
                ArrayList<LanguageUpdater> foundUpdaters = new ArrayList<LanguageUpdater>();
                for (LanguageUpdater lu : updaters) {
                    if (!lu.getComponentClass().isAssignableFrom(clazz)) continue;
                    foundUpdaters.add(lu);
                }
                if (foundUpdaters.size() == 1) {
                    updater = (LanguageUpdater)foundUpdaters.get(0);
                } else if (foundUpdaters.size() > 1) {
                    Collections.sort(foundUpdaters, languageUpdaterComparator);
                    updater = (LanguageUpdater)foundUpdaters.get(0);
                } else {
                    throw new RuntimeException("Unable to find LanguageUpdater for component class: " + clazz);
                }
                updatersCache.put(clazz, updater);
            }
        }
        return updater;
    }

    @Nullable
    public static String getInitialText(@Nullable String key, Object ... data) {
        UILanguageManager.mustBeInitialized();
        String text = UILanguageManager.isCheckComponentsTextForTranslations() && LM.contains(key) ? (LM.containsText(key) ? LM.get(key, data) : null) : key;
        return text;
    }

    public static void registerInitialLanguage(@NotNull LanguageMethods component2, @Nullable String key, Object ... data) {
        UILanguageManager.mustBeInitialized();
        if (UILanguageManager.isCheckComponentsTextForTranslations() && key != null && LM.contains(key)) {
            component2.setLanguage(key, data);
        }
    }

    public static void registerComponent(@NotNull JComponent component2, @NotNull String key, Object ... data) {
        UILanguageManager.mustBeInitialized();
        UILanguageManager.unregisterComponent(component2);
        Object[] actualData = data != null && data.length == 0 ? null : data;
        components.set(component2, new TranslationKey(key, actualData));
        UILanguageManager.updateComponent(component2, new Object[0]);
    }

    public static void unregisterComponent(@NotNull JComponent component2) {
        UILanguageManager.mustBeInitialized();
        components.clear(component2);
    }

    public static boolean isRegisteredComponent(@NotNull JComponent component2) {
        UILanguageManager.mustBeInitialized();
        return components.contains(component2);
    }

    @Nullable
    public static String getComponentKey(@NotNull JComponent component2) {
        UILanguageManager.mustBeInitialized();
        TranslationKey translationKey = components.get(component2);
        return translationKey != null ? translationKey.getKey() : null;
    }

    public static void updateComponents() {
        UILanguageManager.mustBeInitialized();
        components.forEach(new BiConsumer<JComponent, TranslationKey>(){

            @Override
            public void accept(@NotNull JComponent component2, @NotNull TranslationKey translationKey) {
                UILanguageManager.updateComponent(component2, new Object[0]);
            }
        });
    }

    public static void updateComponents(final @NotNull Set<String> keys) {
        UILanguageManager.mustBeInitialized();
        components.forEach(new BiConsumer<JComponent, TranslationKey>(){

            @Override
            public void accept(@NotNull JComponent component2, @NotNull TranslationKey translationKey) {
                if (keys.contains(translationKey.getKey())) {
                    UILanguageManager.updateComponent(component2, new Object[0]);
                }
            }
        });
    }

    public static void updateComponent(@NotNull JComponent component2, Object ... data) {
        UILanguageManager.mustBeInitialized();
        TranslationKey translationKey = components.get(component2);
        if (translationKey == null) {
            throw new LanguageException("Component is not registered yet: " + component2);
        }
        Object[] actualData = UILanguageManager.getActualData(component2, translationKey.getKey(), data);
        translationKey.setData(actualData);
        LanguageUpdater updater = UILanguageManager.getLanguageUpdater(component2);
        updater.update(component2, LM.getLanguage(), translationKey.getKey(), translationKey.getData());
    }

    public static void updateComponent(@NotNull JComponent component2, @NotNull String key, Object ... data) {
        UILanguageManager.mustBeInitialized();
        if (!UILanguageManager.isRegisteredComponent(component2)) {
            throw new LanguageException("Component is not registered yet: " + component2);
        }
        Object[] actualData = UILanguageManager.getActualData(component2, key, data);
        TranslationKey translationKey = new TranslationKey(key, actualData);
        components.set(component2, translationKey);
        LanguageUpdater updater = UILanguageManager.getLanguageUpdater(component2);
        updater.update(component2, LM.getLanguage(), translationKey.getKey(), translationKey.getData());
    }

    @Nullable
    private static Object[] getActualData(@NotNull JComponent component2, @NotNull String key, @Nullable Object[] data) {
        Object[] actualData;
        TranslationKey oldKey = components.get(component2);
        if (oldKey != null) {
            actualData = Objects.equals((Object)oldKey.getKey(), (Object)key) ? (ArrayUtils.notEmpty(data) ? data : oldKey.getData()) : data;
        } else {
            throw new LanguageException("Component is not registered yet: " + component2);
        }
        return actualData;
    }

    public static void addLanguageListener(@NotNull JComponent component2, @NotNull LanguageListener listener) {
        componentLanguageListeners.add(component2, listener);
    }

    public static void removeLanguageListener(@NotNull JComponent component2, @NotNull LanguageListener listener) {
        componentLanguageListeners.remove(component2, listener);
    }

    public static void removeLanguageListeners(@NotNull JComponent component2) {
        componentLanguageListeners.clear(component2);
    }

    private static void fireLanguageChanged(final @NotNull Language oldLanguage, final @NotNull Language newLanguage) {
        componentLanguageListeners.forEachData(new BiConsumer<JComponent, LanguageListener>(){

            @Override
            public void accept(@NotNull JComponent component2, @NotNull LanguageListener languageListener) {
                languageListener.languageChanged(oldLanguage, newLanguage);
            }
        });
    }

    public static void addDictionaryListener(@NotNull JComponent component2, @NotNull DictionaryListener listener) {
        componentDictionaryListeners.add(component2, listener);
    }

    public static void removeDictionaryListener(@NotNull JComponent component2, @NotNull DictionaryListener listener) {
        componentDictionaryListeners.remove(component2, listener);
    }

    public static void removeDictionaryListeners(@NotNull JComponent component2) {
        componentDictionaryListeners.clear(component2);
    }

    private static void fireDictionaryAdded(final @NotNull Dictionary dictionary) {
        componentDictionaryListeners.forEachData(new BiConsumer<JComponent, DictionaryListener>(){

            @Override
            public void accept(@NotNull JComponent component2, @NotNull DictionaryListener languageListener) {
                languageListener.dictionaryAdded(dictionary);
            }
        });
    }

    private static void fireDictionaryRemoved(final @NotNull Dictionary dictionary) {
        componentDictionaryListeners.forEachData(new BiConsumer<JComponent, DictionaryListener>(){

            @Override
            public void accept(@NotNull JComponent component2, @NotNull DictionaryListener languageListener) {
                languageListener.dictionaryRemoved(dictionary);
            }
        });
    }

    private static void fireDictionariesCleared() {
        componentDictionaryListeners.forEachData(new BiConsumer<JComponent, DictionaryListener>(){

            @Override
            public void accept(@NotNull JComponent component2, @NotNull DictionaryListener languageListener) {
                languageListener.dictionariesCleared();
            }
        });
    }

    static {
        components = new WeakComponentData("WebLanguageManager.TranslationKey", 100);
        languageUpdaterComparator = new LanguageUpdaterComparator();
        updaters = new ArrayList<LanguageUpdater>(20);
        customUpdaters = new WeakComponentData("WebLanguageManager.LanguageUpdater", 2);
        updatersCache = new HashMap<Class, LanguageUpdater>();
        componentLanguageListeners = new WeakComponentDataOrderedSet("WebLanguageManager.LanguageListener", 50);
        componentDictionaryListeners = new WeakComponentDataOrderedSet("WebLanguageManager.DictionaryListener", 5);
        initialized = false;
    }
}

