/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language;

import com.alee.api.annotations.NotNull;
import com.alee.utils.TextUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class LanguageUtils {
    @NotNull
    private static final Map<String, Locale> localesCache = new HashMap<String, Locale>(5);
    @NotNull
    private static final String COUNTRY_SEPARATOR = "-";

    @NotNull
    public static String toString(@NotNull Locale locale) {
        String lang = (locale.getLanguage() != null ? locale.getLanguage() : "").toLowerCase(Locale.ROOT);
        String country = (locale.getCountry() != null ? locale.getCountry() : "").toUpperCase(Locale.ROOT);
        return lang + (TextUtils.notEmpty(country) ? COUNTRY_SEPARATOR + country : "");
    }

    @NotNull
    public static Locale fromString(@NotNull String locale) {
        int s = locale.indexOf(COUNTRY_SEPARATOR);
        String lang = (s != -1 ? locale.substring(0, s) : locale).toLowerCase(Locale.ROOT);
        String country = (s != -1 ? locale.substring(s + COUNTRY_SEPARATOR.length()) : "").toUpperCase(Locale.ROOT);
        String key = lang + (TextUtils.notEmpty(country) ? COUNTRY_SEPARATOR + country : "");
        if (!localesCache.containsKey(key)) {
            localesCache.put(key, new Locale(lang, country));
        }
        return localesCache.get(key);
    }

    @NotNull
    public static Locale getSystemLocale() {
        Locale locale;
        String language2 = System.getProperty("user.language");
        if (TextUtils.notEmpty(language2)) {
            String country = System.getProperty("user.country");
            String variant = System.getProperty("user.variant");
            locale = new Locale(language2, TextUtils.notEmpty(country) ? country : "", TextUtils.notEmpty(variant) ? variant : "");
        } else {
            locale = new Locale("en", "US");
        }
        return locale;
    }
}

