/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Value;
import com.alee.utils.TextUtils;
import java.io.Serializable;
import java.util.Locale;

public class Language
implements Serializable {
    @NotNull
    protected final Locale locale;

    public Language(@NotNull Locale locale) {
        this.locale = locale;
    }

    @NotNull
    public Locale getLocale() {
        return this.locale;
    }

    @NotNull
    public Dictionary getDictionaries() {
        return LanguageManager.getDictionaries();
    }

    @Nullable
    public Record getRecord(@Nullable String key) {
        return TextUtils.notEmpty(key) ? this.getDictionaries().getRecord(key, this.locale) : null;
    }

    @Nullable
    public Value getValue(@Nullable String key) {
        Record record = this.getRecord(key);
        return record != null ? record.getValue(this.locale) : null;
    }

    @Nullable
    public Text getText(@Nullable String key) {
        Value value = this.getValue(key);
        return value != null ? value.getText() : null;
    }

    @Nullable
    public Text getText(@Nullable String key, @Nullable String state) {
        Value value = this.getValue(key);
        return value != null ? value.getText(state) : null;
    }

    @NotNull
    public String get(@Nullable String key, Object ... data) {
        Text text = this.getText(key);
        return text != null ? text.getText(data) : (key != null ? key : "");
    }

    @NotNull
    public String getState(@Nullable String key, @Nullable String state, Object ... data) {
        Text text = this.getText(key, state);
        return text != null ? text.getText(data) : (key != null ? key : "");
    }

    public int getMnemonic(@Nullable String key) {
        Text text = this.getText(key);
        return text != null ? text.getMnemonic() : -1;
    }

    public int getMnemonic(@Nullable String key, @Nullable String state) {
        Text text = this.getText(key, state);
        return text != null ? text.getMnemonic() : -1;
    }

    public boolean contains(@Nullable String key) {
        return this.getRecord(key) != null;
    }

    public boolean containsText(@Nullable String key) {
        return this.getText(key) != null;
    }

    public boolean containsText(@Nullable String key, @Nullable String state) {
        return this.getText(key, state) != null;
    }

    public boolean equals(@Nullable Object language2) {
        return language2 instanceof Language && Objects.equals((Object)this.getLocale(), (Object)((Language)language2).getLocale());
    }

    @NotNull
    public String toString() {
        return "Language[" + this.locale.toString() + "]";
    }
}

