/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.icon.set;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.behavior.OmitOnClone;
import com.alee.api.merge.Overwriting;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.managers.icon.IconException;
import com.alee.managers.icon.IconManager;
import com.alee.managers.icon.data.IconSource;
import com.alee.managers.icon.set.IconSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;

public abstract class AbstractIconSet
implements IconSet,
Overwriting,
Cloneable,
Serializable {
    @NotNull
    protected final String id;
    @NotNull
    protected final Map<String, IconSource> iconsData;
    @OmitOnClone
    @OmitOnMerge
    @Nullable
    protected transient Map<String, Icon> cache;

    public AbstractIconSet(@NotNull String id) {
        this.id = id;
        this.iconsData = new ConcurrentHashMap<String, IconSource>(50);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isOverwrite() {
        return true;
    }

    @Override
    @NotNull
    public List<String> getIds() {
        return new ArrayList<String>(this.iconsData.keySet());
    }

    @Override
    public void addIcon(@NotNull IconSource icon) {
        this.iconsData.put(icon.getId(), icon);
        if (this.cache != null) {
            this.cache.remove(icon.getId());
        }
        if (IconManager.hasIconSet(this.getId())) {
            IconManager.clearIconCache(icon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Icon findIcon(@NotNull String id) {
        IconSource iconSource;
        Icon icon;
        Icon icon2 = icon = this.cache != null ? this.cache.get(id) : null;
        if (icon == null && (iconSource = this.iconsData.get(id)) != null) {
            try {
                icon = iconSource.loadIcon();
                if (this.cache == null) {
                    AbstractIconSet abstractIconSet = this;
                    synchronized (abstractIconSet) {
                        if (this.cache == null) {
                            this.cache = new ConcurrentHashMap<String, Icon>(30);
                        }
                    }
                }
                this.cache.put(id, icon);
            }
            catch (Exception e) {
                throw new IconException("Unable to load icon: " + id, e);
            }
        }
        return icon;
    }
}

