/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.icon.data;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.resource.Resource;
import com.alee.managers.icon.IconException;
import com.alee.managers.icon.data.IconAdjustment;
import com.alee.managers.icon.data.IconSource;
import com.alee.utils.CollectionUtils;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.List;
import javax.swing.Icon;

public abstract class AbstractIconSource<I extends Icon>
implements IconSource<I> {
    @XStreamAsAttribute
    @NotNull
    protected final String id;
    @XStreamAsAttribute
    @NotNull
    protected final Resource resource;
    @XStreamImplicit
    @Nullable
    protected List<IconAdjustment<I>> adjustments;

    public AbstractIconSource(@NotNull String id, @NotNull Resource resource) {
        this(id, resource, (List)null);
    }

    public AbstractIconSource(@NotNull String id, @NotNull Resource resource, IconAdjustment<I> ... adjustments) {
        this(id, resource, CollectionUtils.asList(adjustments));
    }

    public AbstractIconSource(@NotNull String id, @NotNull Resource resource, @Nullable List<IconAdjustment<I>> adjustments) {
        this.id = id;
        this.resource = resource;
        this.adjustments = adjustments;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isOverwrite() {
        return true;
    }

    @Override
    @NotNull
    public Resource getResource() {
        return this.resource;
    }

    @Override
    @NotNull
    public I loadIcon() {
        try {
            I icon = this.loadIcon(this.resource);
            if (this.adjustments != null) {
                for (IconAdjustment<I> adjustment : this.adjustments) {
                    adjustment.apply(icon);
                }
            }
            return icon;
        }
        catch (Exception e) {
            throw new IconException("Unable to load Icon: " + this.getId(), e);
        }
    }

    @NotNull
    protected abstract I loadIcon(@NotNull Resource var1);
}

