/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.icon;

import com.alee.api.Identifiable;
import com.alee.api.annotations.NotNull;
import com.alee.api.ui.DisabledCopySupplier;
import com.alee.api.ui.TransparentCopySupplier;
import com.alee.managers.icon.IconManager;
import com.alee.utils.ImageUtils;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public final class LazyIcon
implements Icon,
Identifiable,
DisabledCopySupplier<Icon>,
TransparentCopySupplier<Icon> {
    @NotNull
    private final String id;

    public LazyIcon(@NotNull String id) {
        this.id = id;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void paintIcon(@NotNull Component c, @NotNull Graphics g, int x, int y) {
        this.getIcon().paintIcon(c, g, x, y);
    }

    @Override
    public int getIconWidth() {
        return this.getIcon().getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.getIcon().getIconHeight();
    }

    @NotNull
    public <I extends Icon> I getIcon() {
        return IconManager.getIcon(this.getId());
    }

    @Override
    @NotNull
    public Icon createDisabledCopy() {
        return ImageUtils.getDisabledCopy(this.getIcon());
    }

    @Override
    @NotNull
    public Icon createTransparentCopy(float opacity) {
        return ImageUtils.getTransparentCopy(this.getIcon(), opacity);
    }

    @NotNull
    public String toString() {
        return this.getClass().getCanonicalName() + "[id=" + this.getId() + "]";
    }
}

