/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.icon;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.svg.SvgColorOpacity;
import com.alee.extended.svg.SvgFill;
import com.alee.extended.svg.SvgGrayscale;
import com.alee.extended.svg.SvgIconSource;
import com.alee.extended.svg.SvgOpacity;
import com.alee.extended.svg.SvgStroke;
import com.alee.extended.svg.SvgTransform;
import com.alee.managers.icon.IconException;
import com.alee.managers.icon.data.IconSource;
import com.alee.managers.icon.data.ImageIconSource;
import com.alee.managers.icon.data.SetIcon;
import com.alee.managers.icon.set.IconSet;
import com.alee.managers.icon.set.XmlIconSet;
import com.alee.managers.style.StyleManager;
import com.alee.utils.CollectionUtils;
import com.alee.utils.XmlUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.Icon;

public final class IconManager {
    private static List<IconSet> iconSets;
    private static Map<String, WeakReference<Icon>> cache;
    private static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            iconSets = new ArrayList<IconSet>(2);
            cache = new HashMap<String, WeakReference<Icon>>(60);
            XmlUtils.processAnnotations(SetIcon.class);
            XmlUtils.processAnnotations(XmlIconSet.class);
            XmlUtils.processAnnotations(ImageIconSource.class);
            XmlUtils.processAnnotations(SvgIconSource.class);
            XmlUtils.processAnnotations(SvgStroke.class);
            XmlUtils.processAnnotations(SvgFill.class);
            XmlUtils.processAnnotations(SvgOpacity.class);
            XmlUtils.processAnnotations(SvgTransform.class);
            XmlUtils.processAnnotations(SvgGrayscale.class);
            XmlUtils.processAnnotations(SvgColorOpacity.class);
        }
    }

    public static boolean hasIconSet(@NotNull String id) {
        return IconManager.findIconSet(id) != null;
    }

    @NotNull
    public static IconSet getIconSet(@NotNull String id) {
        IconSet iconSet = IconManager.findIconSet(id);
        if (iconSet == null) {
            throw new IconException("IconSet with identifier doesn't exist: " + id);
        }
        return iconSet;
    }

    @Nullable
    public static IconSet findIconSet(@NotNull String id) {
        IconSet iconSet = null;
        for (IconSet set : iconSets) {
            if (!set.getId().equals(id)) continue;
            iconSet = set;
            break;
        }
        if (iconSet != null) {
            for (IconSet set : StyleManager.getSkin().getIconSets()) {
                if (!set.getId().equals(id)) continue;
                iconSet = set;
                break;
            }
        }
        return iconSet;
    }

    public static void addIconSet(@NotNull IconSet iconSet) {
        if (IconManager.hasIconSet(iconSet.getId())) {
            if (iconSets.contains(iconSet)) {
                throw new IconException("Specified IconSet is already added: " + iconSet.getId());
            }
            throw new IconException("Different IconSet with the same identifier is already added: " + iconSet.getId());
        }
        iconSets.add(iconSet);
        IconManager.clearIconSetCache(iconSet);
    }

    public static void removeIconSet(@NotNull IconSet iconSet) {
        IconSet existingIconSet = IconManager.getIconSet(iconSet.getId());
        if (existingIconSet == iconSet) {
            if (!iconSets.contains(iconSet)) {
                throw new IconException("Skin and SkinExtension IconSets cannot be removed from IconManager: " + iconSet.getId());
            }
        } else {
            throw new IconException("Specified IconSet is different from existing one with the same identifier: " + iconSet.getId());
        }
        iconSets.remove(iconSet);
        IconManager.clearIconSetCache(iconSet);
    }

    public static void clearIconSetCache(@NotNull IconSet iconSet) {
        for (String id : iconSet.getIds()) {
            cache.remove(id);
        }
    }

    public static void clearIconCache(@NotNull IconSource icon) {
        cache.remove(icon.getId());
    }

    public static void clearIconCaches() {
        cache.clear();
    }

    public static boolean hasIcon(@NotNull String id) {
        return IconManager.findIcon(id) != null;
    }

    @NotNull
    public static <I extends Icon> I getIcon(@NotNull String id) {
        I icon = IconManager.findIcon(id);
        if (icon != null) {
            return icon;
        }
        throw new IconException("Could not find Icon for identifier: " + id);
    }

    @Nullable
    public static <I extends Icon> I findIcon(@NotNull String id) {
        Icon icon;
        WeakReference<Icon> reference = cache.get(id);
        Icon icon2 = icon = reference != null ? (Icon)reference.get() : null;
        if (icon == null) {
            icon = IconManager.findIcon(id, iconSets);
            if (icon == null) {
                icon = IconManager.findIcon(id, StyleManager.getSkin().getIconSets());
            }
            cache.put(id, new WeakReference<Icon>(icon));
        }
        return (I)icon;
    }

    @Nullable
    private static <I extends Icon> I findIcon(@NotNull String id, List<IconSet> iconSets) {
        Icon icon;
        block1: {
            icon = null;
            if (!CollectionUtils.notEmpty(iconSets)) break block1;
            ListIterator<IconSet> iter = iconSets.listIterator(iconSets.size());
            while (iter.hasPrevious() && (icon = iter.previous().findIcon(id)) == null) {
            }
        }
        return (I)icon;
    }

    static {
        initialized = false;
    }
}

