/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.hover;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.hover.HoverManager;
import com.alee.managers.hover.HoverTracker;
import com.alee.utils.CoreSwingUtils;
import java.awt.Component;
import javax.swing.JComponent;

public abstract class DefaultHoverTracker
implements HoverTracker {
    @NotNull
    protected final JComponent component;
    protected boolean directHoverOnly;
    protected boolean enabled;
    protected boolean hovered;

    public DefaultHoverTracker(@NotNull JComponent component2, boolean directHoverOnly) {
        this.component = component2;
        this.directHoverOnly = directHoverOnly;
        this.enabled = true;
        this.hovered = this.isInvolved(component2, HoverManager.getHoverOwner());
    }

    public boolean isDirectHoverOnly() {
        return this.directHoverOnly;
    }

    public void setDirectHoverOnly(boolean directHoverOnly) {
        this.directHoverOnly = directHoverOnly;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.component.isShowing();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isHovered() {
        return this.hovered;
    }

    @Override
    public void setHovered(boolean hovered) {
        this.hovered = hovered;
    }

    @Override
    public boolean isInvolved(@NotNull JComponent tracked, @Nullable Component component2) {
        return tracked == component2 || !this.directHoverOnly && CoreSwingUtils.isAncestorOf(tracked, component2);
    }
}

