/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.hotkey;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.BiConsumer;
import com.alee.api.jdk.BiPredicate;
import com.alee.api.jdk.Function;
import com.alee.managers.hotkey.ButtonHotkeyRunnable;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyCondition;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.hotkey.HotkeyInfo;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.compare.Filter;
import com.alee.utils.swing.WeakComponentDataOrderedSet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

@Deprecated
public final class HotkeyManager {
    private static final String HOTKEYS_SEPARATOR = ", ";
    private static final Function<HotkeyInfo, String> HOTKEY_TEXT_PROVIDER = new Function<HotkeyInfo, String>(){

        @Override
        public String apply(HotkeyInfo hotkeyInfo) {
            return hotkeyInfo.getHotkeyData().toString();
        }
    };
    private static final Filter<HotkeyInfo> HOTKEY_DISPLAY_FILTER = new Filter<HotkeyInfo>(){

        @Override
        public boolean accept(HotkeyInfo object) {
            return !object.isHidden();
        }
    };
    private static boolean hotkeysEnabled = true;
    private static boolean transferFocus = false;
    private static final WeakComponentDataOrderedSet<JComponent, HotkeyInfo> hotkeys = new WeakComponentDataOrderedSet("HotkeyManager.HotkeyInfo", 20);
    private static final List<HotkeyInfo> globalHotkeys = new ArrayList<HotkeyInfo>(2);
    @Deprecated
    private static final WeakComponentDataOrderedSet<JComponent, HotkeyCondition> containerConditions = new WeakComponentDataOrderedSet("HotkeyManager.HotkeyCondition", 5);
    private static boolean initialized = false;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            XmlUtils.processAnnotations(HotkeyData.class);
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(@NotNull AWTEvent event) {
                    KeyEvent e;
                    if (hotkeysEnabled && event instanceof KeyEvent && !(e = (KeyEvent)event).isConsumed() && e.getID() == 401 && HotkeyManager.hotkeyForEventExists(e)) {
                        HotkeyManager.processHotkeys(e);
                    }
                }
            }, 8L);
        }
    }

    private static boolean hotkeyForEventExists(final @NotNull KeyEvent keyEvent) {
        boolean exists = false;
        for (HotkeyInfo hotkeyInfo : globalHotkeys) {
            if (!hotkeyInfo.getHotkeyData().isTriggered(keyEvent)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            exists = hotkeys.anyDataMatch(new BiPredicate<JComponent, HotkeyInfo>(){

                @Override
                public boolean test(@NotNull JComponent component2, @NotNull HotkeyInfo hotkeyInfo) {
                    return hotkeyInfo.getHotkeyData().isTriggered(keyEvent);
                }
            });
        }
        return exists;
    }

    private static void processHotkeys(final @NotNull KeyEvent e) {
        for (HotkeyInfo hotkeyInfo : globalHotkeys) {
            HotkeyManager.processHotkey(e, hotkeyInfo);
        }
        hotkeys.forEachData(new BiConsumer<JComponent, HotkeyInfo>(){

            @Override
            public void accept(@NotNull JComponent component2, @NotNull HotkeyInfo hotkeyInfo) {
                HotkeyManager.processHotkey(e, hotkeyInfo);
            }
        });
    }

    private static void processHotkey(@NotNull KeyEvent e, @NotNull HotkeyInfo hotkeyInfo) {
        JComponent forComponent = hotkeyInfo.getForComponent();
        if (forComponent == null) {
            if (hotkeyInfo.getHotkeyData().isTriggered(e) && hotkeyInfo.getAction() != null) {
                HotkeyManager.invokeLater(hotkeyInfo.getAction(), e);
            }
        } else {
            Component topComponent = hotkeyInfo.getTopComponent();
            Component component2 = topComponent = topComponent != null ? topComponent : CoreSwingUtils.getWindowAncestor(forComponent);
            if (SwingUtils.hasFocusOwner(topComponent) && hotkeyInfo.getHotkeyData().isTriggered(e) && hotkeyInfo.getAction() != null && HotkeyManager.meetsParentConditions(forComponent)) {
                if (transferFocus) {
                    ((Component)forComponent).requestFocusInWindow();
                }
                HotkeyManager.invokeLater(hotkeyInfo.getAction(), e);
            }
        }
    }

    private static void invokeLater(final HotkeyRunnable runnable, final KeyEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run(e);
        } else {
            CoreSwingUtils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    runnable.run(e);
                }
            });
        }
    }

    private static boolean meetsParentConditions(final Component forComponent) {
        return containerConditions.allDataMatch(new BiPredicate<JComponent, HotkeyCondition>(){

            @Override
            public boolean test(JComponent component2, HotkeyCondition hotkeyCondition) {
                return !component2.isAncestorOf(forComponent) || hotkeyCondition.checkCondition(forComponent);
            }
        });
    }

    public static HotkeyInfo registerHotkey(HotkeyData hotkeyData, HotkeyRunnable action) {
        HotkeyInfo hotkeyInfo = new HotkeyInfo();
        hotkeyInfo.setHidden(true);
        hotkeyInfo.setHotkeyData(hotkeyData);
        hotkeyInfo.setAction(action);
        HotkeyManager.cacheHotkey(hotkeyInfo);
        return hotkeyInfo;
    }

    public static HotkeyInfo registerHotkey(JComponent forComponent, HotkeyData hotkeyData, HotkeyRunnable action) {
        return HotkeyManager.registerHotkey(null, forComponent, hotkeyData, action);
    }

    public static HotkeyInfo registerHotkey(JComponent forComponent, HotkeyData hotkeyData, HotkeyRunnable action, boolean hidden) {
        return HotkeyManager.registerHotkey(null, forComponent, hotkeyData, action, hidden);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, JComponent forComponent, HotkeyData hotkeyData, HotkeyRunnable action) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, action, false);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, JComponent forComponent, HotkeyData hotkeyData, HotkeyRunnable action, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, action, false, tooltipWay);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, JComponent forComponent, HotkeyData hotkeyData, HotkeyRunnable action, boolean hidden) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, action, hidden, null);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, JComponent forComponent, HotkeyData hotkeyData, HotkeyRunnable action, boolean hidden, TooltipWay tooltipWay) {
        HotkeyInfo hotkeyInfo = new HotkeyInfo();
        hotkeyInfo.setHidden(hidden);
        hotkeyInfo.setTopComponent(topComponent);
        hotkeyInfo.setForComponent(forComponent);
        hotkeyInfo.setHotkeyData(hotkeyData);
        hotkeyInfo.setHotkeyDisplayWay(tooltipWay);
        hotkeyInfo.setAction(action);
        HotkeyManager.cacheHotkey(hotkeyInfo);
        return hotkeyInfo;
    }

    public static HotkeyInfo registerHotkey(AbstractButton forComponent, HotkeyData hotkeyData) {
        return HotkeyManager.registerHotkey(null, forComponent, hotkeyData);
    }

    public static HotkeyInfo registerHotkey(AbstractButton forComponent, HotkeyData hotkeyData, boolean hidden) {
        return HotkeyManager.registerHotkey(null, forComponent, hotkeyData, hidden);
    }

    public static HotkeyInfo registerHotkey(AbstractButton forComponent, HotkeyData hotkeyData, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey(null, forComponent, hotkeyData, tooltipWay);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, AbstractButton forComponent, HotkeyData hotkeyData) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, false);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, AbstractButton forComponent, HotkeyData hotkeyData, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, HotkeyManager.createAction(forComponent), false, tooltipWay);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, AbstractButton forComponent, HotkeyData hotkeyData, boolean hidden) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, HotkeyManager.createAction(forComponent), hidden, null);
    }

    private static HotkeyRunnable createAction(AbstractButton forComponent) {
        return new ButtonHotkeyRunnable(forComponent);
    }

    public static void addContainerHotkeyCondition(JComponent container, HotkeyCondition hotkeyCondition) {
        containerConditions.add(container, hotkeyCondition);
    }

    public static void removeContainerHotkeyCondition(JComponent container, HotkeyCondition hotkeyCondition) {
        containerConditions.remove(container, hotkeyCondition);
    }

    public static void removeContainerHotkeyConditions(JComponent container, List<HotkeyCondition> hotkeyConditions) {
        for (HotkeyCondition hotkeyCondition : hotkeyConditions) {
            containerConditions.remove(container, hotkeyCondition);
        }
    }

    public static void removeContainerHotkeyConditions(JComponent container) {
        containerConditions.clear(container);
    }

    public static List<HotkeyCondition> getContainerHotkeyConditions(JComponent container) {
        LinkedHashSet list = (LinkedHashSet)containerConditions.get(container);
        return list != null ? CollectionUtils.copy(list) : new ArrayList<HotkeyCondition>();
    }

    public static void unregisterHotkey(HotkeyInfo hotkeyInfo) {
        HotkeyManager.clearHotkeyCache(hotkeyInfo);
    }

    public static void unregisterHotkeys(JComponent component2) {
        HotkeyManager.clearHotkeysCache(component2);
    }

    private static void cacheHotkey(HotkeyInfo hotkeyInfo) {
        JComponent forComponent = hotkeyInfo.getForComponent();
        if (forComponent != null) {
            hotkeys.add(forComponent, hotkeyInfo);
        } else if (!globalHotkeys.contains(hotkeyInfo)) {
            globalHotkeys.add(hotkeyInfo);
        }
    }

    private static void clearHotkeyCache(HotkeyInfo hotkeyInfo) {
        if (hotkeyInfo != null) {
            JComponent forComponent = hotkeyInfo.getForComponent();
            if (forComponent != null) {
                hotkeys.remove(forComponent, hotkeyInfo);
            } else {
                globalHotkeys.remove(hotkeyInfo);
            }
        }
    }

    private static void clearHotkeysCache(JComponent component2) {
        hotkeys.clear(component2);
    }

    public static List<HotkeyInfo> getComponentHotkeys(JComponent component2) {
        LinkedHashSet list = (LinkedHashSet)hotkeys.get(component2);
        return list != null ? CollectionUtils.copy(list) : new ArrayList<HotkeyInfo>();
    }

    public static void showComponentHotkeys() {
        TooltipManager.hideAllTooltips();
        for (Window window : Window.getWindows()) {
            HotkeyManager.showComponentHotkeys(window);
        }
    }

    public static void showComponentHotkeys(Component component2) {
        TooltipManager.hideAllTooltips();
        HotkeyManager.showComponentHotkeys(CoreSwingUtils.getNonNullWindowAncestor(component2));
    }

    private static void showComponentHotkeys(final Window window) {
        final LinkedHashSet shown = new LinkedHashSet();
        hotkeys.forEachData(new BiConsumer<JComponent, HotkeyInfo>(){

            @Override
            public void accept(JComponent component2, HotkeyInfo hotkeyInfo) {
                JComponent forComponent;
                if (!hotkeyInfo.isHidden() && (forComponent = hotkeyInfo.getForComponent()) != null && !shown.contains(forComponent) && forComponent.isVisible() && forComponent.isShowing() && CoreSwingUtils.getWindowAncestor(forComponent) == window) {
                    String hotkey = HotkeyManager.getComponentHotkeysString(forComponent);
                    TooltipWay displayWay = hotkeyInfo.getHotkeyDisplayWay();
                    TooltipManager.showOneTimeTooltip(forComponent, null, hotkey, displayWay);
                    shown.add(forComponent);
                }
            }
        });
    }

    public static void installShowAllHotkeysAction(JComponent topComponent) {
        HotkeyManager.installShowAllHotkeysAction(topComponent, Hotkey.F1);
    }

    public static void installShowAllHotkeysAction(final JComponent topComponent, HotkeyData hotkeyData) {
        HotkeyManager.registerHotkey((Component)topComponent, topComponent, hotkeyData, new HotkeyRunnable(){

            @Override
            public void run(@NotNull KeyEvent e) {
                HotkeyManager.showComponentHotkeys(topComponent);
            }
        }, true);
    }

    public static String getComponentHotkeysString(JComponent component2) {
        LinkedHashSet keys = (LinkedHashSet)hotkeys.get(component2);
        return TextUtils.collectionToString(keys, HOTKEYS_SEPARATOR, HOTKEY_TEXT_PROVIDER, HOTKEY_DISPLAY_FILTER);
    }

    public static void disableHotkeys() {
        hotkeysEnabled = false;
    }

    public static void enableHotkeys() {
        hotkeysEnabled = true;
    }

    public static boolean isTransferFocus() {
        return transferFocus;
    }

    public static void setTransferFocus(boolean transferFocus) {
        HotkeyManager.transferFocus = transferFocus;
    }
}

