/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.hotkey;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.managers.hotkey.HotkeyException;
import com.alee.utils.SwingUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import javax.swing.KeyStroke;

@XStreamAlias(value="HotkeyData")
public class HotkeyData
implements Cloneable,
Serializable {
    @XStreamAsAttribute
    protected final boolean isCtrl;
    @XStreamAsAttribute
    protected final boolean isAlt;
    @XStreamAsAttribute
    protected final boolean isShift;
    @XStreamAsAttribute
    @Nullable
    protected final Integer keyCode;

    public HotkeyData() {
        this(false, false, false, null);
    }

    public HotkeyData(@NotNull KeyEvent keyEvent) {
        this(SwingUtils.isCtrl(keyEvent), SwingUtils.isAlt(keyEvent), SwingUtils.isShift(keyEvent), keyEvent.getKeyCode());
    }

    public HotkeyData(@NotNull KeyStroke keyStroke) {
        this(SwingUtils.isCtrl(keyStroke.getModifiers()), SwingUtils.isAlt(keyStroke.getModifiers()), SwingUtils.isShift(keyStroke.getModifiers()), keyStroke.getKeyCode());
    }

    public HotkeyData(Integer keyCode) {
        this(false, false, false, keyCode);
    }

    public HotkeyData(boolean isCtrl, boolean isAlt, boolean isShift, @Nullable Integer keyCode) {
        this.isCtrl = isCtrl;
        this.isAlt = isAlt;
        this.isShift = isShift;
        this.keyCode = keyCode;
    }

    public boolean isCtrl() {
        return this.isCtrl;
    }

    public boolean isAlt() {
        return this.isAlt;
    }

    public boolean isShift() {
        return this.isShift;
    }

    @Nullable
    public Integer getKeyCode() {
        return this.keyCode;
    }

    public int getModifiers() {
        return (this.isCtrl ? SwingUtils.getSystemShortcutModifier() : 0) | (this.isAlt ? 8 : 0) | (this.isShift ? 1 : 0);
    }

    public boolean isHotkeySet() {
        return this.keyCode != null;
    }

    public boolean isTriggered(@NotNull KeyEvent event) {
        return this.areControlsTriggered(event) && this.isKeyTriggered(event);
    }

    public boolean areControlsTriggered(@NotNull KeyEvent event) {
        return SwingUtils.isShortcut(event) == this.isCtrl && SwingUtils.isAlt(event) == this.isAlt && SwingUtils.isShift(event) == this.isShift;
    }

    public boolean isKeyTriggered(@NotNull KeyEvent event) {
        return this.keyCode != null && event.getKeyCode() == this.keyCode.intValue();
    }

    @NotNull
    public KeyStroke getKeyStroke() {
        if (this.keyCode == null) {
            throw new HotkeyException("KeyStroke can only be retrieved from HotkeyData that contains key code");
        }
        return KeyStroke.getKeyStroke(this.keyCode, this.getModifiers());
    }

    public int hashCode() {
        return Objects.hash(this.isCtrl, this.isAlt, this.isShift, this.keyCode);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof HotkeyData && other.hashCode() == this.hashCode();
    }

    @NotNull
    public String toString() {
        return SwingUtils.hotkeyToString(this.isCtrl(), this.isAlt(), this.isShift(), this.getKeyCode());
    }
}

