/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.focus;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.BiConsumer;
import com.alee.managers.focus.FocusTracker;
import com.alee.managers.focus.GlobalFocusListener;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.swing.WeakComponentDataOrderedSet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;

public final class FocusManager {
    @NotNull
    private static final List<GlobalFocusListener> globalFocusListeners = new ArrayList<GlobalFocusListener>(5);
    @NotNull
    private static final WeakComponentDataOrderedSet<JComponent, GlobalFocusListener> globalComponentFocusListeners = new WeakComponentDataOrderedSet("FocusManager.GlobalFocusListener", 5);
    @NotNull
    private static final WeakComponentDataOrderedSet<JComponent, FocusTracker> trackers = new WeakComponentDataOrderedSet("FocusManager.FocusTracker", 200);
    private static WeakReference<Component> previousFocusOwner;
    private static WeakReference<Component> focusOwner;
    private static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            previousFocusOwner = new WeakReference<Object>(null);
            focusOwner = new WeakReference<Component>(javax.swing.FocusManager.getCurrentManager().getFocusOwner());
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    FocusEvent focusEvent = (FocusEvent)event;
                    if (focusEvent.getID() == 1005 && focusEvent.getOppositeComponent() == null) {
                        FocusManager.fireFocusChanged(focusEvent.getComponent(), null);
                    } else if (focusEvent.getID() == 1004) {
                        FocusManager.fireFocusChanged(focusEvent.getOppositeComponent(), focusEvent.getComponent());
                    }
                }
            }, 4L);
        }
    }

    @Nullable
    public static Component getPreviousFocusOwner() {
        return (Component)previousFocusOwner.get();
    }

    @Nullable
    public static Component getFocusOwner() {
        return focusOwner != null ? (Component)focusOwner.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerGlobalFocusListener(@NotNull GlobalFocusListener listener) {
        List<GlobalFocusListener> list = globalFocusListeners;
        synchronized (list) {
            globalFocusListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterGlobalFocusListener(@NotNull GlobalFocusListener listener) {
        List<GlobalFocusListener> list = globalFocusListeners;
        synchronized (list) {
            globalFocusListeners.remove(listener);
        }
    }

    public static void registerGlobalFocusListener(@NotNull JComponent component2, @NotNull GlobalFocusListener listener) {
        globalComponentFocusListeners.add(component2, listener);
    }

    public static void unregisterGlobalFocusListener(@NotNull JComponent component2, @NotNull GlobalFocusListener listener) {
        globalComponentFocusListeners.remove(component2, listener);
    }

    public static void addFocusTracker(@NotNull JComponent component2, @NotNull FocusTracker focusTracker) {
        trackers.add(component2, focusTracker);
    }

    public static void removeFocusTracker(@NotNull JComponent component2, @NotNull FocusTracker focusTracker) {
        trackers.remove(component2, focusTracker);
    }

    public static void removeFocusTrackers(@NotNull JComponent component2) {
        trackers.clear(component2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireFocusChanged(final @Nullable Component oldFocus, final @Nullable Component newFocus) {
        ImmutableList<GlobalFocusListener> globalListenersCopy;
        previousFocusOwner = new WeakReference<Component>(oldFocus);
        focusOwner = new WeakReference<Component>(newFocus);
        trackers.forEachData(new BiConsumer<JComponent, FocusTracker>(){

            @Override
            public void accept(JComponent tracked, FocusTracker focusTracker) {
                if (focusTracker.isEnabled()) {
                    boolean isOldFocused = focusTracker.isInvolved(tracked, oldFocus);
                    boolean isNewFocused = focusTracker.isInvolved(tracked, newFocus);
                    if ((isOldFocused || isNewFocused) && focusTracker.isFocused() != isNewFocused) {
                        focusTracker.setFocused(isNewFocused);
                        focusTracker.focusChanged(isNewFocused);
                    }
                }
            }
        });
        globalComponentFocusListeners.forEachData(new BiConsumer<JComponent, GlobalFocusListener>(){

            @Override
            public void accept(JComponent component2, GlobalFocusListener listener) {
                listener.focusChanged(oldFocus, newFocus);
            }
        });
        List<GlobalFocusListener> list = globalFocusListeners;
        synchronized (list) {
            globalListenersCopy = new ImmutableList<GlobalFocusListener>((Collection<GlobalFocusListener>)globalFocusListeners);
        }
        for (GlobalFocusListener listener : globalListenersCopy) {
            listener.focusChanged(oldFocus, newFocus);
        }
    }

    static {
        initialized = false;
    }
}

